/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.data.Port;
import net.algart.executors.modules.core.common.io.WriteFileOperation;

public final class WriteScalar
extends WriteFileOperation {
    private boolean deleteFileIfEmpty = false;
    private String charset = "UTF-8";
    private String scalarContent = "";

    public WriteScalar() {
        this.addFileOperationPorts();
        this.addInputScalar(DEFAULT_INPUT_PORT);
    }

    public static WriteScalar getInstance() {
        return new WriteScalar();
    }

    public boolean isDeleteFileIfEmpty() {
        return this.deleteFileIfEmpty;
    }

    public WriteScalar setDeleteFileIfEmpty(boolean deleteFileIfEmpty) {
        this.deleteFileIfEmpty = deleteFileIfEmpty;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public WriteScalar setCharset(String charset) {
        this.charset = WriteScalar.nonEmpty(charset).trim();
        return this;
    }

    public String getScalarContent() {
        return this.scalarContent;
    }

    public WriteScalar setScalarContent(String scalarContent) {
        this.scalarContent = WriteScalar.nonNull(scalarContent);
        return this;
    }

    @Override
    public WriteScalar setFile(String file) {
        super.setFile(file);
        return this;
    }

    @Override
    public void process() {
        this.writeString(this.getInputScalar(true).getValue());
    }

    public void writeString(String scalar) {
        Path path = this.completeFilePath();
        String s = scalar != null ? scalar : this.scalarContent;
        try {
            if (s.isEmpty()) {
                if (this.deleteFileIfEmpty) {
                    WriteScalar.logDebug(() -> "Removing file " + String.valueOf(path.toAbsolutePath()));
                    Files.deleteIfExists(path);
                }
            } else {
                WriteScalar.logDebug(() -> "Writing UTF-8 scalar (" + s.length() + " characters) to file " + String.valueOf(path.toAbsolutePath()));
                WriteScalar.writeString(path, s, this.charset);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT);
    }

    public static void writeString(Path file, String s, String charset) throws IOException {
        Files.writeString(file, (CharSequence)s, Charset.forName(charset), new OpenOption[0]);
    }
}

