/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.misc;

import java.util.ArrayList;
import net.algart.arrays.Arrays;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;

public final class SetArrayLength
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_PORT_PREFIX = "input_";
    public static final String OUTPUT_PORT_PREFIX = "output_";
    private int minNumberOfBlocks = 0;
    private int maxNumberOfBlocks = Integer.MAX_VALUE;
    private FillingMode fillingMode = FillingMode.NAN;
    private double filler = 0.0;

    public int getMinNumberOfBlocks() {
        return this.minNumberOfBlocks;
    }

    public SetArrayLength setMinNumberOfBlocks(int minNumberOfBlocks) {
        this.minNumberOfBlocks = SetArrayLength.nonNegative(minNumberOfBlocks);
        return this;
    }

    public SetArrayLength setMinNumberOfBlocks(String minNumberOfBlocks) {
        this.minNumberOfBlocks = SetArrayLength.nonNegative(SetArrayLength.intOrDefault(minNumberOfBlocks, 0));
        return this;
    }

    public int getMaxNumberOfBlocks() {
        return this.maxNumberOfBlocks;
    }

    public SetArrayLength setMaxNumberOfBlocks(int maxNumberOfBlocks) {
        this.maxNumberOfBlocks = SetArrayLength.nonNegative(maxNumberOfBlocks);
        return this;
    }

    public SetArrayLength setMaxNumberOfBlocks(String maxNumberOfBlocks) {
        this.maxNumberOfBlocks = SetArrayLength.nonNegative(SetArrayLength.intOrDefault(maxNumberOfBlocks, Integer.MAX_VALUE));
        return this;
    }

    public FillingMode getFillingMode() {
        return this.fillingMode;
    }

    public SetArrayLength setFillingMode(FillingMode fillingMode) {
        this.fillingMode = SetArrayLength.nonNull(fillingMode);
        return this;
    }

    public double getFiller() {
        return this.filler;
    }

    public SetArrayLength setFiller(double filler) {
        this.filler = filler;
        return this;
    }

    @Override
    public void process() {
        String portName;
        ArrayList<SNumbers> sourceList = new ArrayList<SNumbers>();
        int requiredNumberOfBlocks = 0;
        int k = 0;
        while (this.hasInputPort(portName = this.inputPortName(k))) {
            SNumbers numbers = this.getInputNumbers(portName, true);
            if (numbers.isInitialized()) {
                requiredNumberOfBlocks = Math.max(requiredNumberOfBlocks, numbers.n());
            }
            sourceList.add(numbers);
            ++k;
        }
        requiredNumberOfBlocks = Math.max(requiredNumberOfBlocks, this.minNumberOfBlocks);
        requiredNumberOfBlocks = Math.min(requiredNumberOfBlocks, this.maxNumberOfBlocks);
        int n = sourceList.size();
        for (k = 0; k < n; ++k) {
            SNumbers source;
            String portName2 = this.outputPortName(k);
            if (!this.hasOutputPort(portName2) || !(source = (SNumbers)sourceList.get(k)).isInitialized()) continue;
            SNumbers result = SNumbers.zeros(source.elementType(), requiredNumberOfBlocks, source.getBlockLength());
            if (this.fillingMode != FillingMode.ZEROS) {
                result.setTo((PNumberArray)Arrays.asIndexFuncArray((Func)ConstantFunc.getInstance((double)this.fillingMode.filler(this.filler)), (Class)Arrays.type(PNumberArray.class, result.elementType()), (long)result.getArrayLength()), result.getBlockLength());
            }
            result.replaceBlockRange(0, source, 0, Math.min(source.n(), requiredNumberOfBlocks));
            this.getNumbers(portName2).exchange(result);
        }
    }

    @Override
    public String visibleOutputPortName() {
        return this.firstInitializedPortName();
    }

    public String inputPortName(int inputIndex) {
        return INPUT_PORT_PREFIX + (inputIndex + 1);
    }

    public String outputPortName(int outputIndex) {
        return OUTPUT_PORT_PREFIX + (outputIndex + 1);
    }

    private String firstInitializedPortName() {
        String portName;
        int k = 0;
        while (this.hasInputPort(portName = this.inputPortName(k))) {
            if (this.getInputNumbers(portName, true).isInitialized()) {
                return this.outputPortName(k);
            }
            ++k;
        }
        return null;
    }

    public static enum FillingMode {
        ZEROS(0.0),
        NAN(Double.NaN),
        CUSTOM(null);

        private final Double filler;

        private FillingMode(Double filler) {
            this.filler = filler;
        }

        public double filler(double defaultValue) {
            return this.filler != null ? this.filler : defaultValue;
        }
    }
}

