/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.io;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Locale;
import java.util.Objects;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.io.WriteFileOperation;

public final class WriteCSVNumbers
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_HEADERS = "headers";
    private boolean requireInput = false;
    private boolean clearFileOnReset = false;
    private boolean appendToExistingFile = false;
    private boolean deleteFileIfNonInitialized = false;
    private String copyOfPreviousFileIfNonInitialized = "";
    private String delimiter = ",";
    private LineDelimiter lineDelimiter = LineDelimiter.CRLF;
    private String format = "";
    private boolean simpleFormatForIntegers = true;

    public WriteCSVNumbers() {
        this.addFileOperationPorts();
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addInputScalar(INPUT_HEADERS);
    }

    public static WriteCSVNumbers getInstance() {
        return new WriteCSVNumbers();
    }

    @Override
    public WriteCSVNumbers setFile(String file) {
        super.setFile(file);
        return this;
    }

    public boolean requireInput() {
        return this.requireInput;
    }

    public WriteCSVNumbers setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    public boolean isClearFileOnReset() {
        return this.clearFileOnReset;
    }

    public WriteCSVNumbers setClearFileOnReset(boolean clearFileOnReset) {
        this.clearFileOnReset = clearFileOnReset;
        return this;
    }

    public boolean isAppendToExistingFile() {
        return this.appendToExistingFile;
    }

    public WriteCSVNumbers setAppendToExistingFile(boolean appendToExistingFile) {
        this.appendToExistingFile = appendToExistingFile;
        return this;
    }

    public boolean isDeleteFileIfNonInitialized() {
        return this.deleteFileIfNonInitialized;
    }

    public WriteCSVNumbers setDeleteFileIfNonInitialized(boolean deleteFileIfNonInitialized) {
        this.deleteFileIfNonInitialized = deleteFileIfNonInitialized;
        return this;
    }

    public String getCopyOfPreviousFileIfNonInitialized() {
        return this.copyOfPreviousFileIfNonInitialized;
    }

    public WriteCSVNumbers setCopyOfPreviousFileIfNonInitialized(String copyOfPreviousFileIfNonInitialized) {
        this.copyOfPreviousFileIfNonInitialized = WriteCSVNumbers.nonNull(copyOfPreviousFileIfNonInitialized);
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public WriteCSVNumbers setDelimiter(String delimiter) {
        this.delimiter = WriteCSVNumbers.nonEmpty(delimiter);
        return this;
    }

    public LineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public WriteCSVNumbers setLineDelimiter(LineDelimiter lineDelimiter) {
        this.lineDelimiter = WriteCSVNumbers.nonNull(lineDelimiter);
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public WriteCSVNumbers setFormat(String format) {
        this.format = WriteCSVNumbers.nonNull(format).trim();
        return this;
    }

    public boolean isSimpleFormatForIntegers() {
        return this.simpleFormatForIntegers;
    }

    public WriteCSVNumbers setSimpleFormatForIntegers(boolean simpleFormatForIntegers) {
        this.simpleFormatForIntegers = simpleFormatForIntegers;
        return this;
    }

    @Override
    public void initialize() {
        if (this.clearFileOnReset) {
            try {
                Files.deleteIfExists(this.completeFilePath());
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    @Override
    public void process() {
        SNumbers numbers = this.getInputNumbers(this.deleteFileIfNonInitialized || !this.requireInput);
        if (this.requireInput || numbers.isInitialized()) {
            SScalar inputHeader = this.getInputScalar(INPUT_HEADERS, true);
            this.writeCSV(numbers, inputHeader.toTrimmedLinesWithoutCommentsArray());
        }
    }

    public void writeCSV(SNumbers numbers, String[] headers) {
        block10: {
            Objects.requireNonNull(numbers, "Null numbers");
            Path csvFile = this.completeFilePath();
            try {
                boolean exists = Files.exists(csvFile, new LinkOption[0]);
                if (!numbers.isInitialized() && this.deleteFileIfNonInitialized) {
                    if (exists) {
                        String copyOfPreviousFile = this.copyOfPreviousFileIfNonInitialized.trim();
                        if (!copyOfPreviousFile.isEmpty()) {
                            Files.copy(csvFile, Paths.get(copyOfPreviousFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        WriteCSVNumbers.logDebug(() -> "Removing file " + String.valueOf(csvFile.toAbsolutePath()));
                        Files.delete(csvFile);
                    }
                    break block10;
                }
                WriteCSVNumbers.logDebug(() -> "Writing number array (" + String.valueOf(numbers) + ") to file " + String.valueOf(csvFile.toAbsolutePath()));
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile.toFile(), this.appendToExistingFile), StandardCharsets.UTF_8));){
                    this.writeCSV(writer, numbers, headers, !exists || !this.appendToExistingFile);
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT).addPorts(this.getInputPort(INPUT_HEADERS));
    }

    public void writeCSV(Writer writer, SNumbers numbers, String[] headers, boolean addHeader) throws IOException {
        Objects.requireNonNull(writer, "Null writer argument");
        Objects.requireNonNull(numbers, "Null numbers argument");
        if (headers == null) {
            headers = new String[]{};
        }
        if (addHeader) {
            writer.write(this.makeHeader(numbers, headers));
        }
        SNumbers.Formatter formatter = numbers.getFormatter(this.format.isEmpty() ? SNumbers.FormattingType.SIMPLE : SNumbers.FormattingType.PRINTF, Locale.US).setSimpleFormatForIntegers(this.simpleFormatForIntegers).setLinesDelimiter(this.lineDelimiter.delimiter).setElementsFormat(this.format).setElementsDelimiter(this.delimiter);
        writer.write(formatter.format());
        writer.flush();
    }

    private String makeHeader(SNumbers numbers, String[] headers) {
        StringBuilder sb = new StringBuilder();
        int blockLength = numbers.getBlockLength();
        for (int j = 0; j < blockLength; ++j) {
            if (j > 0) {
                sb.append(this.delimiter);
            }
            if (j < headers.length) {
                sb.append(headers[j].trim());
                continue;
            }
            sb.append(numbers.elementType()).append("_").append(j + 1);
        }
        sb.append(this.lineDelimiter.delimiter);
        return sb.toString();
    }

    private String makeLine(SNumbers numbers, int k) {
        StringBuilder sb = new StringBuilder();
        int blockLength = numbers.getBlockLength();
        for (int j = 0; j < blockLength; ++j) {
            if (j > 0) {
                sb.append(this.delimiter);
            }
            double v = numbers.getValue(k, j);
            if (this.simpleFormatForIntegers && v == (double)((long)v)) {
                sb.append((long)v);
                continue;
            }
            if (!this.format.isEmpty()) {
                sb.append(String.format(Locale.US, this.format, v));
                continue;
            }
            sb.append(v);
        }
        sb.append(this.lineDelimiter.delimiter);
        return sb.toString();
    }

    public static enum LineDelimiter {
        CRLF("\r\n"),
        LF("\n"),
        SYSTEM(String.format("%n", new Object[0]));

        private final String delimiter;

        private LineDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }
    }
}

