/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.io;

import jakarta.json.JsonObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.numbers.io.WriteRawNumbers;
import net.algart.json.Jsons;

public final class ReadRawNumbers
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_COLUMN_NAMES = "column_names";
    public static final String OUTPUT_COLUMN_INDEXES = "column_indexes";
    private boolean fileExistenceRequired = true;
    private int blockLength = 1;
    private Class<?> elementType = Float.TYPE;
    private WriteRawNumbers.ByteOrder byteOrder = WriteRawNumbers.ByteOrder.BIG_ENDIAN;
    private boolean readMetadataFile = true;

    public ReadRawNumbers() {
        this.addFileOperationPorts();
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_COLUMN_NAMES);
        this.addOutputScalar(OUTPUT_COLUMN_INDEXES);
    }

    public static ReadRawNumbers getInstance() {
        return new ReadRawNumbers();
    }

    public static ReadRawNumbers getSecureInstance() {
        ReadRawNumbers result = new ReadRawNumbers();
        result.setSecure(true);
        return result;
    }

    @Override
    public ReadRawNumbers setFile(String file) {
        super.setFile(file);
        return this;
    }

    @Override
    public ReadRawNumbers setFile(Path file) {
        super.setFile(file);
        return this;
    }

    public boolean isFileExistenceRequired() {
        return this.fileExistenceRequired;
    }

    public ReadRawNumbers setFileExistenceRequired(boolean fileExistenceRequired) {
        this.fileExistenceRequired = fileExistenceRequired;
        return this;
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public ReadRawNumbers setBlockLength(int blockLength) {
        this.blockLength = ReadRawNumbers.positive(blockLength);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public ReadRawNumbers setElementType(Class<?> elementType) {
        this.elementType = ReadRawNumbers.nonNull(elementType);
        return this;
    }

    public ReadRawNumbers setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public WriteRawNumbers.ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public ReadRawNumbers setByteOrder(WriteRawNumbers.ByteOrder byteOrder) {
        this.byteOrder = ReadRawNumbers.nonNull(byteOrder);
        return this;
    }

    public boolean isReadMetadataFile() {
        return this.readMetadataFile;
    }

    public ReadRawNumbers setReadMetadataFile(boolean readMetadataFile) {
        this.readMetadataFile = readMetadataFile;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadRawNumbers.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
        } else {
            SNumbers result = this.readRaw();
            if (result != null) {
                this.getNumbers().setTo(result);
            }
        }
    }

    public SNumbers readRaw() {
        SNumbers sNumbers;
        Path rawFile = this.completeFilePath();
        Path metadataFile = Paths.get(String.valueOf(rawFile) + ".meta", new String[0]);
        if (!Files.exists(rawFile, new LinkOption[0])) {
            if (this.fileExistenceRequired) {
                throw new FileNotFoundException("File not found: " + String.valueOf(rawFile));
            }
            return null;
        }
        JsonObject metadata = null;
        if (this.readMetadataFile) {
            JsonObject columnIndexes;
            if (!Files.exists(metadataFile, new LinkOption[0])) {
                throw new FileNotFoundException("Metadata file not found: " + String.valueOf(metadataFile.toAbsolutePath()));
            }
            ReadRawNumbers.logDebug(() -> "Reading metadata file " + String.valueOf(metadataFile.toAbsolutePath()));
            metadata = Jsons.readJson(metadataFile);
            List<String> columnNames = WriteRawNumbers.getMetadataColumnNames(metadata);
            if (columnNames != null) {
                this.getScalar(OUTPUT_COLUMN_NAMES).setTo(String.join((CharSequence)"\n", columnNames));
            }
            if ((columnIndexes = WriteRawNumbers.getMetadataColumnIndexes(metadata)) != null) {
                this.getScalar(OUTPUT_COLUMN_INDEXES).setTo(Jsons.toPrettyString(columnIndexes));
            }
        }
        ReadRawNumbers.logDebug(() -> "Reading number array from " + String.valueOf(rawFile.toAbsolutePath()));
        FileInputStream stream = new FileInputStream(rawFile.toFile());
        try {
            SNumbers result;
            try {
                result = this.readRaw(stream, metadata);
            }
            catch (RuntimeException e) {
                throw new IOException("Cannot load numbers from file " + String.valueOf(rawFile), e);
            }
            sNumbers = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        stream.close();
        return sNumbers;
    }

    public SNumbers readRaw(FileInputStream inputStream, JsonObject metadata) throws IOException {
        return metadata == null ? ReadRawNumbers.readRaw(inputStream, this.byteOrder.order(), this.elementType, this.blockLength) : ReadRawNumbers.readRaw(inputStream, WriteRawNumbers.getMetadataByteOrder(metadata), WriteRawNumbers.getMetadataElementType(metadata), WriteRawNumbers.getMetadataBlockLength(metadata));
    }

    public static SNumbers readRaw(FileInputStream inputStream, ByteOrder byteOrder, Class<?> elementType, int blockLength) throws IOException {
        Objects.requireNonNull(inputStream, "Null outputStream argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        Objects.requireNonNull(elementType, "Null elementType");
        FileChannel channel = inputStream.getChannel();
        long size = channel.size();
        if (size > Integer.MAX_VALUE) {
            throw new IOException("Cannot read too large file to SNumbers: it's size " + size + " >= 2^31");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)size);
        byteBuffer.order(byteOrder);
        channel.read(byteBuffer);
        return new SNumbers().setTo(byteBuffer, elementType, blockLength);
    }

    @Override
    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return super.visibleResultsInformation().addPorts(this.getOutputPort(OUTPUT_COLUMN_NAMES));
    }
}

