/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.creation;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Range;
import net.algart.math.RectangularArea;

public final class CreateRectangularArea
extends Executor
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_SIZE_X = "size_x";
    public static final String OUTPUT_SIZE_Y = "size_y";
    public static final String OUTPUT_SIZE_Z = "size_z";
    private ResultLongOrDoubleType resultElementType;
    private double minX = 0.0;
    private Double maxX = 0.0;
    private Double sizeX = null;
    private Double minY = 0.0;
    private Double maxY = 0.0;
    private Double sizeY = null;
    private Double minZ = null;
    private Double maxZ = null;
    private Double sizeZ = null;

    public CreateRectangularArea() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public ResultLongOrDoubleType getResultElementType() {
        return this.resultElementType;
    }

    public CreateRectangularArea setResultElementType(ResultLongOrDoubleType resultElementType) {
        this.resultElementType = resultElementType;
        return this;
    }

    public double getMinX() {
        return this.minX;
    }

    public CreateRectangularArea setMinX(double minX) {
        this.minX = minX;
        return this;
    }

    public Double getMaxX() {
        return this.maxX;
    }

    public CreateRectangularArea setMaxX(Double maxX) {
        this.maxX = maxX;
        return this;
    }

    public Double getSizeX() {
        return this.sizeX;
    }

    public CreateRectangularArea setSizeX(Double sizeX) {
        this.sizeX = sizeX;
        return this;
    }

    public Double getMinY() {
        return this.minY;
    }

    public CreateRectangularArea setMinY(Double minY) {
        this.minY = minY;
        return this;
    }

    public Double getMaxY() {
        return this.maxY;
    }

    public CreateRectangularArea setMaxY(Double maxY) {
        this.maxY = maxY;
        return this;
    }

    public Double getSizeY() {
        return this.sizeY;
    }

    public CreateRectangularArea setSizeY(Double sizeY) {
        this.sizeY = sizeY;
        return this;
    }

    public Double getMinZ() {
        return this.minZ;
    }

    public CreateRectangularArea setMinZ(Double minZ) {
        this.minZ = minZ;
        return this;
    }

    public Double getMaxZ() {
        return this.maxZ;
    }

    public CreateRectangularArea setMaxZ(Double maxZ) {
        this.maxZ = maxZ;
        return this;
    }

    public Double getSizeZ() {
        return this.sizeZ;
    }

    public CreateRectangularArea setSizeZ(Double sizeZ) {
        this.sizeZ = sizeZ;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            CreateRectangularArea.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
        } else {
            this.getNumbers().setTo(this.resultElementType.rectangularArea(this));
        }
    }

    public static enum ResultLongOrDoubleType {
        LONG((Class)Long.TYPE){

            @Override
            SNumbers rectangularArea(CreateRectangularArea e) {
                long z2;
                long y2;
                long x2;
                long x1 = (long)e.minX;
                long l = x2 = e.maxX == null ? 0L : (long)e.maxX.doubleValue();
                if (e.sizeX != null) {
                    x2 = x1 + (long)e.sizeX.doubleValue() - 1L;
                }
                IRange rangeX = IRange.valueOf((long)x1, (long)x2);
                e.getScalar(CreateRectangularArea.OUTPUT_SIZE_X).setTo(rangeX.size());
                if (e.minY == null) {
                    return SNumbers.of(IRectangularArea.valueOf((IRange[])new IRange[]{rangeX}));
                }
                long y1 = (long)e.minY.doubleValue();
                long l2 = y2 = e.maxY == null ? 0L : (long)e.maxY.doubleValue();
                if (e.sizeY != null) {
                    y2 = y1 + (long)e.sizeY.doubleValue() - 1L;
                }
                IRange rangeY = IRange.valueOf((long)y1, (long)y2);
                e.getScalar(CreateRectangularArea.OUTPUT_SIZE_Y).setTo(rangeY.size());
                if (e.minZ == null) {
                    return SNumbers.of(IRectangularArea.valueOf((IRange[])new IRange[]{rangeX, rangeY}));
                }
                long z1 = (long)e.minZ.doubleValue();
                long l3 = z2 = e.maxZ == null ? 0L : (long)e.maxZ.doubleValue();
                if (e.sizeZ != null) {
                    z2 = z1 + (long)e.sizeZ.doubleValue() - 1L;
                }
                IRange rangeZ = IRange.valueOf((long)z1, (long)z2);
                e.getScalar(CreateRectangularArea.OUTPUT_SIZE_Z).setTo(rangeZ.size());
                return SNumbers.of(IRectangularArea.valueOf((IRange[])new IRange[]{rangeX, rangeY, rangeZ}));
            }
        }
        ,
        DOUBLE((Class)Double.TYPE){

            @Override
            SNumbers rectangularArea(CreateRectangularArea e) {
                double z2;
                double y2;
                double x2;
                double x1 = e.minX;
                double d = x2 = e.maxX == null ? 0.0 : e.maxX;
                if (e.sizeX != null) {
                    x2 = x1 + e.sizeX;
                }
                Range rangeX = Range.valueOf((double)x1, (double)x2);
                e.getScalar(CreateRectangularArea.OUTPUT_SIZE_X).setTo(rangeX.size());
                if (e.minY == null) {
                    return SNumbers.of(RectangularArea.valueOf((Range[])new Range[]{rangeX}));
                }
                double y1 = e.minY;
                double d2 = y2 = e.maxY == null ? 0.0 : e.maxY;
                if (e.sizeY != null) {
                    y2 = y1 + e.sizeY;
                }
                Range rangeY = Range.valueOf((double)y1, (double)y2);
                e.getScalar(CreateRectangularArea.OUTPUT_SIZE_Y).setTo(rangeY.size());
                if (e.minZ == null) {
                    return SNumbers.of(RectangularArea.valueOf((Range[])new Range[]{rangeX, rangeY}));
                }
                double z1 = e.minZ;
                double d3 = z2 = e.maxZ == null ? 0.0 : e.maxZ;
                if (e.sizeZ != null) {
                    z2 = z1 + e.sizeZ;
                }
                Range rangeZ = Range.valueOf((double)z1, (double)z2);
                e.getScalar(CreateRectangularArea.OUTPUT_SIZE_Z).setTo(rangeZ.size());
                return SNumbers.of(RectangularArea.valueOf((Range[])new Range[]{rangeX, rangeY, rangeZ}));
            }
        };

        final Class<?> elementType;

        private ResultLongOrDoubleType(Class<?> elementType) {
            this.elementType = elementType;
        }

        public Class<?> elementType() {
            return this.elementType;
        }

        abstract SNumbers rectangularArea(CreateRectangularArea var1);
    }
}

