/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.creation;

import java.util.Arrays;
import java.util.Locale;
import java.util.SplittableRandom;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class CreateRandomNumbers
extends Executor
implements ReadOnlyExecutionInput {
    private int blockLength = 1;
    private int numberOfBlocks = 100;
    private Class<?> elementType = Float.TYPE;
    private double min = 0.0;
    private double max = 1.0;
    private long randSeed = 0L;

    public CreateRandomNumbers() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public CreateRandomNumbers setBlockLength(int blockLength) {
        this.blockLength = CreateRandomNumbers.positive(blockLength);
        return this;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public CreateRandomNumbers setNumberOfBlocks(int numberOfBlocks) {
        this.numberOfBlocks = CreateRandomNumbers.nonNegative(numberOfBlocks);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public CreateRandomNumbers setElementType(Class<?> elementType) {
        this.elementType = CreateRandomNumbers.nonNull(elementType);
        return this;
    }

    public CreateRandomNumbers setElementType(String elementType) {
        return this.setElementType(SNumbers.elementType(elementType));
    }

    public double getMin() {
        return this.min;
    }

    public CreateRandomNumbers setMin(double min) {
        this.min = min;
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public CreateRandomNumbers setMax(double max) {
        this.max = max;
        return this;
    }

    public long getRandSeed() {
        return this.randSeed;
    }

    public CreateRandomNumbers setRandSeed(long randSeed) {
        this.randSeed = randSeed;
        return this;
    }

    @Override
    public void process() {
        SNumbers input = this.getInputNumbers(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            CreateRandomNumbers.logDebug(() -> "Copying number array: " + String.valueOf(input));
            this.getNumbers().setTo(input);
        } else {
            if ((long)this.blockLength * (long)this.numberOfBlocks > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("numberOfBlocks * blockLength = " + this.numberOfBlocks + " * " + this.blockLength + " >= 2^31");
            }
            long t1 = CreateRandomNumbers.debugTime();
            int length = this.blockLength * this.numberOfBlocks;
            float[] floats = new float[length];
            long t2 = CreateRandomNumbers.debugTime();
            if (this.min == this.max) {
                Arrays.fill(floats, (float)this.min);
            } else {
                if (this.min > this.max) {
                    throw new IllegalArgumentException("min value > max value");
                }
                SplittableRandom random = this.randSeed == 0L ? new SplittableRandom() : new SplittableRandom(this.randSeed);
                for (int k = 0; k < floats.length; ++k) {
                    floats[k] = (float)random.nextDouble(this.min, this.max);
                }
            }
            long t3 = CreateRandomNumbers.debugTime();
            this.setEndProcessingTimeStamp();
            this.getNumbers().setToArray(floats, this.blockLength).setPrecision(this.elementType);
            long t4 = CreateRandomNumbers.debugTime();
            CreateRandomNumbers.logDebug(() -> String.format(Locale.US, "Generating %d random numbers (%d x %d), %s: %.3f ms = %.3f ms allocating + %.3f ms generating (%.2f ns/element) + %.3f ms returning", length, this.blockLength, this.numberOfBlocks, this.randSeed == 0L ? "random initial value" : "stable initial value [" + this.randSeed + "]", (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t3 - t2) / (double)length, (double)(t4 - t3) * 1.0E-6));
        }
    }
}

