/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;

public final class ReplaceNumbers
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_REPLACE_WITH = "replace_with";
    private int blockIndex = 0;
    private int blockIndexInReplacer = 0;
    private int numberOfBlocks = 0;

    public ReplaceNumbers() {
        this.addInputNumbers(DEFAULT_INPUT_PORT);
        this.addInputNumbers(INPUT_REPLACE_WITH);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public ReplaceNumbers setBlockIndex(int blockIndex) {
        this.blockIndex = ReplaceNumbers.nonNegative(blockIndex);
        return this;
    }

    public int getBlockIndexInReplacer() {
        return this.blockIndexInReplacer;
    }

    public ReplaceNumbers setBlockIndexInReplacer(int blockIndexInReplacer) {
        this.blockIndexInReplacer = ReplaceNumbers.nonNegative(blockIndexInReplacer);
        return this;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public ReplaceNumbers setNumberOfBlocks(int numberOfBlocks) {
        this.numberOfBlocks = ReplaceNumbers.nonNegative(numberOfBlocks);
        return this;
    }

    @Override
    public void process() {
        SNumbers inputPortNumbers = this.getInputNumbers(this.defaultInputPortName(), true);
        SNumbers inputPortNumbersReplacer = this.getInputNumbers(INPUT_REPLACE_WITH);
        int numberOfBlocks = this.numberOfBlocks == 0 ? inputPortNumbersReplacer.n() : this.numberOfBlocks;
        ReplaceNumbers.logDebug(() -> "Replacing blocks #" + this.blockIndex + (String)(numberOfBlocks == 1 ? "" : ".." + (this.blockIndex + numberOfBlocks - 1)) + " of input number array " + String.valueOf(inputPortNumbers) + " with blocks #" + this.blockIndexInReplacer + (String)(numberOfBlocks == 1 ? "" : ".." + (this.blockIndexInReplacer + numberOfBlocks - 1)) + " of replacer array: " + String.valueOf(inputPortNumbersReplacer));
        this.getNumbers().setTo(inputPortNumbers).replaceBlockRange(this.blockIndex, inputPortNumbersReplacer, this.blockIndexInReplacer, numberOfBlocks);
    }
}

