/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.numbers.SeveralNumberArraysOperation;
import net.algart.executors.modules.core.scalars.arithmetic.ProductOfTwoPowers;
import net.algart.math.functions.Func;
import net.algart.math.functions.MultiplyingFunc;
import net.algart.math.functions.PowerFunc;

public final class NumbersProductOfTwoPowers
extends SeveralNumberArraysOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private double a = 1.0;
    private double b = 1.0;
    private double m = 1.0;

    public NumbersProductOfTwoPowers() {
        super(INPUT_X, INPUT_Y);
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public void setA(String a) {
        this.setA(ProductOfTwoPowers.smartParseDouble(a));
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public void setB(String b) {
        this.setB(ProductOfTwoPowers.smartParseDouble(b));
    }

    public double getM() {
        return this.m;
    }

    public void setM(double m) {
        this.m = m;
    }

    @Override
    public PArray process(List<PNumberArray> sources, int ... blockLengths) {
        Class resultType;
        PNumberArray x = sources.get(0);
        PNumberArray y = sources.get(1);
        Class clazz = resultType = x instanceof DoubleArray ? DoubleArray.class : FloatArray.class;
        if (y == null) {
            return Arrays.asFuncArray((Func)PowerFunc.getInstance((double)this.a, (double)this.m), resultType, (PArray[])new PArray[]{x});
        }
        x = (PNumberArray)Arrays.asFuncArray((Func)PowerFunc.getInstance((double)this.a, (double)1.0), DoubleArray.class, (PArray[])new PArray[]{x});
        y = (PNumberArray)Arrays.asFuncArray((Func)PowerFunc.getInstance((double)this.b, (double)1.0), DoubleArray.class, (PArray[])new PArray[]{y});
        return Arrays.asFuncArray((Func)MultiplyingFunc.getInstance((double)this.m), resultType, (PArray[])new PArray[]{x, y});
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex > 0;
    }
}

