/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.statistics;

import net.algart.additions.arrays.UniformHistogram256Finder;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.Histogram;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.SummingHistogram;
import net.algart.math.Range;

abstract class HistogramFinder {
    final PArray array;
    final BitArray maskArray;
    final Class<?> elementType;
    final long bitsPerElement;
    final boolean floatingPoint;
    long[] histogram;
    double sum = 0.0;
    long count = 0L;
    double from;
    double to;
    Range range;

    HistogramFinder(PArray array, BitArray maskArray) {
        this.array = array;
        this.elementType = array.elementType();
        this.bitsPerElement = array.bitsPerElement();
        this.maskArray = maskArray;
        this.floatingPoint = Arrays.isFloatingPointElementType(this.elementType);
    }

    abstract void find();

    double mean() {
        return this.sum / (double)this.count;
    }

    double columnWidth() {
        return (this.to - this.from) / (double)this.histogram.length;
    }

    double percentile(double level) {
        return Histogram.percentile((long[])this.histogram, (long)this.count, (double)level);
    }

    double meanBetweenRanks(double level1, double level2) {
        double r1 = level1 * (double)this.count;
        double r2 = level2 * (double)this.count;
        return SummingHistogram.preciseIntegralBetweenRanks((long[])this.histogram, (double)r1, (double)r2) / (r2 - r1);
    }

    public String toString() {
        return "sum=" + this.sum + ", count=" + this.count + ", mean=" + this.mean() + ", from=" + this.from + ", to=" + this.to + ", range=" + String.valueOf(this.range) + " " + this.histogramToString();
    }

    private String histogramToString() {
        int p;
        StringBuilder sb = new StringBuilder("[");
        for (p = 0; p < this.histogram.length && this.histogram[p] == 0L; ++p) {
        }
        if (p > 0) {
            sb.append(p).append("x0");
        }
        int to = Math.min(p + 16, this.histogram.length);
        while (p < to) {
            if (p > 0) {
                sb.append(",");
            }
            sb.append(this.histogram[p]);
            ++p;
        }
        if (p < this.histogram.length) {
            sb.append(",...(elements #").append(p).append("...").append(this.histogram.length - 1).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    static class RangeBased
    extends HistogramFinder {
        final boolean shortIntegers;

        RangeBased(PArray array, BitArray maskArray) {
            super(array, maskArray == null ? Arrays.nBitCopies((long)array.length(), (boolean)true) : maskArray);
            this.shortIntegers = this.elementType == Boolean.TYPE || this.elementType == Character.TYPE || this.elementType == Byte.TYPE || this.elementType == Short.TYPE;
        }

        @Override
        void find() {
            double multiplier;
            long bitsPerElement = this.array.bitsPerElement();
            if (this.shortIntegers) {
                assert (bitsPerElement <= 16L);
                this.histogram = new long[1 << (int)bitsPerElement];
                multiplier = Double.NaN;
                this.from = 0.0;
                this.to = 1 << (int)bitsPerElement;
                this.range = Range.valueOf((double)this.from, (double)this.to);
            } else {
                this.histogram = new long[65536];
                this.range = Arrays.rangeOf((PArray)this.array);
                this.from = this.range.min();
                this.to = Arrays.isFloatingPointElementType((Class)this.elementType) ? this.range.max() : this.range.max() + 1.0;
                multiplier = (double)this.histogram.length / (this.to - this.from);
            }
            this.sum = 0.0;
            this.count = 0L;
            DataBuffer buffer = this.array.buffer(DataBuffer.AccessMode.READ, 65536L);
            DataBitBuffer maskBuffer = this.maskArray.buffer(DataBuffer.AccessMode.READ, 65536L);
            long n = this.array.length();
            for (long p = 0L; p < n; p += buffer.count()) {
                buffer.map(p);
                maskBuffer.map(p);
                Object data = buffer.data();
                long[] bits = maskBuffer.data();
                if (this.elementType == Boolean.TYPE) {
                    assert (this.histogram.length == 2);
                    d = (long[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            int v;
                            int n2 = v = PackedBitArrays.getBit((long[])d, (long)j) ? 1 : 0;
                            this.histogram[n2] = this.histogram[n2] + 1L;
                            this.sum += (double)v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Character.TYPE) {
                    d = (char[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            long v;
                            long l = v = d[j];
                            this.histogram[l] = this.histogram[l] + 1L;
                            this.sum += (double)v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Byte.TYPE) {
                    d = (byte[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            int v;
                            int n3 = v = d[j] & 0xFF;
                            this.histogram[n3] = this.histogram[n3] + 1L;
                            this.sum += (double)v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Short.TYPE) {
                    d = (short[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            int v;
                            int n4 = v = d[j] & 0xFFFF;
                            this.histogram[n4] = this.histogram[n4] + 1L;
                            this.sum += (double)v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Integer.TYPE) {
                    d = (int[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            double v = d[j];
                            index = (int)((v - this.from) * multiplier);
                            assert (index >= 0);
                            int n5 = index >= this.histogram.length ? this.histogram.length - 1 : index;
                            this.histogram[n5] = this.histogram[n5] + 1L;
                            this.sum += v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Long.TYPE) {
                    d = (long[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            double v = d[j];
                            index = (int)((v - this.from) * multiplier);
                            assert (index >= 0);
                            int n6 = index >= this.histogram.length ? this.histogram.length - 1 : index;
                            this.histogram[n6] = this.histogram[n6] + 1L;
                            this.sum += v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Float.TYPE) {
                    d = (float[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            double v = d[j];
                            index = (int)((v - this.from) * multiplier);
                            assert (index >= 0);
                            int n7 = index >= this.histogram.length ? this.histogram.length - 1 : index;
                            this.histogram[n7] = this.histogram[n7] + 1L;
                            this.sum += v;
                        }
                        ++i;
                    }
                } else if (this.elementType == Double.TYPE) {
                    d = (double[])data;
                    i = maskBuffer.from();
                    jMax = buffer.to();
                    for (j = buffer.from(); j < jMax; ++j) {
                        if (PackedBitArrays.getBit((long[])bits, (long)i)) {
                            long v = d[j];
                            index = (int)((v - this.from) * multiplier);
                            assert (index >= 0);
                            int n8 = index >= this.histogram.length ? this.histogram.length - 1 : index;
                            this.histogram[n8] = this.histogram[n8] + 1L;
                            this.sum += v;
                        }
                        ++i;
                    }
                } else {
                    throw new AssertionError((Object)("Unallowed element type: " + String.valueOf(this.elementType)));
                }
                this.count += PackedBitArrays.cardinality((long[])bits, (long)maskBuffer.fromIndex(), (long)maskBuffer.toIndex());
            }
        }

        @Override
        public String toString() {
            return "range based finder: " + super.toString();
        }
    }

    static class Uniform
    extends HistogramFinder {
        final UniformHistogram256Finder histogram256Finder;

        Uniform(PArray array, BitArray maskArray, UniformHistogram256Finder histogram256Finder) {
            super(array, maskArray);
            this.histogram256Finder = histogram256Finder;
        }

        @Override
        void find() {
            this.from = 0.0;
            this.to = this.array.maxPossibleValue(1.0);
            this.range = Range.valueOf((double)this.from, (double)this.to);
            if (!this.floatingPoint) {
                this.to += 1.0;
            }
            this.histogram256Finder.find(this.array, this.maskArray);
            this.histogram = this.histogram256Finder.histogram();
            this.count = this.histogram256Finder.cardinality();
            this.sum = this.histogram256Finder.sum();
        }

        @Override
        public String toString() {
            return "uniform finder: " + super.toString();
        }
    }
}

