/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.io;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.files.ListOfFiles;
import net.algart.executors.modules.core.matrices.io.ReadImage;

public final class ReadNextImage
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    public static final String OUTPUT_INDEX = "file_index";
    public static final String OUTPUT_NUMBER_OF_FILES = "number_of_files";
    public static final String OUTPUT_LIST_OF_FILES = "list_of_files";
    public static final String OUTPUT_LAST = "last";
    private String globPattern = "*.{jpeg,jpg,png,gif,bmp}";
    private boolean recursiveScanning = true;
    private boolean fileExistenceRequired = false;
    private boolean clearFileIndexOnReset = true;
    private final List<Path> sortedFiles = new ArrayList<Path>();
    private String sortedFilesString = "";
    private int currentFileIndex = 0;

    public ReadNextImage() {
        this.addFileOperationPorts();
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
        this.addOutputScalar(OUTPUT_INDEX);
        this.addOutputScalar(OUTPUT_NUMBER_OF_FILES);
        this.addOutputScalar(OUTPUT_LIST_OF_FILES);
        this.addOutputScalar(OUTPUT_LAST);
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public ReadNextImage setGlobPattern(String globPattern) {
        this.globPattern = ReadNextImage.nonEmpty(globPattern);
        return this;
    }

    public boolean isRecursiveScanning() {
        return this.recursiveScanning;
    }

    public ReadNextImage setRecursiveScanning(boolean recursiveScanning) {
        this.recursiveScanning = recursiveScanning;
        return this;
    }

    public boolean isFileExistenceRequired() {
        return this.fileExistenceRequired;
    }

    public ReadNextImage setFileExistenceRequired(boolean fileExistenceRequired) {
        this.fileExistenceRequired = fileExistenceRequired;
        return this;
    }

    public boolean isClearFileIndexOnReset() {
        return this.clearFileIndexOnReset;
    }

    public ReadNextImage setClearFileIndexOnReset(boolean clearFileIndexOnReset) {
        this.clearFileIndexOnReset = clearFileIndexOnReset;
        return this;
    }

    public int currentFileIndex() {
        return this.currentFileIndex;
    }

    public int numberOfFiles() {
        return this.sortedFiles.size();
    }

    @Override
    public void initialize() {
        try {
            this.sortedFiles.clear();
            Path path = this.completeFilePath();
            ListOfFiles.findFiles(this.sortedFiles, path, this.globPattern, null, this.recursiveScanning);
            if (this.fileExistenceRequired && this.sortedFiles.isEmpty()) {
                throw new FileNotFoundException("No files in " + String.valueOf(path) + ", corresponding to pattern " + this.globPattern);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Collections.sort(this.sortedFiles);
        this.sortedFilesString = this.sortedFiles.stream().map(String::valueOf).collect(Collectors.joining("\n"));
        if (this.clearFileIndexOnReset) {
            this.currentFileIndex = 0;
        }
    }

    @Override
    public void process() {
        SMat result;
        int numberOfFiles = this.sortedFiles.size();
        if (numberOfFiles == 0 && this.fileExistenceRequired) {
            throw new IllegalStateException("Illegal usage of process() method: initialize() was not successfully executed");
        }
        int fileIndex = this.currentFileIndex++;
        if (this.currentFileIndex >= numberOfFiles) {
            this.currentFileIndex = 0;
        }
        boolean last = this.currentFileIndex == 0;
        this.getScalar(OUTPUT_INDEX).setTo(fileIndex + 1);
        this.getScalar(OUTPUT_NUMBER_OF_FILES).setTo(numberOfFiles);
        this.getScalar(OUTPUT_LIST_OF_FILES).setTo(this.sortedFilesString);
        this.getScalar(OUTPUT_LAST).setTo(last);
        if (fileIndex >= numberOfFiles) {
            return;
        }
        Path fileToRead = this.sortedFiles.get(fileIndex).toAbsolutePath();
        Path absolutePath = fileToRead.toAbsolutePath();
        this.getScalar("absolute_path").setTo(absolutePath.toString());
        this.getScalar("parent_folder").setTo(absolutePath.getParent().toString());
        this.getScalar("file_name").setTo(absolutePath.getFileName().toString());
        ReadImage readImage = ReadImage.getInstance();
        readImage.setFile(fileToRead.toString());
        try {
            result = readImage.readImage();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.getScalar(OUTPUT_DIM_X).setTo(result.getDimX());
        this.getScalar(OUTPUT_DIM_Y).setTo(result.getDimY());
        this.getMat().exchange(result);
    }
}

