/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.arrays.Array;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelFilter;

public final class MergeLastTwoDimensions
extends MultiMatrixChannelFilter {
    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        int newDimCount = m.dimCount() - 1;
        if (newDimCount <= 0) {
            return m;
        }
        long[] newDimensions = JArrays.copyOfRange((long[])m.dimensions(), (int)0, (int)newDimCount);
        int n = newDimCount - 1;
        newDimensions[n] = newDimensions[n] * m.dim(newDimCount);
        return Matrices.matrix((Array)((PArray)m.array()), (long[])newDimensions);
    }
}

