/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannelFilter;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class ChangePrecision
extends MultiMatrixChannelFilter {
    public static final String OUTPUT_ELEMENT_TYPE = "element_type";
    private boolean rawCast = false;
    private Class<?> elementType = Byte.TYPE;
    private boolean requireInput = false;

    public ChangePrecision() {
        this.addOutputScalar(OUTPUT_ELEMENT_TYPE);
    }

    public boolean isRawCast() {
        return this.rawCast;
    }

    public ChangePrecision setRawCast(boolean rawCast) {
        this.rawCast = rawCast;
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public ChangePrecision setElementType(Class<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    public ChangePrecision setElementType(String elementType) {
        return this.setElementType(MultiMatrixGenerator.elementType(elementType, true));
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public ChangePrecision setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        if (source == null) {
            return null;
        }
        if (this.elementType == null || this.elementType == source.elementType()) {
            this.setOutputScalar(OUTPUT_ELEMENT_TYPE, source.elementType().getSimpleName());
            return source;
        }
        this.setOutputScalar(OUTPUT_ELEMENT_TYPE, this.elementType.getSimpleName());
        if (this.rawCast) {
            return super.process(source);
        }
        ChangePrecision.logDebug(() -> "Changing precision " + source.elementType().getSimpleName() + " -> " + this.elementType.getSimpleName() + " for matrix " + String.valueOf(source));
        return source.toPrecisionIfNot(this.elementType);
    }

    @Override
    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        if (!this.rawCast) {
            throw new UnsupportedOperationException("Must be called ONLY in rawCast mode");
        }
        if (this.currentChannel() == 0) {
            ChangePrecision.logDebug(() -> "Change precision (raw cast) " + m.elementType().getSimpleName() + " -> " + this.elementType.getSimpleName() + " for matrix " + this.numberOfChannels() + "x" + m.dimX() + "x" + m.dimY());
        }
        Class newType = Arrays.type(PArray.class, this.elementType);
        return Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)Func.IDENTITY, (Class)newType, m));
    }

    @Override
    protected boolean allowUninitializedInput() {
        return !this.requireInput;
    }

    @Override
    protected boolean resultRequired() {
        return this.requireInput;
    }
}

