/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.conversions;

import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.multimatrix.MultiMatrix;

public final class ChangeNumberOfChannels
extends MultiMatrixFilter {
    private boolean requireInput = false;
    private int numberOfChannels = 0;
    private boolean fillAlphaWithMaxValue = false;

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public ChangeNumberOfChannels setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public ChangeNumberOfChannels setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = ChangeNumberOfChannels.nonNegative(numberOfChannels);
        return this;
    }

    public boolean isFillAlphaWithMaxValue() {
        return this.fillAlphaWithMaxValue;
    }

    public ChangeNumberOfChannels setFillAlphaWithMaxValue(boolean fillAlphaWithMaxValue) {
        this.fillAlphaWithMaxValue = fillAlphaWithMaxValue;
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        if (source == null) {
            return null;
        }
        if (this.numberOfChannels == 0) {
            return source;
        }
        ChangeNumberOfChannels.logDebug(() -> "Changing number of channels " + source.numberOfChannels() + " -> " + this.numberOfChannels + " for matrix " + String.valueOf(source));
        return source.asOtherNumberOfChannels(this.numberOfChannels, this.fillAlphaWithMaxValue).clone();
    }

    @Override
    protected boolean allowUninitializedInput() {
        return !this.requireInput;
    }

    @Override
    protected boolean resultRequired() {
        return this.requireInput;
    }
}

