/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesChannelOperation;
import net.algart.executors.modules.core.scalars.arithmetic.ProductOfTwoPowers;
import net.algart.math.functions.Func;
import net.algart.math.functions.MultiplyingFunc;
import net.algart.math.functions.PowerFunc;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixProductOfTwoPowers
extends SeveralMultiMatricesChannelOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private double a = 1.0;
    private double b = 1.0;
    private double m = 1.0;
    private Class<?> elementType = Float.TYPE;

    public MatrixProductOfTwoPowers() {
        super(INPUT_X, INPUT_Y);
    }

    public double getA() {
        return this.a;
    }

    public MatrixProductOfTwoPowers setA(double a) {
        this.a = a;
        return this;
    }

    public MatrixProductOfTwoPowers setA(String a) {
        return this.setA(ProductOfTwoPowers.smartParseDouble(a));
    }

    public double getB() {
        return this.b;
    }

    public MatrixProductOfTwoPowers setB(double b) {
        this.b = b;
        return this;
    }

    public MatrixProductOfTwoPowers setB(String b) {
        return this.setB(ProductOfTwoPowers.smartParseDouble(b));
    }

    public double getM() {
        return this.m;
    }

    public MatrixProductOfTwoPowers setM(double m) {
        this.m = m;
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public MatrixProductOfTwoPowers setElementType(Class<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    public MatrixProductOfTwoPowers setElementType(String elementType) {
        return this.setElementType(MultiMatrixGenerator.elementType(elementType, true));
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        MultiMatrix result = super.process(sources);
        return result.toPrecision(this.elementType != null ? this.elementType : this.sampleElementType());
    }

    @Override
    protected Matrix<? extends PArray> processChannel(List<Matrix<? extends PArray>> matrices) {
        Matrix x = matrices.get(0);
        Matrix y = matrices.get(1);
        if (((PArray)x.array()).maxPossibleValue(1.0) != 1.0) {
            x = Matrices.asPrecision(x, Float.TYPE);
        }
        if (y == null) {
            return Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)this.a, (double)this.m), FloatArray.class, (Matrix)x);
        }
        if (((PArray)y.array()).maxPossibleValue(1.0) != 1.0) {
            y = Matrices.asPrecision(y, Float.TYPE);
        }
        x = Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)this.a, (double)1.0), DoubleArray.class, (Matrix)x);
        y = Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)this.b, (double)1.0), DoubleArray.class, (Matrix)y);
        return Matrices.asFuncMatrix((Func)MultiplyingFunc.getInstance((double)this.m), FloatArray.class, (Matrix)x, (Matrix)y);
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex > 0;
    }
}

