/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.Func1;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixCutToRange
extends MultiMatrixFilter {
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;

    public double getMin() {
        return this.min;
    }

    public MatrixCutToRange setMin(double min) {
        this.min = min;
        return this;
    }

    public MatrixCutToRange setMin(String min) {
        this.min = MatrixCutToRange.doubleOrNegativeInfinity(min);
        return this;
    }

    public double getMax() {
        return this.max;
    }

    public MatrixCutToRange setMax(double max) {
        this.max = max;
        return this;
    }

    public MatrixCutToRange setMax(String max) {
        this.max = MatrixCutToRange.doubleOrPositiveInfinity(max);
        return this;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        double scale = source.maxPossibleValue();
        Range range = Range.valueOf((double)(this.min * scale), (double)(this.max * scale));
        return source.asFunc((Func)((Func1)arg_0 -> ((Range)range).cut(arg_0))).clone();
    }
}

