/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.List;
import java.util.Objects;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.executors.modules.core.matrices.arithmetic.AngleDistanceMetric;
import net.algart.multimatrix.MultiMatrix;

public final class MatrixAngleDifference
extends SeveralMultiMatricesOperation {
    public static final String INPUT_X1 = "x1";
    public static final String INPUT_Y1 = "y1";
    public static final String INPUT_X2 = "x2";
    public static final String INPUT_Y2 = "y2";
    private AngleDistanceMetric angleDistanceMetric = AngleDistanceMetric.R_SIN;

    public MatrixAngleDifference() {
        super(INPUT_X1, INPUT_Y1, INPUT_X2, INPUT_Y2);
    }

    public AngleDistanceMetric getAngleDistanceMetric() {
        return this.angleDistanceMetric;
    }

    public MatrixAngleDifference setAngleDistanceMetric(AngleDistanceMetric angleDistanceMetric) {
        this.angleDistanceMetric = MatrixAngleDifference.nonNull(angleDistanceMetric);
        return this;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        Objects.requireNonNull(sources, "Null sources");
        Matrix<? extends PArray> x1 = sources.get(0).asMultiMatrix2D().asFloatingPoint().intensityChannel();
        Matrix<? extends PArray> y1 = sources.get(1).asMultiMatrix2D().asFloatingPoint().intensityChannel();
        Matrix<? extends PArray> x2 = sources.get(2).asMultiMatrix2D().asFloatingPoint().intensityChannel();
        Matrix<? extends PArray> y2 = sources.get(3).asMultiMatrix2D().asFloatingPoint().intensityChannel();
        return MultiMatrix.of2DMono(this.angleDistanceMetric.asAngleDifference(x1, y1, x2, y2, FloatArray.class)).clone();
    }
}

