/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.matrices.arithmetic;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class CheckMatrixEquality
extends SeveralMultiMatricesOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private Operation operation = Operation.E0_NY;
    private boolean requireInput = false;

    public CheckMatrixEquality() {
        super(INPUT_X, INPUT_Y);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public CheckMatrixEquality setOperation(Operation operation) {
        this.operation = CheckMatrixEquality.nonNull(operation);
        return this;
    }

    public boolean isRequireInput() {
        return this.requireInput;
    }

    public CheckMatrixEquality setRequireInput(boolean requireInput) {
        this.requireInput = requireInput;
        return this;
    }

    @Override
    public MultiMatrix process(List<MultiMatrix> sources) {
        MultiMatrix sourceX = sources.get(0);
        MultiMatrix sourceY = sources.get(1);
        if (sourceX == null || sourceY == null) {
            return null;
        }
        MultiMatrix x = sourceX;
        int n = x.numberOfChannels();
        MultiMatrix y = sourceY.asPrecision(x.elementType()).asOtherNumberOfChannels(n);
        ArrayList<Matrix> nonEqualBitChannels = new ArrayList<Matrix>();
        for (int k = 0; k < n; ++k) {
            nonEqualBitChannels.add(Matrices.asFuncMatrix((Func)Func.ABS_DIFF, BitArray.class, x.channel(k), y.channel(k)));
        }
        Matrix nonEquals = Matrices.clone((Matrix)Matrices.asFuncMatrix((Func)Func.MAX, BitArray.class, nonEqualBitChannels)).cast(BitArray.class);
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (int k = 0; k < n; ++k) {
            channels.add(Matrices.asFuncMatrix((Func)this.operation.comparisonFuncFactory.getSelectionForNonEquals(x.maxPossibleValue()), x.arrayType(), (Matrix)nonEquals, x.channel(k), y.channel(k)));
        }
        return MultiMatrix.of(channels).clone();
    }

    @Override
    protected boolean resultRequired() {
        return false;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return !this.requireInput;
    }

    public static enum Operation {
        E0_N_ASSERTION(maxValue -> (equal, x, y) -> {
            if (equal) {
                return 0.0;
            }
            throw new AssertionError((Object)("Different matrices: " + x + " != " + y));
        }),
        E0_N1(maxValue -> (equal, x, y) -> equal ? 0.0 : maxValue),
        E0_NX(maxValue -> (equal, x, y) -> equal ? 0.0 : x),
        E0_NY(maxValue -> (equal, x, y) -> equal ? 0.0 : y),
        E1_N0(maxValue -> (equal, x, y) -> equal ? maxValue : 0.0),
        E1_NX(maxValue -> (equal, x, y) -> equal ? maxValue : x),
        E1_NY(maxValue -> (equal, x, y) -> equal ? maxValue : y),
        EXY_N0(maxValue -> (equal, x, y) -> equal ? x : 0.0),
        EXY_N1(maxValue -> (equal, x, y) -> equal ? x : maxValue);

        private final ComparisonFuncFactory comparisonFuncFactory;

        private Operation(ComparisonFuncFactory comparisonFuncFactory) {
            this.comparisonFuncFactory = comparisonFuncFactory;
        }

        private static interface ComparisonFuncFactory {
            public SelectionFuncForEqual getSelectionFuncForEqual(double var1);

            default public Func getSelectionForNonEquals(double maxValue) {
                final SelectionFuncForEqual selectionFunc = this.getSelectionFuncForEqual(maxValue);
                return new AbstractFunc(this){

                    public double get(double ... x) {
                        return selectionFunc.select(x[0] == 0.0, x[1], x[2]);
                    }
                };
            }
        }
    }

    private static interface SelectionFuncForEqual {
        public double select(boolean var1, double var2, double var4);
    }
}

