/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic.loops;

import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.graalvm.GraalAPI;
import net.algart.executors.api.graalvm.GraalSafety;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.GraalValues;
import org.graalvm.polyglot.Value;

public final class RepeatJS
extends Executor {
    public static final String FIRST_ITERATION_VARIABLE = "isFirst";
    public static final String INPUT_A = "a";
    public static final String INPUT_B = "b";
    public static final String INPUT_C = "c";
    public static final String INPUT_D = "d";
    public static final String INPUT_E = "e";
    public static final String INPUT_F = "f";
    public static final String INPUT_X1 = "x1";
    public static final String X1_VARIABLE_ALT = "x";
    public static final String INPUT_X2 = "x2";
    public static final String INPUT_X3 = "x3";
    public static final String OUTPUT_IS_FIRST = "is_first";
    public static final String OUTPUT_IS_LAST = "is_last";
    public static final String OUTPUT_IS_NOT_FIRST = "is_not_first";
    public static final String OUTPUT_IS_NOT_LAST = "is_not_last";
    public static final String OUTPUT_A = "a";
    public static final String OUTPUT_B = "b";
    public static final String OUTPUT_C = "c";
    public static final String OUTPUT_D = "d";
    public static final String OUTPUT_I = "i";
    public static final String OUTPUT_J = "j";
    public static final String OUTPUT_K = "k";
    public static final String OUTPUT_X1 = "x1";
    public static final String OUTPUT_X2 = "x2";
    public static final String OUTPUT_X3 = "x3";
    private String initializingOperator = "var i = 0;";
    private String resultA = "";
    private String resultB = "";
    private String resultC = "";
    private String resultD = "";
    private String resultI = "i";
    private String resultJ = "";
    private String resultK = "";
    private String resultX1 = "";
    private String resultX2 = "";
    private String resultX3 = "";
    private int resultX1BlockLength = 1;
    private int resultX2BlockLength = 1;
    private int resultX3BlockLength = 1;
    private String status = "";
    private String doOperator = "i++";
    private String whileCondition = "i < 10";
    private final GraalAPI graalAPI = GraalAPI.getSmartScriptingInstance();
    private boolean shareNamespace = true;
    private boolean closeSharedContext = true;
    private GraalPerformerContainer performerContainer = null;
    private final GraalSourceContainer javaScriptInitializingOperator = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultA = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultB = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultC = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultD = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultI = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultJ = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultK = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultX1 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultX2 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptResultX3 = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptStatus = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptDoOperator = GraalSourceContainer.newLiteralContainer();
    private final GraalSourceContainer javaScriptWhileCondition = GraalSourceContainer.newLiteralContainer();
    private boolean isFirstIteration = false;
    private boolean isLastIteration = false;
    private final Object lock = new Object();

    public RepeatJS() {
        this.addInputScalar("a");
        this.addInputScalar("b");
        this.addInputScalar("c");
        this.addInputScalar("d");
        this.addInputScalar(INPUT_E);
        this.addInputScalar(INPUT_F);
        this.addInputNumbers("x1");
        this.addInputNumbers("x2");
        this.addInputNumbers("x3");
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_IS_FIRST);
        this.addOutputScalar(OUTPUT_IS_LAST);
        this.addOutputScalar(OUTPUT_IS_NOT_FIRST);
        this.addOutputScalar(OUTPUT_IS_NOT_LAST);
        this.addOutputScalar("a");
        this.addOutputScalar("b");
        this.addOutputScalar("c");
        this.addOutputScalar("d");
        this.addOutputScalar(OUTPUT_I);
        this.addOutputScalar(OUTPUT_J);
        this.addOutputScalar(OUTPUT_K);
        this.addOutputNumbers("x1");
        this.addOutputNumbers("x2");
        this.addOutputNumbers("x3");
    }

    public String getInitializingOperator() {
        return this.initializingOperator;
    }

    public RepeatJS setInitializingOperator(String initializingOperator) {
        this.initializingOperator = RepeatJS.nonNull(initializingOperator);
        return this;
    }

    public String getResultA() {
        return this.resultA;
    }

    public RepeatJS setResultA(String resultA) {
        this.resultA = RepeatJS.nonNull(resultA);
        return this;
    }

    public String getResultB() {
        return this.resultB;
    }

    public RepeatJS setResultB(String resultB) {
        this.resultB = RepeatJS.nonNull(resultB);
        return this;
    }

    public String getResultC() {
        return this.resultC;
    }

    public RepeatJS setResultC(String resultC) {
        this.resultC = RepeatJS.nonNull(resultC);
        return this;
    }

    public String getResultD() {
        return this.resultD;
    }

    public RepeatJS setResultD(String resultD) {
        this.resultD = RepeatJS.nonNull(resultD);
        return this;
    }

    public String getResultI() {
        return this.resultI;
    }

    public RepeatJS setResultI(String resultI) {
        this.resultI = RepeatJS.nonNull(resultI);
        return this;
    }

    public String getResultJ() {
        return this.resultJ;
    }

    public RepeatJS setResultJ(String resultJ) {
        this.resultJ = RepeatJS.nonNull(resultJ);
        return this;
    }

    public String getResultK() {
        return this.resultK;
    }

    public RepeatJS setResultK(String resultK) {
        this.resultK = RepeatJS.nonNull(resultK);
        return this;
    }

    public String getResultX1() {
        return this.resultX1;
    }

    public RepeatJS setResultX1(String resultX1) {
        this.resultX1 = RepeatJS.nonNull(resultX1);
        return this;
    }

    public String getResultX2() {
        return this.resultX2;
    }

    public RepeatJS setResultX2(String resultX2) {
        this.resultX2 = RepeatJS.nonNull(resultX2);
        return this;
    }

    public String getResultX3() {
        return this.resultX3;
    }

    public RepeatJS setResultX3(String resultX3) {
        this.resultX3 = RepeatJS.nonNull(resultX3);
        return this;
    }

    public int getResultX1BlockLength() {
        return this.resultX1BlockLength;
    }

    public RepeatJS setResultX1BlockLength(int resultX1BlockLength) {
        this.resultX1BlockLength = RepeatJS.positive(resultX1BlockLength);
        return this;
    }

    public int getResultX2BlockLength() {
        return this.resultX2BlockLength;
    }

    public RepeatJS setResultX2BlockLength(int resultX2BlockLength) {
        this.resultX2BlockLength = RepeatJS.positive(resultX2BlockLength);
        return this;
    }

    public int getResultX3BlockLength() {
        return this.resultX3BlockLength;
    }

    public RepeatJS setResultX3BlockLength(int resultX3BlockLength) {
        this.resultX3BlockLength = RepeatJS.positive(resultX3BlockLength);
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public RepeatJS setStatus(String status) {
        this.status = RepeatJS.nonNull(status);
        return this;
    }

    public String getDoOperator() {
        return this.doOperator;
    }

    public RepeatJS setDoOperator(String doOperator) {
        this.doOperator = RepeatJS.nonNull(doOperator);
        return this;
    }

    public String getWhileCondition() {
        return this.whileCondition;
    }

    public RepeatJS setWhileCondition(String whileCondition) {
        this.whileCondition = RepeatJS.nonNull(whileCondition);
        return this;
    }

    public boolean isConvertInputScalarToNumber() {
        return this.graalAPI.isConvertInputScalarToNumber();
    }

    public RepeatJS setConvertInputScalarToNumber(boolean convertInputScalarToNumber) {
        this.graalAPI.setConvertInputScalarToNumber(convertInputScalarToNumber);
        return this;
    }

    public boolean isConvertInputNumbersToArray() {
        return this.graalAPI.isConvertInputNumbersToArray();
    }

    public RepeatJS setConvertInputNumbersToArray(boolean convertInputNumbersToArray) {
        this.graalAPI.setConvertInputNumbersToArray(convertInputNumbersToArray);
        return this;
    }

    public boolean isConvertInputArraysToDouble() {
        return this.graalAPI.isConvertInputArraysToDouble();
    }

    public RepeatJS setConvertInputArraysToDouble(boolean convertInputArraysToDouble) {
        this.graalAPI.setConvertInputArraysToDouble(convertInputArraysToDouble);
        return this;
    }

    public boolean isConvertOutputIntegerToBriefForm() {
        return this.graalAPI.isConvertOutputIntegerToBriefForm();
    }

    public RepeatJS setConvertOutputIntegersToBriefForm(boolean convertOutputIntegersToBriefForm) {
        this.graalAPI.setConvertOutputIntegersToBriefForm(convertOutputIntegersToBriefForm);
        return this;
    }

    public boolean isShareNamespace() {
        return this.shareNamespace;
    }

    public RepeatJS setShareNamespace(boolean shareNamespace) {
        if (shareNamespace != this.shareNamespace) {
            this.closePerformerContainer();
            this.shareNamespace = shareNamespace;
        }
        return this;
    }

    public boolean isCloseSharedContext() {
        return this.closeSharedContext;
    }

    public RepeatJS setCloseSharedContext(boolean closeSharedContext) {
        this.closeSharedContext = closeSharedContext;
        return this;
    }

    @Override
    public void initialize() {
        this.isFirstIteration = true;
        GraalPerformer performer = this.performerContainer().performer(this.getContextId());
        Value bindings = performer.bindingsJS();
        if (!this.initializingOperator.isEmpty()) {
            this.javaScriptInitializingOperator.setCommonJS(this.initializingOperator);
            this.putAllInputs(bindings, true);
            performer.perform(this.javaScriptInitializingOperator);
        }
    }

    @Override
    public void process() {
        GraalPerformer performer = this.performerContainer().performer(this.getContextId());
        this.putAllInputs(performer.bindingsJS(), false);
        this.javaScriptResultA.setCommonJS(this.resultA);
        this.javaScriptResultB.setCommonJS(this.resultB);
        this.javaScriptResultC.setCommonJS(this.resultC);
        this.javaScriptResultD.setCommonJS(this.resultD);
        this.javaScriptResultI.setCommonJS(this.resultI);
        this.javaScriptResultJ.setCommonJS(this.resultJ);
        this.javaScriptResultK.setCommonJS(this.resultK);
        this.javaScriptResultX1.setCommonJS(this.resultX1);
        this.javaScriptResultX2.setCommonJS(this.resultX2);
        this.javaScriptResultX3.setCommonJS(this.resultX3);
        this.javaScriptStatus.setCommonJS(this.status);
        this.javaScriptDoOperator.setCommonJS(this.doOperator);
        this.javaScriptWhileCondition.setCommonJS(this.whileCondition);
        Value result = performer.perform(this.javaScriptDoOperator);
        this.graalAPI.storeScalar(this, this.defaultOutputPortName(), result);
        this.getScalar().setTo(result);
        this.graalAPI.storeScalar(this, "a", performer.perform(this.javaScriptResultA));
        this.graalAPI.storeScalar(this, "b", performer.perform(this.javaScriptResultB));
        this.graalAPI.storeScalar(this, "c", performer.perform(this.javaScriptResultC));
        this.graalAPI.storeScalar(this, "d", performer.perform(this.javaScriptResultD));
        this.getScalar(OUTPUT_I).setTo(GraalValues.toSmartDouble(performer.perform(this.javaScriptResultI)));
        this.getScalar(OUTPUT_J).setTo(GraalValues.toSmartDouble(performer.perform(this.javaScriptResultJ)));
        this.getScalar(OUTPUT_K).setTo(GraalValues.toSmartDouble(performer.perform(this.javaScriptResultK)));
        if (!this.status.isBlank()) {
            this.uploadStatus(performer, this.javaScriptStatus);
        }
        this.graalAPI.storeNumbers(this, "x1", performer.perform(this.javaScriptResultX1), this.resultX1BlockLength);
        this.graalAPI.storeNumbers(this, "x2", performer.perform(this.javaScriptResultX2), this.resultX2BlockLength);
        this.graalAPI.storeNumbers(this, "x3", performer.perform(this.javaScriptResultX3), this.resultX3BlockLength);
        boolean whileCondition = GraalValues.toSmartBoolean(performer.perform(this.javaScriptWhileCondition));
        this.isLastIteration = !whileCondition;
        this.getScalar(OUTPUT_IS_FIRST).setTo(this.isFirstIteration);
        this.getScalar(OUTPUT_IS_LAST).setTo(this.isLastIteration);
        this.getScalar(OUTPUT_IS_NOT_FIRST).setTo(!this.isFirstIteration);
        this.getScalar(OUTPUT_IS_NOT_LAST).setTo(!this.isLastIteration);
        this.isFirstIteration = false;
    }

    @Override
    public void close() {
        super.close();
        this.closePerformerContainer();
    }

    @Override
    public boolean needToRepeat() {
        RepeatJS.logDebug(() -> (!this.isLastIteration ? "Repeating loop" : "FINISHING loop") + " according formula \"" + this.whileCondition + "\"");
        return !this.isLastIteration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePerformerContainer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.performerContainer != null) {
                this.performerContainer.freeResources(this.closeSharedContext);
                this.performerContainer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraalPerformerContainer performerContainer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.performerContainer == null) {
                this.performerContainer = GraalAPI.JS.getJSContainer(this.shareNamespace, GraalSafety.SAFE);
            }
            return this.performerContainer;
        }
    }

    private void putAllInputs(Value bindings, boolean putNullBindingForUninitialized) {
        bindings.putMember(FIRST_ITERATION_VARIABLE, (Object)this.isFirstIteration);
        this.graalAPI.loadScalar(bindings, this, "a", null);
        this.graalAPI.loadScalar(bindings, this, "b", null);
        this.graalAPI.loadScalar(bindings, this, "c", null);
        this.graalAPI.loadScalar(bindings, this, "d", null);
        this.graalAPI.loadScalar(bindings, this, INPUT_E, null);
        this.graalAPI.loadScalar(bindings, this, INPUT_F, null);
        this.graalAPI.loadNumbers(bindings, this, "x1", putNullBindingForUninitialized, X1_VARIABLE_ALT);
        this.graalAPI.loadNumbers(bindings, this, "x2", putNullBindingForUninitialized, new String[0]);
        this.graalAPI.loadNumbers(bindings, this, "x3", putNullBindingForUninitialized, new String[0]);
    }

    private void uploadStatus(GraalPerformer performer, GraalSourceContainer statusFormula) {
        ExecutionBlock caller = this.getCaller();
        if (!(caller instanceof Executor)) {
            return;
        }
        Executor executor = (Executor)caller;
        Value status = performer.perform(statusFormula);
        if (status == null) {
            return;
        }
        executor.status().setMessageString(status.toString());
    }
}

