/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.WriteFileOperation;

public final class RemoveFiles
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    private Stage stage = Stage.EXECUTE;
    private boolean doAction = true;
    private String globPattern = "*.(dat,tmp)";
    private boolean fileExistenceRequired = true;

    public RemoveFiles() {
        this.addInputScalar("file");
        this.setDefaultOutputScalar("absolute_path");
    }

    public Stage getStage() {
        return this.stage;
    }

    public RemoveFiles setStage(Stage stage) {
        this.stage = RemoveFiles.nonNull(stage);
        return this;
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public RemoveFiles setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public RemoveFiles setGlobPattern(String globPattern) {
        this.globPattern = RemoveFiles.nonEmpty(globPattern);
        return this;
    }

    public boolean isFileExistenceRequired() {
        return this.fileExistenceRequired;
    }

    public RemoveFiles setFileExistenceRequired(boolean fileExistenceRequired) {
        this.fileExistenceRequired = fileExistenceRequired;
        return this;
    }

    @Override
    public void initialize() {
        Path fileOrFolder = this.completeFilePath().toAbsolutePath();
        if (this.stage == Stage.RESET) {
            this.removeFiles(fileOrFolder);
        }
    }

    @Override
    public void process() {
        Path fileOrFolder = this.completeFilePath().toAbsolutePath();
        if (this.stage == Stage.EXECUTE) {
            this.removeFiles(fileOrFolder);
        }
    }

    public void removeFiles(Path fileOrFolder) {
        block13: {
            if (!this.doAction) {
                return;
            }
            try {
                if (Files.isRegularFile(fileOrFolder, new LinkOption[0])) {
                    RemoveFiles.logDebug(() -> "Removing file " + String.valueOf(fileOrFolder));
                    Files.delete(fileOrFolder);
                    break block13;
                }
                if (!Files.exists(fileOrFolder, new LinkOption[0])) {
                    if (this.fileExistenceRequired) {
                        throw new FileNotFoundException(String.valueOf(fileOrFolder) + " does not exist: nothing to remove");
                    }
                    return;
                }
                RemoveFiles.logDebug(() -> "Removing files " + this.globPattern + " from folder " + String.valueOf(fileOrFolder));
                try (DirectoryStream<Path> files = Files.newDirectoryStream(fileOrFolder, this.globPattern);){
                    for (Path f : files) {
                        if (!Files.isRegularFile(f, new LinkOption[0])) continue;
                        Files.delete(f);
                    }
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public static enum Stage {
        RESET,
        EXECUTE;

    }
}

