/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.files;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.WriteFileOperation;
import net.algart.executors.modules.core.files.RemoveFiles;

public final class CreateFolder
extends WriteFileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_ABSOLUTE_FOLDER = "absolute_folder";
    private RemoveFiles.Stage stage = RemoveFiles.Stage.EXECUTE;
    private boolean doAction = true;
    private boolean createParents = true;

    public CreateFolder() {
        this.addInputScalar("file");
        this.setDefaultOutputScalar(OUTPUT_ABSOLUTE_FOLDER);
        this.addOutputScalar("absolute_path");
    }

    public RemoveFiles.Stage getStage() {
        return this.stage;
    }

    public CreateFolder setStage(RemoveFiles.Stage stage) {
        this.stage = CreateFolder.nonNull(stage);
        return this;
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public CreateFolder setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public boolean isCreateParents() {
        return this.createParents;
    }

    public CreateFolder setCreateParents(boolean createParents) {
        this.createParents = createParents;
        return this;
    }

    @Override
    public void initialize() {
        Path folder = this.completeFilePathAndResultFolder().toAbsolutePath();
        if (this.stage == RemoveFiles.Stage.RESET) {
            this.createFolder(folder);
        }
    }

    @Override
    public void process() {
        Path folder = this.completeFilePathAndResultFolder().toAbsolutePath();
        if (this.stage == RemoveFiles.Stage.EXECUTE) {
            this.createFolder(folder);
        }
    }

    public void createFolder(Path folder) {
        if (!this.doAction) {
            return;
        }
        try {
            CreateFolder.logDebug(() -> "Creating " + String.valueOf(folder));
            if (!Files.isDirectory(folder, new LinkOption[0])) {
                if (this.createParents) {
                    Files.createDirectories(folder, new FileAttribute[0]);
                } else {
                    Files.createDirectory(folder, new FileAttribute[0]);
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private Path completeFilePathAndResultFolder() {
        Path path = this.completeFilePath();
        Object absolute = path.toAbsolutePath().toString();
        if (!((String)absolute).endsWith("/") && !((String)absolute).endsWith(File.separator)) {
            absolute = (String)absolute + File.separator;
        }
        this.getScalar(OUTPUT_ABSOLUTE_FOLDER).setTo((String)absolute);
        return path;
    }
}

