/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.matrices;

import java.util.ArrayList;
import java.util.List;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.multimatrix.MultiMatrix;

public abstract class MultiMatrixChannelFilter
extends MultiMatrixFilter
implements ChannelOperation {
    private int currentChannel = 0;
    private int numberOfChannels = 0;

    protected MultiMatrixChannelFilter() {
    }

    @Override
    public final int currentChannel() {
        return this.currentChannel;
    }

    @Override
    public final int numberOfChannels() {
        return this.numberOfChannels;
    }

    @Override
    public MultiMatrix process(MultiMatrix source) {
        List<Matrix<? extends PArray>> sourceChannels = source.allChannels();
        ArrayList<Matrix<? extends PArray>> result = new ArrayList<Matrix<? extends PArray>>();
        this.numberOfChannels = sourceChannels.size();
        this.currentChannel = 0;
        while (this.currentChannel < this.numberOfChannels) {
            Matrix<? extends PArray> m = sourceChannels.get(this.currentChannel);
            result.add(this.processChannel(m));
            ++this.currentChannel;
        }
        return MultiMatrix.of(result);
    }

    protected abstract Matrix<? extends PArray> processChannel(Matrix<? extends PArray> var1);
}

