/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.io;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;

public class PathPropertyReplacement {
    public static final String TMP_DIR_PREFIX = "%TEMP%";
    private static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("\\$\\{([%\\w\\.\\,\\-]+)\\}");
    private static final Pattern PROBABLE_PROPERTY_NAME_PATTERN = Pattern.compile("(%|\\$\\{|\\$\\$)");
    private static final String TMP_DIR_PREFIX_COMMON_START = "%TEMP";
    private static final String[] TMP_DIR_PREFIXES = new String[]{"%TEMP%/", "%TEMP%" + File.separator, "%TEMP%"};

    private PathPropertyReplacement() {
    }

    public static boolean hasProperties(String s) {
        Objects.requireNonNull(s, "Null string");
        return PROPERTY_NAME_PATTERN.matcher(s).find();
    }

    public static boolean hasProbableProperties(String s) {
        Objects.requireNonNull(s, "Null string");
        return PROBABLE_PROPERTY_NAME_PATTERN.matcher(s).find();
    }

    public static void checkProbableProperties(String path) {
        Objects.requireNonNull(path, "Null path");
        if (PathPropertyReplacement.hasProbableProperties(path)) {
            throw new SecurityException("Path probably contains some properties for possible replacements, it is dangerous and prohibited: \"" + path + "\" (it contains suspicious characters/substrings like \"%\" or \"${\")");
        }
    }

    public static void checkAbsolute(Path path) {
        Objects.requireNonNull(path, "Null path");
        if (!path.isAbsolute()) {
            throw new SecurityException("Path must be absolute, but it is not: \"" + String.valueOf(path) + "\"");
        }
    }

    public static Optional<Property> firstPathProperty(String s) {
        Matcher matcher = PROPERTY_NAME_PATTERN.matcher(s.trim());
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            Optional<Property> property = Property.of(propertyName);
            if (!property.isPresent()) continue;
            return property;
        }
        return Optional.empty();
    }

    public static String translatePathProperties(String s, Executor executor) {
        return PathPropertyReplacement.translatePathProperties(s, null, executor);
    }

    public static String translatePathProperties(String s, Path path) {
        return PathPropertyReplacement.translatePathProperties(s, path, null);
    }

    public static String translateTmpDir(String s) {
        Objects.requireNonNull(s, "Null string");
        if (s.startsWith(TMP_DIR_PREFIX_COMMON_START)) {
            for (String prefix : TMP_DIR_PREFIXES) {
                if (!s.startsWith(prefix)) continue;
                Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                return tmpDir.resolve(s.substring(prefix.length())).toString();
            }
            throw new IllegalArgumentException("Path \"" + s + "\" starts with %TEMP, but this keyword is not finished properly: one of prefixes " + String.join((CharSequence)", ", TMP_DIR_PREFIXES) + " expected");
        }
        return s;
    }

    public static String translateSystemProperties(String s) {
        Objects.requireNonNull(s, "Null string");
        s = s.trim();
        Matcher matcher = PROPERTY_NAME_PATTERN.matcher(s);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String property = System.getProperty(propertyName);
            if (property == null) {
                throw new IllegalArgumentException("Non-existing property \"" + propertyName + "\" in the string \"" + s + "\"");
            }
            property = PathPropertyReplacement.correctDirSystemProperty(propertyName, property);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(property));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String translateProperties(String s, Path path) {
        s = PathPropertyReplacement.translatePathProperties(s, path);
        s = PathPropertyReplacement.translateSystemProperties(s);
        s = PathPropertyReplacement.translateTmpDir(s);
        return s;
    }

    public static Path translatePropertiesAndCurrentDirectory(String s, Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        s = PathPropertyReplacement.translatePathProperties(s, executor);
        s = PathPropertyReplacement.translateSystemProperties(s);
        s = PathPropertyReplacement.translateTmpDir(s);
        return executor.translateCurrentDirectory(Paths.get(s, new String[0]));
    }

    private static Path removeExtension(Path path) {
        if (path == null) {
            return null;
        }
        String fileName = path.toString();
        int p = fileName.lastIndexOf(46);
        return p == -1 ? path : Paths.get(fileName.substring(0, p), new String[0]);
    }

    private static String translatePathProperties(String s, Path path, Executor executor) {
        Objects.requireNonNull(s, "Null string");
        Matcher matcher = PROPERTY_NAME_PATTERN.matcher(s.trim());
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            Optional<Property> property = Property.of(propertyName);
            String propertyValue = property.map(value -> value.replacement(path, executor, s)).orElseGet(matcher::group);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(propertyValue));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String correctDirSystemProperty(String propertyName, String property) {
        if ((propertyName.equals("java.io.tmpdir") || propertyName.equals("user.home") || propertyName.equals("user.dir")) && !property.endsWith("/") && !property.endsWith(File.separator)) {
            return property + File.separator;
        }
        return property;
    }

    public static enum Property {
        FILE_PATH("path.name", path -> PathPropertyReplacement.removeExtension(path.toAbsolutePath()), ExecutionBlock::contextPath),
        FILE_PATH_EXT("path.name.ext", Path::toAbsolutePath, ExecutionBlock::contextPath),
        FILE_NAME("file.name", path -> PathPropertyReplacement.removeExtension(path.getFileName()), ExecutionBlock::contextPath),
        FILE_NAME_EXT("file.name.ext", Path::getFileName, ExecutionBlock::contextPath),
        RESOURCE_FOLDER("resources", Path::toAbsolutePath, Executor::executorResourceFolder);

        private static final Map<String, Property> ALL_PROPERTIES;
        private final String name;
        private final Function<Path, Path> replacePath;
        private final Function<Executor, Path> getPath;

        private Property(String name, Function<Path, Path> replacePath, Function<Executor, Path> getPath) {
            this.name = name;
            this.replacePath = replacePath;
            this.getPath = getPath;
        }

        public static Optional<Property> of(String propertyName) {
            return Optional.ofNullable(ALL_PROPERTIES.get(propertyName));
        }

        public String propertyName() {
            return this.name;
        }

        String replacement(Path path, Executor executor, String stringForException) {
            if (executor != null) {
                path = this.getPath.apply(executor);
            }
            return this.replacement(path, stringForException);
        }

        private String replacement(Path path, String stringForException) {
            if (path == null) {
                throw new IllegalArgumentException("String \"" + stringForException + "\" contains special path property \"" + this.name + "\" and cannot be resolved, because there is no any path for replacement (it is null)");
            }
            Path result = this.replacePath.apply(path);
            if (result == null) {
                throw new IllegalArgumentException("Cannot find required replacement for property \"" + this.name + "\" in the path \"" + String.valueOf(path) + "\"; probably this path is empty");
            }
            return result.toString();
        }

        static {
            ALL_PROPERTIES = Stream.of(Property.values()).collect(Collectors.toMap(Property::propertyName, e -> e));
        }
    }
}

