/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.common.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;
import net.algart.io.MatrixIO;

public abstract class FileOperation
extends Executor {
    public static final String INPUT_FILE = "file";
    public static final String INPUT_FILE_NAME_ADDITION = "file_name_addition";
    public static final String OUTPUT_ABSOLUTE_PATH = "absolute_path";
    public static final String OUTPUT_OS_PATH = "os_path";
    public static final String OUTPUT_PARENT_FOLDER = "parent_folder";
    public static final String OUTPUT_FILE_NAME = "file_name";
    public static final String DEFAULT_EMPTY_FILE = "";
    public static final String FILE_NAME_ADDITION_PATTERN = "$$$";
    private final boolean readOnly;
    private String file = "";
    private FileNameAdditionMode fileNameAdditionMode = FileNameAdditionMode.NONE;
    private boolean secure = false;

    protected FileOperation() {
        this(true);
    }

    public FileOperation(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    public String getFile() {
        return this.file;
    }

    public FileOperation setFile(String file) {
        this.file = FileOperation.nonNull(file);
        return this;
    }

    public FileOperation setFile(Path file) {
        this.file = FileOperation.nonNull(file).toString();
        return this;
    }

    public FileNameAdditionMode getFileNameAdditionMode() {
        return this.fileNameAdditionMode;
    }

    public FileOperation setFileNameAdditionMode(FileNameAdditionMode fileNameAdditionMode) {
        this.fileNameAdditionMode = FileOperation.nonNull(fileNameAdditionMode);
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public FileOperation setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public final String filePath() {
        String inputFile = this.hasInputPort(INPUT_FILE) ? this.getInputScalar(INPUT_FILE, true).getValue() : null;
        String result = inputFile != null ? inputFile : this.file;
        return FileOperation.nonEmpty(result.trim(), INPUT_FILE);
    }

    public Path completeOSFilePath(boolean relativize) {
        return this.completeOSFilePath(this.filePath(), relativize, true);
    }

    public Path completeOSFilePath(String filePath, boolean relativize, boolean processPorts) {
        Path completed = this.completeFilePath(filePath, processPorts);
        Path result = FileOperation.simplifyOSPath(completed, relativize);
        if (processPorts) {
            this.setOutputScalar(OUTPUT_OS_PATH, () -> result);
        }
        return result;
    }

    public Path completeFilePath() {
        return this.completeFilePath(this.filePath());
    }

    public final List<Path> completeSeveralFilePaths() {
        return this.completeSeveralFilePaths(this.filePath());
    }

    public final Path completeFilePath(String filePath) {
        return this.completeFilePath(filePath, true);
    }

    public final Path completeFilePath(String filePath, boolean processPorts) {
        Objects.requireNonNull(filePath, "Null file path");
        filePath = filePath.trim();
        if (processPorts && this.fileNameAdditionMode != FileNameAdditionMode.NONE) {
            if (this.secure) {
                throw new SecurityException("File name additions must not be used in secure mode, but actually " + String.valueOf((Object)this.fileNameAdditionMode) + " is selected");
            }
            String addition = this.getInputScalar(INPUT_FILE_NAME_ADDITION).getValue();
            filePath = this.fileNameAdditionMode.completePath(filePath, addition);
        }
        if (this.readOnly || !this.secure) {
            filePath = PathPropertyReplacement.translatePathProperties(filePath, this);
        }
        if (!this.secure) {
            filePath = PathPropertyReplacement.translateSystemProperties(filePath);
        }
        filePath = PathPropertyReplacement.translateTmpDir(filePath);
        if (this.secure) {
            PathPropertyReplacement.checkProbableProperties(filePath);
        }
        Path path = Paths.get(filePath, new String[0]);
        if (this.readOnly || !this.secure) {
            path = this.translateCurrentDirectory(path);
        } else {
            PathPropertyReplacement.checkAbsolute(path);
        }
        if (processPorts) {
            this.fillOutputFileInformation(path);
        }
        return path;
    }

    public final List<Path> completeSeveralFilePaths(String filePathsSeparatedBySemicolon) {
        Objects.requireNonNull(filePathsSeparatedBySemicolon, "Null file paths");
        ArrayList<Path> result = new ArrayList<Path>();
        for (String filePath : filePathsSeparatedBySemicolon.split("[\\;]")) {
            result.add(this.completeFilePath(filePath));
        }
        return result;
    }

    public void fillOutputFileInformation(Path path) {
        Path fileName;
        Path parent;
        Path absolutePath = path.toAbsolutePath();
        this.setOutputScalar(OUTPUT_ABSOLUTE_PATH, absolutePath::toString);
        if (this.hasOutputPort(OUTPUT_PARENT_FOLDER) && (parent = absolutePath.getParent()) != null) {
            this.getScalar(OUTPUT_PARENT_FOLDER).setTo(parent.toString());
        }
        if (this.hasOutputPort(OUTPUT_FILE_NAME) && (fileName = absolutePath.getFileName()) != null) {
            this.getScalar(OUTPUT_FILE_NAME).setTo(fileName.toString());
        }
    }

    protected final void addFileOperationPorts() {
        this.addInputScalar(INPUT_FILE);
        this.addInputScalar(INPUT_FILE_NAME_ADDITION);
        this.addOutputScalar(OUTPUT_ABSOLUTE_PATH);
        this.addOutputScalar(OUTPUT_PARENT_FOLDER);
        this.addOutputScalar(OUTPUT_FILE_NAME);
    }

    public static Path currentOSPath() {
        return Paths.get(DEFAULT_EMPTY_FILE, new String[0]).toAbsolutePath();
    }

    public static Path relativizePathInsideCurrentOrParent(Path absolutePath) {
        Objects.requireNonNull(absolutePath, "Null absolutePath");
        Path osPath = FileOperation.currentOSPath();
        if (absolutePath.startsWith(osPath)) {
            return osPath.relativize(absolutePath);
        }
        Path osParent = osPath.getParent();
        if (osParent != null && absolutePath.startsWith(osParent)) {
            return osPath.relativize(absolutePath);
        }
        return absolutePath;
    }

    public static Path simplifyOSPath(Path path, boolean relativize) {
        Objects.requireNonNull(path, "Null path");
        return relativize ? FileOperation.relativizePathInsideCurrentOrParent(path.toAbsolutePath()) : path.toAbsolutePath();
    }

    public static enum FileNameAdditionMode {
        NONE{

            @Override
            public String completePath(String path, String fileNameAddition) {
                return path;
            }
        }
        ,
        AFTER_ALL_PATH{

            @Override
            public String completePath(String path, String fileNameAddition) {
                return path + fileNameAddition.trim();
            }
        }
        ,
        REPLACE_IN_PATH{

            @Override
            public String completePath(String path, String fileNameAddition) {
                return path.replace(FileOperation.FILE_NAME_ADDITION_PATTERN, fileNameAddition.trim());
            }
        }
        ,
        REPLACE_IN_PATH_REMOVING_EXTENSION{

            @Override
            public String completePath(String path, String fileNameAddition) {
                return path.replace(FileOperation.FILE_NAME_ADDITION_PATTERN, MatrixIO.removeExtension((String)fileNameAddition.trim()));
            }
        };


        public abstract String completePath(String var1, String var2);
    }
}

