/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Objects;
import java.util.UUID;
import net.algart.executors.api.CommonPlatformInformation;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.extensions.InstalledExtensions;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;

class SpecialSpecificationsBuilder {
    public static final String PLATFORM_LANGUAGE = "system";
    private final ExecutorSpecificationSet specifications;

    public SpecialSpecificationsBuilder(ExecutorSpecificationSet specifications) {
        this.specifications = Objects.requireNonNull(specifications, "Null specifications");
    }

    public boolean addSpecifications() {
        ExecutorSpecification pattern = this.findCommonPlatformInformationPattern();
        if (pattern != null) {
            this.specifications.remove(pattern.getId());
            for (ExtensionSpecification.Platform platform : InstalledExtensions.allInstalledPlatforms()) {
                this.specifications.add(this.newCommonPlatformInformationSpecification(pattern, platform));
            }
            return true;
        }
        return false;
    }

    private ExecutorSpecification findCommonPlatformInformationPattern() {
        for (ExecutorSpecification specification : this.specifications.all()) {
            String className;
            ExecutorSpecification.Java java;
            if (!specification.isJavaExecutor() || (java = specification.getJava()) == null || !Objects.equals(className = java.getClassName(), CommonPlatformInformation.class.getName())) continue;
            return specification;
        }
        return null;
    }

    private ExecutorSpecification newCommonPlatformInformationSpecification(ExecutorSpecification pattern, ExtensionSpecification.Platform platform) {
        Objects.requireNonNull(pattern, "Null pattern");
        Objects.requireNonNull(platform, "Null platform");
        ExecutorSpecification result = new ExecutorSpecification();
        result.setId(SpecialSpecificationsBuilder.makeId(pattern.getId(), platform));
        result.setPlatformId(platform.getId());
        result.setName(SpecialSpecificationsBuilder.replacePlatformName(pattern.getName(), platform));
        result.setCategory(pattern.getCategory());
        result.setDescription(SpecialSpecificationsBuilder.replacePlatformName(pattern.getDescription(), platform));
        result.setLanguage(PLATFORM_LANGUAGE);
        result.setJava(new ExecutorSpecification.Java().setJson(ExecutorSpecification.Java.standardJson(CommonPlatformInformation.class.getName())));
        result.setInputPorts(pattern.getInputPorts());
        result.setOutputPorts(pattern.getOutputPorts());
        result.setControls(pattern.getControls());
        return result;
    }

    private static String replacePlatformName(String s, ExtensionSpecification.Platform platform) {
        return s == null ? null : s.replace("$$$", platform.getName());
    }

    private static String makeId(String commonPlatformInformationId, ExtensionSpecification.Platform platform) {
        UUID uuid;
        try {
            uuid = UUID.fromString(platform.getId());
        }
        catch (Exception e) {
            return platform.getId() + "~~" + CommonPlatformInformation.class.getSimpleName();
        }
        long correction = (long)commonPlatformInformationId.hashCode() & 0xFFFFFFFFL;
        uuid = new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits() ^ correction);
        return uuid.toString();
    }
}

