/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SmartSearchSettings;
import net.algart.json.Jsons;

public final class SettingsTree {
    private static final System.Logger LOG = System.getLogger(SettingsTree.class.getName());
    private final SmartSearchSettings smartSearch;
    private final ExecutorSpecificationFactory factory;
    private final ExecutorSpecification specification;
    private final Map<String, SettingsTree> subTrees = new LinkedHashMap<String, SettingsTree>();
    private final SettingsTree parent;
    private final Path path;
    private final List<Path> treePaths = new ArrayList<Path>();
    private final List<Path> controlPaths = new ArrayList<Path>();
    private final boolean complete;

    private SettingsTree(SmartSearchSettings smartSearch, ExecutorSpecificationFactory factory, ExecutorSpecification specification, SettingsTree parent, Path currentPath, Set<String> stackForDetectingRecursion) {
        this.smartSearch = smartSearch;
        this.factory = Objects.requireNonNull(factory, "Null specification factory");
        assert (smartSearch == null || smartSearch.factory() == factory);
        this.specification = Objects.requireNonNull(specification, "Null settings specification");
        this.parent = parent;
        this.path = currentPath == null ? new Path() : currentPath;
        this.complete = this.buildTree(stackForDetectingRecursion);
    }

    private SettingsTree(SmartSearchSettings smartSearch, ExecutorSpecificationFactory factory, ExecutorSpecification specification, SettingsTree parent) {
        this(smartSearch, factory, specification, parent, null, new HashSet<String>());
    }

    public static SettingsTree of(SmartSearchSettings smartSearch, ExecutorSpecification specification) {
        Objects.requireNonNull(smartSearch, "Null smart search");
        return new SettingsTree(smartSearch, smartSearch.factory(), specification, null);
    }

    public static SettingsTree of(ExecutorSpecificationFactory factory, ExecutorSpecification specification) {
        return new SettingsTree(null, factory, specification, null);
    }

    public Path newPath(String ... names) {
        return new Path(names);
    }

    public Path newPath(Collection<String> names) {
        return new Path(names);
    }

    public ExecutorSpecificationFactory factory() {
        return this.factory;
    }

    public ExecutorSpecification specification() {
        return this.specification;
    }

    public Path path() {
        return this.path;
    }

    public SettingsTree parent() {
        return this.parent;
    }

    public Path childPath(String name) {
        return this.path.child(name);
    }

    public SettingsTree child(String name) {
        Objects.requireNonNull(name, "Null name");
        return this.subTrees.get(name);
    }

    public Map<String, SettingsTree> children() {
        return Collections.unmodifiableMap(this.subTrees);
    }

    public List<Path> treePaths() {
        return Collections.unmodifiableList(this.treePaths);
    }

    public List<Path> controlPaths() {
        return Collections.unmodifiableList(this.controlPaths);
    }

    public int numberOfTrees() {
        return this.treePaths.size();
    }

    public String id() {
        return this.specification.getId();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public JsonObject specificationJson() {
        return this.specificationJson(ExecutorSpecification.JsonMode.MEDIUM);
    }

    public JsonObject specificationJson(ExecutorSpecification.JsonMode mode) {
        this.specification.checkCompleteness();
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.specification.buildJson(builder, mode, name -> this.childJsonTree((String)name, mode));
        return builder.build();
    }

    public JsonObject settingsJson(Function<Path, JsonValue> controlToJson) {
        Objects.requireNonNull(controlToJson, "Null controlToJson");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.buildSettingsJson(builder, controlToJson);
        return builder.build();
    }

    public JsonObject defaultSettingsJson() {
        return this.settingsJson(path -> path.reqControl().getDefaultJsonValue());
    }

    public String specificationJsonString() {
        return Jsons.toPrettyString(this.specificationJson());
    }

    public String specificationJsonString(ExecutorSpecification.JsonMode mode) {
        return Jsons.toPrettyString(this.specificationJson(mode));
    }

    public String defaultSettingsJsonString() {
        return Jsons.toPrettyString(this.defaultSettingsJson());
    }

    public String toString() {
        return "settings tree" + (this.smartSearch != null ? " (smart)" : "") + " for executor \"" + this.specification.canonicalName() + "\" (" + this.specification.getId() + "): " + this.subTrees.size() + " children";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildTree(Set<String> stackForDetectingRecursion) {
        LinkedHashMap<String, SettingsTree> children = new LinkedHashMap<String, SettingsTree>();
        boolean complete = true;
        stackForDetectingRecursion.add(this.specification.getId());
        this.treePaths.add(this.path);
        try {
            for (Map.Entry<String, ControlSpecification> entry : this.specification.controls.entrySet()) {
                String name = entry.getKey();
                ControlSpecification control = entry.getValue();
                Path childPath = this.path.child(control.getName());
                this.controlPaths.add(childPath);
                if (!control.isSubSettings()) continue;
                String settingsId = control.getSettingsId();
                if (settingsId == null && this.smartSearch != null) {
                    this.smartSearch.search();
                    settingsId = control.getSettingsId();
                }
                boolean found = settingsId != null;
                complete &= found;
                if (found) {
                    ExecutorSpecification childSettings = this.factory.getSpecification(settingsId);
                    if (childSettings == null) {
                        throw new IllegalStateException("Child settings with ID \"" + settingsId + "\" (child control \"" + name + "\") is not found");
                    }
                    if (stackForDetectingRecursion.contains(settingsId)) {
                        throw new IllegalStateException("Cannot build tree due to recursive link to settings ID \"" + settingsId + "\" (child control \"" + name + "\") detected in the settings with ID \"" + this.specification.getId() + "\" (\"" + this.specification.getName() + "\" in category \"" + this.specification.getCategory() + "\")");
                    }
                    SettingsTree child = new SettingsTree(this.smartSearch, this.factory, childSettings, this, childPath, stackForDetectingRecursion);
                    this.treePaths.addAll(child.treePaths);
                    this.controlPaths.addAll(child.controlPaths);
                    complete &= child.complete;
                    children.put(name, child);
                    continue;
                }
                LOG.log(System.Logger.Level.DEBUG, () -> "Sub-settings " + name + " not found");
            }
        }
        finally {
            stackForDetectingRecursion.remove(this.specification.getId());
        }
        this.subTrees.clear();
        this.subTrees.putAll(children);
        return complete;
    }

    private void buildSettingsJson(JsonObjectBuilder builder, Function<Path, JsonValue> controlToJson) {
        Objects.requireNonNull(builder, "Null builder");
        for (Map.Entry<String, ControlSpecification> entry : this.specification.controls.entrySet()) {
            SettingsTree child;
            String name = entry.getKey();
            ControlSpecification control = entry.getValue();
            if ("settings".equals(name)) continue;
            if (control.isSubSettings() && (child = this.child(name)) != null) {
                JsonObjectBuilder subTreeBuilder = Json.createObjectBuilder();
                child.buildSettingsJson(subTreeBuilder, controlToJson);
                builder.add(control.key(), (JsonValue)subTreeBuilder.build());
                continue;
            }
            JsonValue value = controlToJson.apply(this.childPath(name));
            if (value == null) continue;
            builder.add(control.key(), value);
        }
    }

    private JsonObject childJsonTree(String name, ExecutorSpecification.JsonMode mode) {
        return this.subTrees.containsKey(name) ? this.subTrees.get(name).specificationJson(mode) : null;
    }

    private JsonObject childDefaultSettingsJsonTree(String name) {
        return this.subTrees.containsKey(name) ? this.subTrees.get(name).defaultSettingsJson() : null;
    }

    public final class Path {
        private final String[] names;

        private Path() {
            this.names = new String[0];
        }

        private Path(String[] names) {
            this.names = Objects.requireNonNull(names, "Null names");
            this.checkNames();
        }

        private Path(Collection<String> names) {
            Objects.requireNonNull(names, "Null names");
            this.names = names.toArray(new String[0]);
            this.checkNames();
        }

        public List<String> names() {
            return List.of(this.names);
        }

        public String name(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("Negative name index " + index);
            }
            if (index >= this.names.length) {
                throw new IndexOutOfBoundsException("Name index " + index + " is out of range 0 <= i < " + this.names.length);
            }
            return this.names[index];
        }

        public String lastName() {
            if (this.names.length == 0) {
                throw new IllegalStateException("Empty names array");
            }
            return this.names[this.names.length - 1];
        }

        public boolean isEmpty() {
            return this.names.length == 0;
        }

        public int length() {
            return this.names.length;
        }

        public Path root() {
            return new Path();
        }

        public Path parent() {
            if (this.names.length == 0) {
                return null;
            }
            return new Path(Arrays.copyOf(this.names, this.names.length - 1));
        }

        public Path child(String name) {
            Objects.requireNonNull(name, "Null name");
            String[] childNames = Arrays.copyOf(this.names, Math.addExact(this.names.length, 1));
            childNames[childNames.length - 1] = name;
            return new Path(childNames);
        }

        public boolean startsWith(Path other) {
            Objects.requireNonNull(other, "Null other path");
            if (other.names.length > this.names.length) {
                return false;
            }
            for (int i = 0; i < other.names.length; ++i) {
                if (other.names[i].equals(this.names[i])) continue;
                return false;
            }
            return true;
        }

        public SettingsTree rootTree() {
            return SettingsTree.this;
        }

        public SettingsTree getTree() {
            return this.getTree(this.names.length, false);
        }

        public SettingsTree reqTree() {
            return this.getTree(this.names.length, true);
        }

        public ControlSpecification getControl() {
            if (this.names.length == 0) {
                return null;
            }
            SettingsTree tree = this.getTree(this.names.length - 1, false);
            return tree == null ? null : tree.specification.getControl(this.names[this.names.length - 1]);
        }

        public ControlSpecification reqControl() {
            if (this.names.length == 0) {
                throw new IllegalStateException("The root path \"" + String.valueOf(this) + "\" has no corresponding control");
            }
            SettingsTree tree = this.getTree(this.names.length - 1, true);
            assert (tree != null);
            ControlSpecification control = tree.specification.getControl(this.names[this.names.length - 1]);
            if (control == null) {
                throw new IllegalStateException("Path \"" + String.valueOf(this) + "\" does not exist: no control \"" + this.names[this.names.length - 1] + "\"");
            }
            return control;
        }

        private SettingsTree getTree(int n, boolean requireExistence) {
            SettingsTree tree = SettingsTree.this;
            for (int i = 0; i < n; ++i) {
                String name = this.names[i];
                tree = tree.subTrees.get(name);
                if (tree != null) continue;
                if (requireExistence) {
                    throw new IllegalStateException("Path \"" + String.valueOf(this) + "\" does not exist: no sub-tree \"" + name + "\"");
                }
                return null;
            }
            return tree;
        }

        public String toString() {
            return "/" + String.join((CharSequence)"/", this.names);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return path.rootTree() == this.rootTree() && Objects.deepEquals(this.names, path.names);
        }

        public int hashCode() {
            return 31 * Arrays.hashCode(this.names) + SettingsTree.this.hashCode();
        }

        private void checkNames() {
            for (String name : this.names) {
                Objects.requireNonNull(name, "Null name in the path");
            }
        }
    }
}

