/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

public enum ExecutionStage {
    LOADING_TIME("loading_time"),
    RUN_TIME("run_time");

    private final String stageName;

    private ExecutionStage(String stageName) {
        this.stageName = stageName;
    }

    public String stageName() {
        return this.stageName;
    }

    public static ExecutionStage of(String name) {
        ExecutionStage result = ExecutionStage.ofOrNull(name);
        if (result == null) {
            throw new IllegalArgumentException("Unknown stage name: " + name);
        }
        return result;
    }

    public static ExecutionStage ofOrNull(String name) {
        for (ExecutionStage stage : ExecutionStage.values()) {
            if (!stage.stageName.equals(name)) continue;
            return stage;
        }
        return null;
    }

    public static void main(String[] args) {
        for (ExecutionStage stage : ExecutionStage.values()) {
            System.out.printf("%s: %s, %s%n", new Object[]{stage, stage.stageName(), ExecutionStage.of(stage.stageName())});
        }
    }
}

