/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.system;

import java.util.Objects;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorExpectedException;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationSet;

public class DefaultExecutorFactory
implements ExecutorFactory {
    private final ExecutorLoaderSet loaderSet;
    private final ExecutorSpecificationSet preloadedSpecifications;
    private final ExecutorSpecificationSet dynamicSpecificationsCache = ExecutorSpecificationSet.newInstance();
    private final String sessionId;
    private final Object lock = new Object();

    public DefaultExecutorFactory(ExecutorLoaderSet loaderSet, String sessionId, ExecutorSpecificationSet preloadedSpecifications) {
        this.loaderSet = Objects.requireNonNull(loaderSet);
        this.sessionId = Objects.requireNonNull(sessionId, "Null sessionId");
        this.preloadedSpecifications = Objects.requireNonNull(preloadedSpecifications, "Null static executors set");
    }

    public final ExecutorLoaderSet loaderSet() {
        return this.loaderSet;
    }

    @Override
    public final String sessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorSpecification getSpecification(String executorId) {
        Object object = this.lock;
        synchronized (object) {
            ExecutorSpecification specification = this.preloadedSpecifications.get(executorId);
            if (specification != null) {
                return specification;
            }
            specification = this.dynamicSpecificationsCache.get(executorId);
            if (specification != null) {
                return specification;
            }
            specification = this.loaderSet.getSpecification(this.sessionId, executorId, true);
            if (specification == null) {
                return null;
            }
            this.dynamicSpecificationsCache.add(executorId, specification);
            return specification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionBlock newExecutor(String executorId, CreateMode createMode) throws ClassNotFoundException, ExecutorExpectedException {
        Objects.requireNonNull(executorId, "Null executorId");
        Objects.requireNonNull(createMode, "Null createMode");
        Object object = this.lock;
        synchronized (object) {
            ExecutorSpecification specification = this.getSpecification(executorId);
            if (specification == null) {
                throw new ExecutorExpectedException("Cannot create executor: non-registered ID \"" + executorId + "\"");
            }
            return this.loaderSet.newExecutor(this.sessionId, specification, createMode);
        }
    }

    public String toString() {
        return "default executor factory for session \"" + this.sessionId + "\"";
    }
}

