/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.mappings.core;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.api.mappings.MappingBuilder;
import net.algart.executors.api.mappings.MappingSpecification;
import net.algart.executors.api.mappings.core.MappingExecutor;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorFactory;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.json.Jsons;

public class UseMapping
extends FileOperation {
    public static final String MAPPING_LANGUAGE = "mapping";
    public static final String CATEGORY_PREFIX = "$";
    private static final DefaultExecutorLoader<MappingBuilder> MAPPING_LOADER = new DefaultExecutorLoader("mappings loader");
    private String mappingKeysFile = null;
    private String mappingEnumItemsFile = null;
    private String mappingJsonContent = "";
    private boolean advancedParameters = false;

    public UseMapping() {
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public static UseMapping getInstance() {
        return new UseMapping();
    }

    public static UseMapping getSharedInstance() {
        return UseMapping.setShared(new UseMapping());
    }

    public static DefaultExecutorLoader<MappingBuilder> mappingLoader() {
        return MAPPING_LOADER;
    }

    public String getMappingKeysFile() {
        return this.mappingKeysFile;
    }

    public UseMapping setMappingKeysFile(String mappingKeysFile) {
        this.mappingKeysFile = mappingKeysFile;
        return this;
    }

    public String getMappingEnumItemsFile() {
        return this.mappingEnumItemsFile;
    }

    public UseMapping setMappingEnumItemsFile(String mappingEnumItemsFile) {
        this.mappingEnumItemsFile = mappingEnumItemsFile;
        return this;
    }

    public String getMappingJsonContent() {
        return this.mappingJsonContent;
    }

    public UseMapping setMappingJsonContent(String mappingJsonContent) {
        this.mappingJsonContent = UseMapping.nonNull(mappingJsonContent);
        return this;
    }

    public boolean isAdvancedParameters() {
        return this.advancedParameters;
    }

    public UseMapping setAdvancedParameters(boolean advancedParameters) {
        this.advancedParameters = advancedParameters;
        return this;
    }

    @Override
    public UseMapping setFile(String file) {
        super.setFile(file);
        return this;
    }

    public static MappingExecutor newSharedExecutor(ExecutorFactory factory, Path file) throws IOException {
        return UseMapping.newSharedExecutor(factory, MappingSpecification.read(file));
    }

    public static MappingExecutor newSharedExecutor(ExecutorFactory factory, MappingSpecification specification) throws IOException {
        return UseMapping.getSharedInstance().newExecutor(factory, specification);
    }

    public MappingExecutor newExecutor(ExecutorFactory factory, Path file) throws IOException {
        Objects.requireNonNull(factory, "Null executor factory");
        return this.newExecutor(factory, MappingSpecification.read(file));
    }

    public MappingExecutor newExecutor(ExecutorFactory factory, MappingSpecification specification) throws IOException {
        Objects.requireNonNull(factory, "Null executor factory");
        return factory.newExecutor(MappingExecutor.class, this.use(specification).id(), CreateMode.REQUEST_DEFAULT);
    }

    @Override
    public void process() {
        try {
            if (!this.getFile().trim().isEmpty()) {
                this.useSeveralPaths(this.completeSeveralFilePaths());
                return;
            }
            String mappingJsonContent = this.mappingJsonContent.trim();
            if (!mappingJsonContent.isEmpty()) {
                this.useContent(mappingJsonContent);
                return;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        throw new IllegalArgumentException("One of arguments \"Mapping JSON file/folder\" or \"Mapping JSON content\" must be non-empty");
    }

    public void useSeveralPaths(List<Path> mappingSpecificationsPaths) throws IOException {
        Objects.requireNonNull(mappingSpecificationsPaths, "Null mapping paths");
        StringBuilder sb = this.isOutputNecessary(DEFAULT_OUTPUT_PORT) ? new StringBuilder() : null;
        for (Path path : mappingSpecificationsPaths) {
            this.usePath(path, sb);
        }
        if (sb != null) {
            this.getScalar().setTo(sb.toString());
        }
    }

    public void usePath(Path mappingSpecificationPath, StringBuilder report) throws IOException {
        Objects.requireNonNull(mappingSpecificationPath, "Null mapping path");
        List<MappingSpecification> mappingSpecifications = Files.isDirectory(mappingSpecificationPath, new LinkOption[0]) ? MappingSpecification.readAllIfValid(mappingSpecificationPath) : Collections.singletonList(MappingSpecification.read(mappingSpecificationPath));
        MappingSpecification.checkIdDifference(mappingSpecifications);
        int n = mappingSpecifications.size();
        for (int i = 0; i < n; ++i) {
            MappingSpecification mappingSpecification = mappingSpecifications.get(i);
            UseMapping.logDebug("Loading settings " + (String)(n > 1 ? i + 1 + "/" + n + " " : "") + "from " + String.valueOf(mappingSpecification.getSpecificationFile().toAbsolutePath()) + "...");
            this.use(mappingSpecification);
            if (report == null) continue;
            report.append(mappingSpecification.getSpecificationFile()).append("\n");
        }
    }

    public void useContent(String mappingJsonContent) throws IOException {
        MappingSpecification mappingSpecification = MappingSpecification.of(Jsons.toJson(mappingJsonContent), false);
        UseMapping.logDebug("Using mapping '" + mappingSpecification.getName() + "' from the text argument...");
        this.use(mappingSpecification);
        if (this.isOutputNecessary(DEFAULT_OUTPUT_PORT)) {
            this.getScalar().setTo(mappingSpecification.jsonString());
        }
    }

    public MappingBuilder use(MappingSpecification mappingSpecification) throws IOException {
        mappingSpecification.updateAutogeneratedCategory(false);
        String sessionId = this.getSessionId();
        MappingBuilder mappingBuilder = this.mappingBuilder(mappingSpecification);
        ExecutorSpecification specification = this.buildMappingSpecification(mappingBuilder);
        MAPPING_LOADER.registerWorker(sessionId, specification, mappingBuilder);
        return mappingBuilder;
    }

    public MappingBuilder mappingBuilder(MappingSpecification mappingSpecification) throws IOException {
        return this.mappingBuilder(mappingSpecification, true);
    }

    public MappingBuilder mappingBuilder(MappingSpecification mappingSpecification, boolean calledWithObject) throws IOException {
        SScalar.MultiLineOrJsonSplitter keys = this.keys(mappingSpecification, calledWithObject);
        SScalar.MultiLineOrJsonSplitter items = this.enumItems(mappingSpecification, calledWithObject);
        return MappingBuilder.of(mappingSpecification, keys.lines(), keys.comments(), items == null ? null : items.lines(), items == null ? null : items.comments());
    }

    public ExecutorSpecification buildMappingSpecification(MappingBuilder mappingBuilder) {
        Objects.requireNonNull(mappingBuilder, "Null mapping");
        ExecutorSpecification result = new ExecutorSpecification();
        result.setTo(new MappingExecutor());
        result.setSourceInfo(mappingBuilder.specificationFile(), null);
        result.setLanguage(MAPPING_LANGUAGE);
        result.setId(mappingBuilder.id());
        result.setCategory(CATEGORY_PREFIX + mappingBuilder.category());
        result.setName(mappingBuilder.name());
        result.setDescription(mappingBuilder.description());
        result.createOptionsIfAbsent().createRoleIfAbsent().setClassName(mappingBuilder.className()).setSettings(true).setResultPort(MAPPING_LANGUAGE);
        this.addInputControls(result, mappingBuilder);
        return result;
    }

    private void addInputControls(ExecutorSpecification result, MappingBuilder mappingBuilder) {
        List<String> enumItems = mappingBuilder.enumItems();
        List<String> enumItemCaptions = mappingBuilder.enumItemCaptions();
        int n = mappingBuilder.numberOfKeys();
        for (int i = 0; i < n; ++i) {
            String key = mappingBuilder.key(i);
            ControlSpecification controlSpecification = mappingBuilder.specification().buildControlSpecification(key, enumItems, enumItemCaptions, this.advancedParameters);
            controlSpecification.setCaption(mappingBuilder.keyCaption(i));
            controlSpecification.setHint("\"" + controlSpecification.getName() + "\" key in the result JSON");
            result.addControl(controlSpecification);
        }
    }

    private SScalar.MultiLineOrJsonSplitter keys(MappingSpecification specification, boolean calledWithObject) throws IOException {
        if (specification.hasKeys()) {
            return SScalar.MultiLineOrJsonSplitter.ofCommentedLines(specification.getKeys().toArray(new String[0]));
        }
        Path file = specification.keysFile();
        if (file == null) {
            file = UseMapping.requireFile(specification, this.customKeysOrEnumItemsFile(this.mappingKeysFile), "keys", calledWithObject ? "Keys file" : null);
        }
        return SScalar.splitJsonOrTrimmedLinesWithComments(MappingBuilder.readNames(file));
    }

    private SScalar.MultiLineOrJsonSplitter enumItems(MappingSpecification specification, boolean calledWithObject) throws IOException {
        if (!specification.isEnum()) {
            return null;
        }
        if (specification.hasEnumItems()) {
            return SScalar.MultiLineOrJsonSplitter.ofCommentedLines(specification.getEnumItems().toArray(new String[0]));
        }
        Path file = specification.enumItemsFile();
        if (file == null) {
            file = UseMapping.requireFile(specification, this.customKeysOrEnumItemsFile(this.mappingEnumItemsFile), "enum items", calledWithObject ? "Enum items file" : null);
        }
        return SScalar.splitJsonOrTrimmedLinesWithComments(MappingBuilder.readNames(file));
    }

    private Path customKeysOrEnumItemsFile(String file) {
        return file == null || (file = file.trim()).isEmpty() ? null : this.completeFilePath(file, false);
    }

    private static Path requireFile(MappingSpecification specification, Path file, String whatFile, String whatParameter) {
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            throw new IllegalStateException("Mapping specification \"" + specification.getName() + "\"" + (String)(specification.getSpecificationFile() == null ? "" : ", loaded from " + String.valueOf(specification.getSpecificationFile()) + ",") + " has no " + whatFile + " file" + (String)(whatParameter == null ? "" : "; in this case the parameter \"" + whatParameter + "\" must contain a correct existing file" + (String)(file == null ? "" : " " + String.valueOf(file.toAbsolutePath()))));
        }
        return file;
    }

    static {
        UseMapping.globalLoaders().register(MAPPING_LOADER);
    }
}

