/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm.js.core;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.executors.api.extensions.ExtensionSpecification;
import net.algart.executors.api.graalvm.GraalPlatforms;
import net.algart.executors.api.graalvm.js.JSCaller;
import net.algart.executors.api.graalvm.js.JSSpecification;
import net.algart.executors.api.graalvm.js.core.InterpretJS;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.common.io.PathPropertyReplacement;

public class UseJS
extends FileOperation {
    public static final String JS_LANGUAGE_NAME = "JavaScript";
    private static final DefaultExecutorLoader<JSCaller> JS_CALLER_LOADER = new DefaultExecutorLoader("JS loader");
    private String workingDirectory = ".";

    public UseJS() {
        this.setDefaultOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public static UseJS getInstance() {
        return new UseJS();
    }

    public static DefaultExecutorLoader<JSCaller> jsCallerLoader() {
        return JS_CALLER_LOADER;
    }

    @Override
    public UseJS setFile(String file) {
        super.setFile(file);
        return this;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public UseJS setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = UseJS.nonEmptyTrimmed(workingDirectory);
        return this;
    }

    @Override
    public void process() {
        try {
            this.useSeveralPaths(this.completeSeveralFilePaths());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void useSeveralPaths(List<Path> jsSpecificationsPaths) throws IOException {
        Objects.requireNonNull(jsSpecificationsPaths, "Null paths to JS specifications files");
        StringBuilder sb = this.isOutputNecessary(DEFAULT_OUTPUT_PORT) ? new StringBuilder() : null;
        for (Path path : jsSpecificationsPaths) {
            this.usePath(path, null, sb);
        }
        if (sb != null) {
            this.getScalar().setTo(sb.toString());
        }
    }

    public void usePath(Path jsSpecificationsPaths) throws IOException {
        this.usePath(jsSpecificationsPaths, null, null);
    }

    public int usePath(Path jsSpecificationsPaths, ExtensionSpecification.Platform platform, StringBuilder report) throws IOException {
        Objects.requireNonNull(jsSpecificationsPaths, "Null path to JS specification files");
        List<JSSpecification> jsSpecifications = Files.isDirectory(jsSpecificationsPaths, new LinkOption[0]) ? JSSpecification.readAllIfValid(jsSpecificationsPaths) : Collections.singletonList(JSSpecification.read(jsSpecificationsPaths));
        ExecutorSpecification.checkIdDifference(jsSpecifications);
        int n = jsSpecifications.size();
        for (int i = 0; i < n; ++i) {
            JSSpecification jsSpecification = jsSpecifications.get(i);
            UseJS.logDebug("Loading JS caller " + (String)(n > 1 ? i + 1 + "/" + n + " " : "") + "from " + String.valueOf(jsSpecification.getSpecificationFile()) + "...");
            if (platform != null) {
                jsSpecification.updateCategoryPrefix(platform.getCategory());
                jsSpecification.addTags(platform.getTags());
                jsSpecification.setPlatformId(platform.getId());
            }
            this.use(jsSpecification);
            if (report == null) continue;
            report.append(jsSpecification.getSpecificationFile()).append("\n");
        }
        return n;
    }

    public void use(JSSpecification jsSpecification) throws IOException {
        String sessionId = this.getSessionId();
        Path workingDirectory = this.translateWorkingDirectory();
        this.correctJSExecutorSpecification(jsSpecification, workingDirectory);
        JSCaller jsCaller = JSCaller.of(jsSpecification, workingDirectory);
        JS_CALLER_LOADER.registerWorker(sessionId, jsSpecification, jsCaller);
    }

    private Path translateWorkingDirectory() {
        return PathPropertyReplacement.translatePropertiesAndCurrentDirectory(this.workingDirectory, this);
    }

    private void correctJSExecutorSpecification(JSSpecification jsSpecification, Path workingDirectory) {
        Objects.requireNonNull(jsSpecification, "Null jsSpecification");
        Objects.requireNonNull(workingDirectory, "Null workingDirectory");
        jsSpecification.setTo(new InterpretJS());
        jsSpecification.addSystemExecutorIdPort();
        if (jsSpecification.hasPlatformId()) {
            jsSpecification.addSystemPlatformIdPort();
        }
        UseJS.addSpecialOutputPorts(jsSpecification);
        jsSpecification.setSourceInfoForSpecification().setLanguageName(JS_LANGUAGE_NAME).setAbsoluteModulePath(workingDirectory.resolve(jsSpecification.getJS().getModule()));
    }

    public static void useAllInstalledInSharedContext() throws IOException {
        UseJS useJS = UseJS.getInstance();
        useJS.setSessionId("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f");
        for (ExtensionSpecification.Platform platform : GraalPlatforms.graalPlatforms().installedPlatforms()) {
            if (!"js".equals(platform.getLanguage()) || !platform.hasSpecifications() || !platform.hasModules()) continue;
            long t1 = System.nanoTime();
            useJS.setWorkingDirectory(platform.modulesFolder().toString());
            int n = useJS.usePath(platform.specificationsFolder(), platform, null);
            long t2 = System.nanoTime();
            UseJS.logInfo(() -> String.format(Locale.US, "Loading %d installed JS specifications from %s: %.3f ms", n, platform.specificationsFolder(), (double)(t2 - t1) * 1.0E-6));
        }
    }

    private static void addSpecialOutputPorts(ExecutorSpecification result) {
    }

    static {
        UseJS.globalLoaders().register(JS_CALLER_LOADER);
    }
}

