/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.graalvm;

import java.awt.image.BufferedImage;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.graalvm.GraalContextCustomizer;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.GraalValues;
import net.algart.graalvm.JSInterpretation;
import net.algart.multimatrix.MultiMatrix;
import org.graalvm.polyglot.Value;

public class GraalAPI {
    public static final String STANDARD_API_ENVIRONMENT_FIELD = "_env";
    public static final String STANDARD_API_EXECUTOR_FIELD = "_executor";
    public static final String STANDARD_API_PARAMETER_EXECUTOR = "executor";
    public static final String STANDARD_API_PARAMETER_PLATFORM = "platform";
    public static final String STANDARD_API_PARAMETER_CONTEXT_PATH = "contextPath";
    public static final String STANDARD_API_PARAMETER_WORKING_DIRECTORY = "workingDirectory";
    public static final String STANDARD_API_CREATE_OBJECT_PROPERTY_NAME = "__SYS_createEmptyObject";
    public static final String STANDARD_API_LOGGER_NAME = "LOGGER";
    public static final String STANDARD_API_SCALAR_CLASS = "SScalarClass";
    public static final String STANDARD_API_NUMBERS_CLASS = "SNumbersClass";
    public static final String STANDARD_API_MAT_CLASS = "SMatClass";
    public static final String ARRAY_BLOCK_LENGTH_PROPERTY_NAME = "blockLength";
    private static final Logger JAVA_LOG = Logger.getLogger(GraalAPI.class.getName());
    private boolean convertInputScalarToNumber = false;
    private boolean convertInputNumbersToArray = false;
    private boolean convertInputArraysToDouble = false;
    private boolean convertOutputIntegersToBriefForm = false;

    private GraalAPI() {
    }

    public static GraalAPI getInstance() {
        return new GraalAPI();
    }

    public static GraalAPI getSmartScriptingInstance() {
        return GraalAPI.getInstance().setConvertInputScalarToNumber(true).setConvertInputNumbersToArray(true).setConvertInputArraysToDouble(true).setConvertOutputIntegersToBriefForm(true);
    }

    public boolean isConvertInputScalarToNumber() {
        return this.convertInputScalarToNumber;
    }

    public GraalAPI setConvertInputScalarToNumber(boolean convertInputScalarToNumber) {
        this.convertInputScalarToNumber = convertInputScalarToNumber;
        return this;
    }

    public boolean isConvertInputNumbersToArray() {
        return this.convertInputNumbersToArray;
    }

    public GraalAPI setConvertInputNumbersToArray(boolean convertInputNumbersToArray) {
        this.convertInputNumbersToArray = convertInputNumbersToArray;
        return this;
    }

    public boolean isConvertInputArraysToDouble() {
        return this.convertInputArraysToDouble;
    }

    public GraalAPI setConvertInputArraysToDouble(boolean convertInputArraysToDouble) {
        this.convertInputArraysToDouble = convertInputArraysToDouble;
        return this;
    }

    public boolean isConvertOutputIntegerToBriefForm() {
        return this.convertOutputIntegersToBriefForm;
    }

    public GraalAPI setConvertOutputIntegersToBriefForm(boolean convertOutputIntegersToBriefForm) {
        this.convertOutputIntegersToBriefForm = convertOutputIntegersToBriefForm;
        return this;
    }

    public void loadSystemParameters(Executor executor, Value parameters, Path workingDirectory) {
        Objects.requireNonNull(executor, "Null executor");
        LinkedHashMap<String, Object> env = new LinkedHashMap<String, Object>();
        env.put(STANDARD_API_PARAMETER_EXECUTOR, executor);
        env.put(STANDARD_API_PARAMETER_PLATFORM, executor.executorPlatform());
        Path directory = workingDirectory != null ? workingDirectory : executor.getCurrentDirectory();
        env.put(STANDARD_API_PARAMETER_WORKING_DIRECTORY, directory == null ? null : directory.toString());
        Path contextPath = executor.contextPath();
        env.put(STANDARD_API_PARAMETER_CONTEXT_PATH, contextPath == null ? null : contextPath.toString());
        parameters.putMember(STANDARD_API_ENVIRONMENT_FIELD, Collections.unmodifiableMap(env));
        parameters.putMember(STANDARD_API_EXECUTOR_FIELD, (Object)executor);
    }

    public void loadParameters(Executor executor, Value parameters) {
        this.loadParameters(executor.parameters(), parameters);
    }

    public void loadParameters(Map<String, Object> parametersMap, Value parameters) {
        Objects.requireNonNull(parametersMap, "Null parametersMap");
        Objects.requireNonNull(parameters, "Null parameters");
        for (Map.Entry<String, Object> entry : parametersMap.entrySet()) {
            parameters.putMember(entry.getKey(), entry.getValue());
        }
    }

    public void readInputPorts(Collection<Port> inputPorts, Value inputs) {
        Objects.requireNonNull(inputPorts, "Null inputPorts");
        Objects.requireNonNull(inputs, "Null inputs");
        for (Port port : inputPorts) {
            inputs.putMember(port.getName(), this.readInputPort(port));
        }
    }

    public void writeOutputPorts(Collection<Port> outputPorts, Value outputs) {
        Objects.requireNonNull(outputPorts, "Null outputPorts");
        Objects.requireNonNull(outputs, "Null outputs");
        for (Port port : outputPorts) {
            this.writeOutputPort(port, outputs.getMember(port.getName()));
        }
    }

    public Object readInputPort(Port port) {
        Objects.requireNonNull(port, "Null port");
        if (!port.isInput()) {
            throw new IllegalArgumentException("Non-input port: " + String.valueOf(port));
        }
        Data data = port.getData();
        Object value = null;
        if (data != null && data.isInitialized()) {
            value = switch (data.type()) {
                default -> throw new MatchException(null, null);
                case DataType.SCALAR -> this.loadScalar(port);
                case DataType.NUMBERS -> this.loadNumbers(port);
                case DataType.MAT -> this.loadMat(port);
            };
        }
        return value;
    }

    public void writeOutputPort(Port port, Value value) {
        this.writeOutputPort(port, value, false);
    }

    public void writeOutputPort(Port port, Value value, boolean preserveExisting) {
        Objects.requireNonNull(port, "Null port");
        if (!port.isOutput()) {
            throw new IllegalArgumentException("Non-output port: " + String.valueOf(port));
        }
        if (preserveExisting && port.hasData()) {
            return;
        }
        DataType dataType = port.getDataType();
        if (value == null || value.isNull()) {
            port.removeData();
        } else if (dataType != null) {
            switch (dataType) {
                case SCALAR: {
                    this.storeScalar(port, value);
                    break;
                }
                case NUMBERS: {
                    this.storeNumbers(port, value);
                    break;
                }
                case MAT: {
                    this.storeMat(port, value);
                }
            }
        }
    }

    public void loadScalar(Value bindings, ExecutionBlock executor, String portName, String defaultValue) {
        bindings.putMember(portName, this.loadScalar(executor, portName, defaultValue));
    }

    public Object loadScalar(ExecutionBlock executor, String portName, String defaultValue) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(portName, "Null portName");
        return this.loadScalar(executor.getRequiredInputPort(portName), defaultValue);
    }

    public Object loadScalar(Port port) {
        return this.loadScalar(port, null);
    }

    public Object loadScalar(Port port, String defaultValue) {
        Objects.requireNonNull(port, "Null port");
        String value = port.getData(SScalar.class, true).getValueOrDefault(defaultValue);
        if (value != null && this.convertInputScalarToNumber) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public void storeScalar(ExecutionBlock executor, String portName, Value value) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(portName, "Null portName");
        this.storeScalar(executor.getRequiredOutputPort(portName), value);
    }

    public void storeScalar(Port port, Value value) {
        Objects.requireNonNull(port, "Null port");
        Objects.requireNonNull(value, "Null value");
        port.getData(SScalar.class, true).setTo(GraalValues.toSmartString(value, this.convertOutputIntegersToBriefForm));
    }

    public void loadNumbers(Value bindings, ExecutionBlock executor, String portName, boolean putNullBindingForUninitialized, String ... alternativeBindingNames) {
        Objects.requireNonNull(bindings, "Null bindings");
        Objects.requireNonNull(alternativeBindingNames, "Null alternativeBindingNames");
        Object data = this.loadNumbers(executor, portName);
        if (putNullBindingForUninitialized || data != null) {
            bindings.putMember(portName, data);
            for (String name : alternativeBindingNames) {
                bindings.putMember(name, data);
            }
        }
    }

    public Object loadNumbers(ExecutionBlock executor, String portName) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(portName, "Null portName");
        return this.loadNumbers(executor.getRequiredInputPort(portName));
    }

    public Object loadNumbers(Port port) {
        Objects.requireNonNull(port, "Null port");
        SNumbers data = port.getData(SNumbers.class, true);
        if (!data.isInitialized()) {
            return null;
        }
        if (!this.convertInputNumbersToArray) {
            return data;
        }
        return this.convertInputArraysToDouble ? data.toDoubleArray() : (double[])data.getArray();
    }

    public void storeNumbers(ExecutionBlock executor, String portName, Value value) {
        this.storeNumbers(executor, portName, value, 1);
    }

    public void storeNumbers(ExecutionBlock executor, String portName, Value value, int defaultBlockLength) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(portName, "Null portName");
        this.storeNumbers(executor.getRequiredOutputPort(portName), value, defaultBlockLength);
    }

    public void storeNumbers(Port port, Value value) {
        this.storeNumbers(port, value, 1);
    }

    public void storeNumbers(Port port, Value value, int defaultBlockLength) {
        Object object;
        Objects.requireNonNull(port, "Null port");
        Objects.requireNonNull(value, "Null value");
        Object object2 = object = value.isNull() ? null : value.as(Object.class);
        if (object == null) {
            port.removeData();
        } else {
            SNumbers resultNumbers = port.getData(SNumbers.class, true);
            if (object instanceof SNumbers) {
                resultNumbers.setTo((SNumbers)object);
            } else if (object instanceof Collection) {
                Value blockLengthValue;
                int blockLength = 1;
                if (value.hasMember(ARRAY_BLOCK_LENGTH_PROPERTY_NAME) && (blockLengthValue = value.getMember(ARRAY_BLOCK_LENGTH_PROPERTY_NAME)).fitsInInt()) {
                    blockLength = blockLengthValue.asInt();
                }
                resultNumbers.setTo((Collection)object, blockLength);
            } else {
                if (!SNumbers.isJavaArraySupported(object)) {
                    throw new IllegalArgumentException("Illegal type for output \"" + port.getName() + "\": JavaScript code must return java-array of primitive types or " + SMat.class.getCanonicalName() + ", but it returned " + object.getClass().getCanonicalName());
                }
                resultNumbers.setToArray(object, defaultBlockLength);
            }
        }
    }

    public void loadMat(Value bindings, ExecutionBlock executor, String portName, boolean putNullBindingForUninitialized, String ... alternativeBindingNames) {
        Objects.requireNonNull(bindings, "Null bindings");
        Objects.requireNonNull(alternativeBindingNames, "Null alternativeBindingNames");
        Object data = this.loadMat(executor, portName);
        if (putNullBindingForUninitialized || data != null) {
            bindings.putMember(portName, data);
            for (String name : alternativeBindingNames) {
                bindings.putMember(name, data);
            }
        }
    }

    public Object loadMat(ExecutionBlock executor, String portName) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(portName, "Null portName");
        return this.loadMat(executor.getRequiredInputPort(portName));
    }

    public Object loadMat(Port port) {
        Objects.requireNonNull(port, "Null port");
        SMat data = port.getData(SMat.class, true);
        if (!data.isInitialized()) {
            return null;
        }
        return data;
    }

    public void storeMat(ExecutionBlock executor, String portName, Value value) {
        Objects.requireNonNull(executor, "Null executor");
        Objects.requireNonNull(portName, "Null portName");
        this.storeMat(executor.getRequiredOutputPort(portName), value);
    }

    public void storeMat(Port port, Value value) {
        Object object;
        Objects.requireNonNull(port, "Null port");
        Objects.requireNonNull(value, "Null value");
        Object object2 = object = value.isNull() ? null : value.as(Object.class);
        if (object == null) {
            port.removeData();
        } else {
            SMat resultMat = port.getData(SMat.class, true);
            Object object3 = object;
            Objects.requireNonNull(object3);
            Object object4 = object3;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SMat.class, BufferedImage.class, MultiMatrix.class}, (Object)object4, n)) {
                case 0: {
                    SMat mat = (SMat)object4;
                    resultMat.setTo(mat);
                    break;
                }
                case 1: {
                    BufferedImage bufferedImage = (BufferedImage)object4;
                    resultMat.setTo(bufferedImage);
                    break;
                }
                case 2: {
                    MultiMatrix multiMatrix = (MultiMatrix)object4;
                    resultMat.setTo(multiMatrix);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal type for of output \"" + port.getName() + "\": JavaScript code must return " + SMat.class.getCanonicalName() + ", " + BufferedImage.class.getCanonicalName() + " or " + MultiMatrix.class.getCanonicalName() + ", but it returned " + object.getClass().getCanonicalName());
                }
            }
        }
    }

    public static class JS {
        private static final String STANDARD_API_JS_SERVICE_SOURCE_PURE = "export function __SYS_createEmptyObjectImpl() {\n    return new Object()\n}\n\n// for the case jsEsmEvalReturnsExports=false:\n[__SYS_createEmptyObjectImpl]\n";
        private static final GraalSourceContainer STANDARD_API_JS_SERVICE_SOURCE_CONTAINER_PURE = GraalSourceContainer.newLiteralContainer().setModuleJS("export function __SYS_createEmptyObjectImpl() {\n    return new Object()\n}\n\n// for the case jsEsmEvalReturnsExports=false:\n[__SYS_createEmptyObjectImpl]\n", "__S_service_pure");
        private static final String STANDARD_API_JS_SERVICE_SOURCE = "export function __SYS_createEmptyObjectImpl() {\n    return new Object()\n}\nconst __SYS_ScalarClass = Java.type(\"%s\");\nconst __SYS_NumbersClass = Java.type(\"%s\");\nconst __SYS_MatClass = Java.type(\"%s\");\n\n// for the case jsEsmEvalReturnsExports=true:\nexport { __SYS_ScalarClass, __SYS_NumbersClass, __SYS_MatClass }\n// for the case jsEsmEvalReturnsExports=false:\n[__SYS_createEmptyObjectImpl, __SYS_ScalarClass, __SYS_NumbersClass, __SYS_MatClass]\n".formatted(SScalar.class.getCanonicalName(), SNumbers.class.getCanonicalName(), SMat.class.getCanonicalName());
        private static final GraalSourceContainer STANDARD_API_JS_SERVICE_SOURCE_CONTAINER = GraalSourceContainer.newLiteralContainer().setModuleJS(STANDARD_API_JS_SERVICE_SOURCE, "__S_service");

        public static GraalPerformerContainer getJSContainer(boolean shared) {
            return JS.initializeJS(GraalPerformerContainer.getContainer(shared).setAutoBindingJS());
        }

        public static GraalPerformerContainer getJSContainer(boolean shared, GraalContextCustomizer customizer) {
            return JS.initializeJS(GraalPerformerContainer.getContainer(shared, customizer).setAutoBindingJS());
        }

        public static GraalPerformerContainer initializeJS(GraalPerformerContainer performerContainer) {
            Objects.requireNonNull(performerContainer, "Null performerContainer");
            boolean addStandardClasses = performerContainer.getCustomizer().isJavaAccessSupported();
            performerContainer.setConfigurator(performer -> JS.standardConfigure(performer, addStandardClasses));
            return performerContainer;
        }

        public static GraalPerformerContainer.Local initializeJS(GraalPerformerContainer.Local performerContainer) {
            return (GraalPerformerContainer.Local)JS.initializeJS((GraalPerformerContainer)performerContainer);
        }

        public static GraalPerformerContainer.Shared initializeJS(GraalPerformerContainer.Shared performerContainer) {
            return (GraalPerformerContainer.Shared)JS.initializeJS((GraalPerformerContainer)performerContainer);
        }

        public static Value storedCreateEmptyObjectFunction(GraalPerformer performer) {
            Objects.requireNonNull(performer, "Null performer");
            Value result = performer.getProperty(GraalAPI.STANDARD_API_CREATE_OBJECT_PROPERTY_NAME, Value.class);
            if (result == null) {
                throw new IllegalStateException("Performer is not configured properly: " + String.valueOf(performer));
            }
            return result;
        }

        public static void standardConfigure(GraalPerformer performer, boolean addStandardClasses) {
            Objects.requireNonNull(performer, "Null performer");
            Value m = performer.perform(addStandardClasses ? STANDARD_API_JS_SERVICE_SOURCE_CONTAINER : STANDARD_API_JS_SERVICE_SOURCE_CONTAINER_PURE);
            Value bindings = performer.bindingsJS();
            Value createEmptyObjectFunction = JS.sysExport(m, "__SYS_createEmptyObjectImpl", 0);
            performer.putPropertyIfAbsent(GraalAPI.STANDARD_API_CREATE_OBJECT_PROPERTY_NAME, createEmptyObjectFunction);
            if (addStandardClasses) {
                bindings.putMember(GraalAPI.STANDARD_API_SCALAR_CLASS, (Object)JS.sysExport(m, "__SYS_ScalarClass", 1));
                bindings.putMember(GraalAPI.STANDARD_API_NUMBERS_CLASS, (Object)JS.sysExport(m, "__SYS_NumbersClass", 2));
                bindings.putMember(GraalAPI.STANDARD_API_MAT_CLASS, (Object)JS.sysExport(m, "__SYS_MatClass", 3));
            }
            bindings.putMember(GraalAPI.STANDARD_API_LOGGER_NAME, (Object)JAVA_LOG);
        }

        private static Value sysExport(Value m, String name, int index) {
            return JSInterpretation.smartModuleMember(m, name, () -> m.getArrayElement((long)index));
        }
    }
}

