/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.external.UsedForExternalCommunication;
import net.algart.json.Jsons;

public final class SScalar
extends Data {
    private String value = null;

    @UsedForExternalCommunication
    public SScalar() {
    }

    public SScalar(String value) {
        this.setValue(value);
    }

    @UsedForExternalCommunication
    public String getValue() {
        return this.value;
    }

    public String getValueOrDefault(String defaultValue) {
        return this.isInitialized() ? this.value : defaultValue;
    }

    public SScalar setTo(SScalar scalar) {
        Objects.requireNonNull(scalar, "Null scalar");
        this.value = scalar.value;
        this.flags = scalar.flags;
        this.setInitialized(scalar.isInitialized());
        return this;
    }

    public SScalar setTo(String value) {
        this.setValue(value);
        return this;
    }

    public SScalar setTo(boolean value) {
        this.setValue(String.valueOf(value));
        return this;
    }

    public SScalar setTo(int value) {
        this.setValue(String.valueOf(value));
        return this;
    }

    public SScalar setTo(long value) {
        this.setValue(String.valueOf(value));
        return this;
    }

    public SScalar setTo(double value) {
        if (value == (double)((long)value)) {
            this.setTo((long)value);
        } else {
            this.setValue(String.valueOf(value));
        }
        return this;
    }

    public SScalar setTo(int[] values) {
        return this.setTo(values, 0);
    }

    public SScalar setTo(int[] values, int blockLength) {
        Objects.requireNonNull(values, "Null values array");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(blockLength > 0 && i % blockLength == 0 ? "\n" : ", ");
            }
            sb.append(values[i]);
        }
        this.setValue(sb.toString());
        return this;
    }

    public SScalar setTo(long[] values) {
        return this.setTo(values, 0);
    }

    public SScalar setTo(long[] values, int blockLength) {
        Objects.requireNonNull(values, "Null values array");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(blockLength > 0 && i % blockLength == 0 ? "\n" : ", ");
            }
            sb.append(values[i]);
        }
        this.setValue(sb.toString());
        return this;
    }

    public SScalar setTo(float[] values) {
        return this.setTo(values, 0);
    }

    public SScalar setTo(float[] values, int blockLength) {
        Objects.requireNonNull(values, "Null values array");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(blockLength > 0 && i % blockLength == 0 ? "\n" : ", ");
            }
            sb.append(values[i]);
        }
        this.setValue(sb.toString());
        return this;
    }

    public SScalar setTo(double[] values) {
        return this.setTo(values, 0);
    }

    public SScalar setTo(double[] values, int blockLength) {
        Objects.requireNonNull(values, "Null values array");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(blockLength > 0 && i % blockLength == 0 ? "\n" : ", ");
            }
            sb.append(values[i]);
        }
        this.setValue(sb.toString());
        return this;
    }

    public SScalar setTo(Collection<?> values) {
        Objects.requireNonNull(values, "Null values collection");
        String delimiter = String.format("%n", new Object[0]);
        this.setValue(values.stream().map(String::valueOf).collect(Collectors.joining(delimiter)));
        return this;
    }

    public SScalar setTo(Optional<?> optional) {
        Objects.requireNonNull(optional, "Null optional value");
        if (optional.isEmpty()) {
            this.setToNull();
        } else {
            Object subValue = optional.get();
            this.setTo(subValue);
        }
        return this;
    }

    public SScalar setToNull() {
        this.setValue(null);
        return this;
    }

    public SScalar setTo(Object value) {
        if (value == null) {
            this.setToNull();
        } else if (value instanceof Data) {
            Data data = (Data)value;
            this.setTo(data);
        } else if (value instanceof int[]) {
            int[] v = (int[])value;
            this.setTo(v);
        } else if (value instanceof long[]) {
            long[] v = (long[])value;
            this.setTo(v);
        } else if (value instanceof float[]) {
            float[] v = (float[])value;
            this.setTo(v);
        } else if (value instanceof double[]) {
            double[] v = (double[])value;
            this.setTo(v);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            this.setTo(collection);
        } else if (value instanceof Optional) {
            Optional optional = (Optional)value;
            this.setTo(optional);
        } else {
            this.setValue(String.valueOf(value));
        }
        return this;
    }

    @Override
    public DataType type() {
        return DataType.SCALAR;
    }

    @Override
    public void setTo(Data other, boolean cloneData) {
        if (!(other instanceof SScalar)) {
            throw new IllegalArgumentException("Cannot assign " + String.valueOf(other.getClass()) + " to " + String.valueOf(this.getClass()));
        }
        this.setTo((SScalar)other);
    }

    @Override
    public SScalar exchange(Data other) {
        Objects.requireNonNull(other, "Null other objects");
        if (!(other instanceof SScalar)) {
            throw new IllegalArgumentException("Cannot exchange with another data type: " + String.valueOf(other.getClass()));
        }
        SScalar otherScalar = (SScalar)other;
        long tempFlags = this.flags;
        String tempValue = this.value;
        this.flags = otherScalar.flags;
        this.value = otherScalar.value;
        otherScalar.flags = tempFlags;
        otherScalar.value = tempValue;
        return this;
    }

    public boolean toJavaLikeBoolean() {
        if (this.value == null) {
            throw new IllegalStateException("Non-initialized scalar cannot be converted to boolean");
        }
        return SScalar.toJavaLikeBoolean(this.value);
    }

    public boolean toJavaLikeBoolean(boolean defaultValue) {
        return this.value != null ? SScalar.toJavaLikeBoolean(this.value) : defaultValue;
    }

    public boolean toCLikeBoolean() {
        if (this.value == null) {
            throw new IllegalStateException("Non-initialized scalar cannot be converted to boolean");
        }
        return SScalar.toCLikeBoolean(this.value);
    }

    public boolean toCLikeBoolean(boolean defaultValue) {
        return this.value != null ? SScalar.toCLikeBoolean(this.value) : defaultValue;
    }

    public boolean toCommonBoolean() {
        if (this.value == null) {
            throw new IllegalStateException("Non-initialized scalar cannot be converted to boolean");
        }
        return SScalar.toCommonBoolean(this.value);
    }

    public boolean toCommonBoolean(boolean defaultValue) {
        return SScalar.toCommonBoolean(this.value, defaultValue);
    }

    public int toInt() {
        if (this.value == null) {
            throw new NumberFormatException("Non-initialized scalar cannot be converted to int");
        }
        long value = Math.round(Double.parseDouble(this.value));
        if (value != (long)((int)value)) {
            throw new NumberFormatException("Scalar contain too large value for 32-bit int type: " + Double.parseDouble(this.value));
        }
        return (int)value;
    }

    public Integer toIntOrNull() {
        return this.value == null ? null : Integer.valueOf(this.toInt());
    }

    public int toIntOrDefault(int defaultValue) {
        return this.value == null ? defaultValue : this.toInt();
    }

    public long toLong() {
        if (this.value == null) {
            throw new NumberFormatException("Non-initialized scalar cannot be converted to long");
        }
        return Long.parseLong(this.value);
    }

    public Long toLongOrNull() {
        return this.value == null ? null : Long.valueOf(this.toLong());
    }

    public long toLongOrDefault(long defaultValue) {
        return this.value == null ? defaultValue : this.toLong();
    }

    public double toDouble() {
        if (this.value == null) {
            throw new NumberFormatException("Non-initialized scalar cannot be converted to double");
        }
        return Double.parseDouble(this.value);
    }

    public Double toDoubleOrNull() {
        return this.value == null ? null : Double.valueOf(this.toDouble());
    }

    public double toDoubleOrDefault(double defaultValue) {
        return this.value == null ? defaultValue : this.toDouble();
    }

    public int[] toInts() throws NumberFormatException {
        return this.toInts(0);
    }

    public int[] toInts(int minRequiredNumberOfDoubles) throws NumberFormatException, IllegalStateException {
        if (this.value == null) {
            throw new NumberFormatException("Non-initialized scalar cannot be converted to int[]");
        }
        String trimmed = this.value.trim();
        if (trimmed.isEmpty()) {
            return new int[0];
        }
        int[] result = Stream.of(trimmed.split("[,;\\s]+")).map(String::trim).mapToInt(Integer::parseInt).toArray();
        if (result.length < minRequiredNumberOfDoubles) {
            throw new IllegalStateException("Too little values in the scalar: only " + result.length + " when " + minRequiredNumberOfDoubles + " are required");
        }
        return result;
    }

    public long[] toLongs() throws NumberFormatException {
        return this.toLongs(0);
    }

    public long[] toLongs(int minRequiredNumberOfDoubles) throws NumberFormatException, IllegalStateException {
        if (this.value == null) {
            throw new NumberFormatException("Non-initialized scalar cannot be converted to long[]");
        }
        String trimmed = this.value.trim();
        if (trimmed.isEmpty()) {
            return new long[0];
        }
        long[] result = Stream.of(trimmed.split("[,;\\s]+")).map(String::trim).mapToLong(Long::parseLong).toArray();
        if (result.length < minRequiredNumberOfDoubles) {
            throw new IllegalStateException("Too little values in the scalar: only " + result.length + " when " + minRequiredNumberOfDoubles + " are required");
        }
        return result;
    }

    public double[] toDoubles() throws NumberFormatException {
        return this.toDoubles(0);
    }

    public double[] toDoubles(int minRequiredNumberOfDoubles) throws NumberFormatException, IllegalStateException {
        if (this.value == null) {
            throw new NumberFormatException("Non-initialized scalar cannot be converted to double[]");
        }
        String trimmed = this.value.trim();
        if (trimmed.isEmpty()) {
            return new double[0];
        }
        double[] result = Stream.of(trimmed.split("[,;\\s]+")).map(String::trim).mapToDouble(Double::parseDouble).toArray();
        if (result.length < minRequiredNumberOfDoubles) {
            throw new IllegalStateException("Too little values in the scalar: only " + result.length + " when " + minRequiredNumberOfDoubles + " are required");
        }
        return result;
    }

    public String[] toTrimmedLinesArray() {
        return this.value == null ? null : SScalar.splitJsonOrTrimmedLinesArray(this.value);
    }

    public List<String> toTrimmedLines() {
        return this.value == null ? null : SScalar.splitJsonOrTrimmedLines(this.value);
    }

    public String[] toTrimmedLinesWithoutCommentsArray() {
        return this.value == null ? null : SScalar.splitJsonOrTrimmedLinesWithoutCommentsArray(this.value);
    }

    public List<String> toTrimmedLinesWithoutComments() {
        return this.value == null ? null : SScalar.splitJsonOrTrimmedLinesWithoutComments(this.value);
    }

    public MultiLineOrJsonSplitter toTrimmedLinesWithComments() {
        return this.value == null ? null : SScalar.splitJsonOrTrimmedLinesWithComments(this.value);
    }

    @Override
    public String toString() {
        if (!this.isInitialized()) {
            return super.toString();
        }
        assert (this.value != null) : "null initialized value";
        int len = Math.min(this.value.length(), 128);
        for (int p = 0; p < len; ++p) {
            char c = this.value.charAt(p);
            if (c != '\r' && c != '\n') continue;
            return this.value.substring(0, p) + "...";
        }
        return this.value.length() > len ? this.value.substring(0, 128) + "..." : this.value;
    }

    public static SScalar empty() {
        return new SScalar();
    }

    public static SScalar of(Object value) {
        return new SScalar().setTo(value);
    }

    public static void setTo(Map<String, SScalar> scalars, String key, Supplier<?> supplier) {
        SScalar scalar = scalars.get(key);
        if (scalar != null) {
            scalar.setTo(supplier.get());
        }
    }

    public static String[] splitJsonOrTrimmedLinesArray(String multiLines) {
        return new MultiLineOrJsonSplitter((String)multiLines).lines;
    }

    public static List<String> splitJsonOrTrimmedLines(String multiLines) {
        return new MultiLineOrJsonSplitter(multiLines).lines();
    }

    public static String[] splitJsonOrTrimmedLinesWithoutCommentsArray(String multiLines) {
        return new MultiLineOrJsonSplitter((String)multiLines).extractComments((boolean)true).lines;
    }

    public static List<String> splitJsonOrTrimmedLinesWithoutComments(String multiLines) {
        return new MultiLineOrJsonSplitter(multiLines).extractComments(true).lines();
    }

    public static MultiLineOrJsonSplitter splitJsonOrTrimmedLinesWithComments(String multiLines) {
        return new MultiLineOrJsonSplitter(multiLines).extractComments(false);
    }

    public static boolean toJavaLikeBoolean(String scalar) {
        Objects.requireNonNull(scalar, "Null scalar value");
        return Boolean.parseBoolean(scalar);
    }

    public static boolean toCLikeBoolean(String scalar) {
        Objects.requireNonNull(scalar, "Null scalar value");
        return SScalar.doubleToBoolean(scalar);
    }

    public static boolean toCommonBoolean(String scalar) {
        Objects.requireNonNull(scalar, "Null scalar value");
        return !scalar.equalsIgnoreCase("false") && SScalar.doubleToBoolean(scalar);
    }

    public static boolean toCommonBoolean(String scalar, boolean defaultValue) {
        return scalar == null ? defaultValue : SScalar.toCommonBoolean(scalar);
    }

    @Override
    protected void freeResources() {
        this.value = null;
    }

    @UsedForExternalCommunication
    private void setValue(String value) {
        this.value = value;
        this.setInitializedAndResetFlags(value != null);
    }

    private static boolean doubleToBoolean(String scalar) {
        if (scalar.isEmpty()) {
            return false;
        }
        try {
            return Double.parseDouble(scalar) != 0.0;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static class MultiLineOrJsonSplitter {
        private final String[] lines;
        private final boolean[] nonString;
        String[] comments = null;

        private MultiLineOrJsonSplitter(String multiLines) {
            JsonArray jsonArray;
            Objects.requireNonNull(multiLines, "Null multi-line string");
            multiLines = multiLines.trim();
            try {
                jsonArray = Jsons.toJsonArray(multiLines);
            }
            catch (JsonException e) {
                jsonArray = null;
            }
            if (jsonArray == null) {
                this.lines = multiLines.isEmpty() ? new String[]{} : multiLines.split("(?:\\r(?!\\n)|\\n|\\r\\n)");
                this.nonString = null;
            } else {
                this.lines = new String[jsonArray.size()];
                this.nonString = new boolean[this.lines.length];
                int k = 0;
                for (JsonValue jsonValue : jsonArray) {
                    this.nonString[k] = jsonValue.getValueType() != JsonValue.ValueType.STRING;
                    this.lines[k] = Jsons.toPrettyString(jsonValue);
                    ++k;
                }
            }
            for (int k = 0; k < this.lines.length; ++k) {
                this.lines[k] = this.lines[k].trim();
            }
        }

        private MultiLineOrJsonSplitter extractComments(boolean removeComments) {
            if (!removeComments) {
                this.comments = new String[this.lines.length];
            }
            for (int k = 0; k < this.lines.length; ++k) {
                int p;
                String s = this.lines[k];
                int n = p = this.nonString != null && this.nonString[k] ? -1 : s.indexOf("//");
                if (p == -1) continue;
                this.lines[k] = s.substring(0, p).trim();
                if (removeComments) continue;
                this.comments[k] = s.substring(p + 2).trim();
            }
            return this;
        }

        private MultiLineOrJsonSplitter(String[] lines) {
            this.lines = (String[])Objects.requireNonNull(lines, "Null lines").clone();
            this.comments = new String[lines.length];
            this.nonString = null;
        }

        private MultiLineOrJsonSplitter(String[] lines, String[] comments) {
            this.lines = (String[])Objects.requireNonNull(lines, "Null lines").clone();
            this.comments = (String[])Objects.requireNonNull(comments, "Null comments").clone();
            this.nonString = null;
        }

        public static MultiLineOrJsonSplitter ofSimpleLines(String[] lines) {
            return new MultiLineOrJsonSplitter(lines);
        }

        public static MultiLineOrJsonSplitter ofLinesAndComments(String[] lines, String[] comments) {
            return new MultiLineOrJsonSplitter(lines, comments);
        }

        public static MultiLineOrJsonSplitter ofCommentedLines(String[] linesWithComments) {
            return new MultiLineOrJsonSplitter(linesWithComments).extractComments(false);
        }

        public int numberOfLines() {
            return this.lines.length;
        }

        public String[] linesArray() {
            return (String[])this.lines.clone();
        }

        public List<String> lines() {
            return Collections.unmodifiableList(Arrays.asList(this.lines));
        }

        public String[] commentsArray() {
            assert (this.comments != null) : "comments cannot be null outside this class";
            return (String[])this.comments.clone();
        }

        public List<String> comments() {
            assert (this.comments != null) : "comments cannot be null outside this class";
            return Collections.unmodifiableList(Arrays.asList(this.comments));
        }

        public String toString() {
            return "MultiLineOrJsonSplitter: lines=" + Arrays.toString(this.lines) + ", nonString=" + Arrays.toString(this.nonString) + ", comments=" + Arrays.toString(this.comments);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiLineOrJsonSplitter that = (MultiLineOrJsonSplitter)o;
            return Arrays.equals(this.lines, that.lines) && Arrays.equals(this.comments, that.comments);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.lines);
            result = 31 * result + Arrays.hashCode(this.comments);
            return result;
        }
    }
}

