/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.data;

import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArraysPer8;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.data.ConvertibleByteBufferMatrix;
import net.algart.executors.api.data.ConvertibleMultiMatrix;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.external.UsedForExternalCommunication;
import net.algart.io.awt.ImageToMatrix;
import net.algart.io.awt.MatrixToImage;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SMat
extends Data {
    static final int MAX_NUMBER_OF_CHANNELS = 512;
    private static final boolean OPTIMIZE_COPYING = true;
    private static final Depth[] CODE_TO_DEPTH = new Depth[512];
    private boolean allowed63BitDimensions = false;
    private long[] dimensions = new long[2];
    private Depth depth;
    private int numberOfChannels;
    private Convertible pointer;

    @UsedForExternalCommunication
    public SMat() {
    }

    public boolean isAllowed63BitDimensions() {
        return this.allowed63BitDimensions;
    }

    @UsedForExternalCommunication
    public SMat setAllowed63BitDimensions(boolean allowed63BitDimensions) {
        this.allowed63BitDimensions = allowed63BitDimensions;
        return this;
    }

    @UsedForExternalCommunication
    public long[] getDimensions() {
        return (long[])this.dimensions.clone();
    }

    @UsedForExternalCommunication
    public int getDimCount() {
        return this.dimensions.length;
    }

    @UsedForExternalCommunication
    public long getDim(int k) {
        return k < this.dimensions.length ? this.dimensions[k] : 1L;
    }

    @UsedForExternalCommunication
    public long getDimX() {
        return this.dimensions[0];
    }

    @UsedForExternalCommunication
    public long getDimY() {
        if (this.dimensions.length <= 1) {
            return 1L;
        }
        return this.dimensions[1];
    }

    public Depth getDepth() {
        return this.depth;
    }

    @UsedForExternalCommunication
    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    @UsedForExternalCommunication
    public int getDepthCode() {
        return this.depth.code;
    }

    public Convertible getPointer() {
        return this.pointer;
    }

    @UsedForExternalCommunication
    public ByteBuffer getByteBuffer() {
        return this.pointer.getCachedByteBuffer(this);
    }

    public byte[] getByteArray() {
        ByteBuffer bb = this.getByteBuffer();
        if (bb == null) {
            return null;
        }
        byte[] result = new byte[bb.remaining()];
        bb.get(result);
        return result;
    }

    public Buffer getBuffer() {
        return this.depth.asBuffer(this.getByteBuffer());
    }

    public SMat setAll(long[] dimensions, Depth depth, int numberOfChannels, Convertible pointer) {
        Objects.requireNonNull(depth, "Null depth");
        SMat.checkNumberOfChannels(numberOfChannels);
        Objects.requireNonNull(pointer, "Null pointer");
        this.setDimensions(dimensions);
        this.depth = depth;
        this.numberOfChannels = numberOfChannels;
        this.pointer = pointer;
        this.setInitializedAndResetFlags(true);
        return this;
    }

    public SMat setAll(long[] dimensions, Depth depth, int numberOfChannels, ByteBuffer byteBuffer, boolean cloneByteBuffer) {
        return this.setAll(dimensions, depth, numberOfChannels, new ConvertibleByteBufferMatrix(cloneByteBuffer ? SMat.cloneByteBuffer(byteBuffer) : byteBuffer));
    }

    public SMat setAll(long[] dimensions, Depth depth, int numberOfChannels, byte[] byteArray) {
        Objects.requireNonNull(byteArray, "Null byteArray");
        return this.setAll(dimensions, depth, numberOfChannels, ByteBuffer.wrap(byteArray), true);
    }

    public SMat setAll2D(long dimX, long dimY, Depth depth, int numberOfChannels, byte[] byteArray) {
        return this.setAll(new long[]{dimX, dimY}, depth, numberOfChannels, ByteBuffer.wrap(byteArray), true);
    }

    public SMat setAll2DBytes(long dimX, long dimY, int numberOfChannels, byte[] byteArray) {
        return this.setAll2D(dimX, dimY, Depth.U8, numberOfChannels, byteArray);
    }

    public SMat fill2DBytes(long dimX, long dimY, int numberOfChannels, int ... channelValues) {
        int i;
        SMat.checkNumberOfChannels(numberOfChannels);
        SMat.checkDimensions(new long[]{dimX, dimY, numberOfChannels}, false);
        Objects.requireNonNull(channelValues, "Null channelValues");
        byte[] byteArray = new byte[(int)(dimX * dimY * (long)numberOfChannels)];
        byte[] channels = new byte[numberOfChannels];
        boolean allEqual = true;
        for (i = 0; i < numberOfChannels; ++i) {
            byte by = channels[i] = i < channelValues.length ? (byte)channelValues[i] : (byte)0;
            if (channels[i] == channels[0]) continue;
            allEqual = false;
        }
        if (allEqual) {
            Arrays.fill(byteArray, channels[0]);
        } else {
            for (i = 0; i < byteArray.length; i += numberOfChannels) {
                System.arraycopy(channels, 0, byteArray, i, numberOfChannels);
            }
        }
        return this.setAll2D(dimX, dimY, Depth.U8, numberOfChannels, byteArray);
    }

    public boolean isChannelsOrderCompatibleWithMultiMatrix() {
        return this.numberOfChannels != 3 && this.numberOfChannels != 4;
    }

    public SMat setTo(SMat mat) {
        return this.setTo(mat, true);
    }

    public SMat setTo(SMat mat, boolean cloneData) {
        Objects.requireNonNull(mat, "Null mat");
        this.flags = mat.flags;
        this.setInitialized(mat.isInitialized());
        this.dimensions = (long[])mat.dimensions.clone();
        this.depth = mat.depth;
        this.numberOfChannels = mat.numberOfChannels;
        this.pointer = mat.pointer != null && cloneData ? mat.pointer.copy() : mat.pointer;
        return this;
    }

    public SMat setTo(BufferedImage bufferedImage) {
        Matrix interleaved = new ImageToMatrix.ToInterleavedBGR().toMatrix(bufferedImage);
        return this.setToInterleavedBGR((Matrix<? extends PArray>)interleaved);
    }

    public SMat setTo(MultiMatrix multiMatrix) {
        return this.setTo(multiMatrix, ChannelOrder.STANDARD);
    }

    public SMat setTo(MultiMatrix multiMatrix, ChannelOrder channelOrder) {
        Objects.requireNonNull(multiMatrix, "Null multi-matrix");
        Objects.requireNonNull(channelOrder, "Null channelOrder");
        if (channelOrder == ChannelOrder.STANDARD) {
            this.setNumberOfChannels(multiMatrix.numberOfChannels());
            this.setDimensions(multiMatrix.dimensions());
            this.setDepth(Depth.of(multiMatrix.elementType()));
            this.setPointer(new ConvertibleMultiMatrix(multiMatrix));
            this.setInitializedAndResetFlags(true);
            return this;
        }
        Matrix interleave = Matrices.interleave((ArrayContext)ArrayContext.getSimpleContext((MemoryModel)BufferMemoryModel.getInstance(), (boolean)false), channelOrder == ChannelOrder.ORDER_IN_PACKED_BYTE_BUFFER ? multiMatrix.allChannels() : multiMatrix.allChannelsInBGRAOrder());
        return this.setToInterleavedBGR((Matrix<? extends PArray>)interleave);
    }

    public SMat setToInterleavedBGR(Matrix<? extends PArray> interleavedBGRMatrix) {
        Objects.requireNonNull(interleavedBGRMatrix, "Null BGR[A] matrix");
        int dimCount = interleavedBGRMatrix.dimCount();
        if (dimCount < 2) {
            throw new IllegalArgumentException("Interleaved BGR[A] matrix cannot be 1-dimensional: " + String.valueOf(interleavedBGRMatrix) + " (the 1st dimension is used to store channels)");
        }
        long numberOfChannels = interleavedBGRMatrix.dim(0);
        if (numberOfChannels > 512L) {
            throw new IllegalArgumentException("Number of channels cannot be >512: " + String.valueOf(interleavedBGRMatrix));
        }
        Array array = interleavedBGRMatrix.array();
        if (!BufferMemoryModel.isBufferArray((Array)array) || BufferMemoryModel.getBufferOffset((Array)array) != 0L) {
            array = array.updatableClone((MemoryModel)BufferMemoryModel.getInstance());
        }
        assert (BufferMemoryModel.isBufferArray((Array)array));
        this.setNumberOfChannels((int)numberOfChannels);
        this.setDimensions(SMat.removeFirstElement(interleavedBGRMatrix.dimensions()));
        this.setDepth(Depth.of(interleavedBGRMatrix.elementType()));
        this.setByteBuffer(BufferMemoryModel.getByteBuffer((Array)array));
        this.setInitializedAndResetFlags(true);
        return this;
    }

    @Override
    public void setTo(Data other, boolean cloneData) {
        if (!(other instanceof SMat)) {
            throw new IllegalArgumentException("Cannot assign " + String.valueOf(other.getClass()) + " to " + String.valueOf(this.getClass()));
        }
        this.setTo((SMat)other, cloneData);
    }

    @Override
    public SMat exchange(Data other) {
        Objects.requireNonNull(other, "Null other objects");
        if (!(other instanceof SMat)) {
            throw new IllegalArgumentException("Cannot exchange with another data type: " + String.valueOf(other.getClass()));
        }
        SMat otherMat = (SMat)other;
        long tempFlags = this.flags;
        long[] tempDimensions = this.dimensions;
        Depth tempDepth = this.depth;
        int tempNumberOfChannels = this.numberOfChannels;
        Convertible tempPointer = this.pointer;
        this.flags = otherMat.flags;
        this.dimensions = otherMat.dimensions;
        this.depth = otherMat.depth;
        this.numberOfChannels = otherMat.numberOfChannels;
        this.pointer = otherMat.pointer;
        otherMat.flags = tempFlags;
        otherMat.dimensions = tempDimensions;
        otherMat.depth = tempDepth;
        otherMat.numberOfChannels = tempNumberOfChannels;
        otherMat.pointer = tempPointer;
        return this;
    }

    @Override
    public void serializeMemory() {
        if (this.isInitialized()) {
            this.pointer = this.pointer.copyToMemoryAndDisposePrevious();
        }
    }

    public BufferedImage toBufferedImage() {
        return this.toBufferedImage(true);
    }

    public BufferedImage toBufferedImage(boolean convertAllElementTypesToByte) {
        if (!this.isInitialized()) {
            return null;
        }
        Matrix<? extends PArray> interleaved = this.toInterleavedBGR2D(false);
        if (interleaved == null) {
            return null;
        }
        return new MatrixToImage.InterleavedBGRToInterleaved().setBytesRequired(convertAllElementTypesToByte).toBufferedImage(interleaved);
    }

    public MultiMatrix2D toMultiMatrix2D() {
        return this.toMultiMatrix2D(false);
    }

    public MultiMatrix2D toMultiMatrix2D(ChannelOrder channelOrder) {
        return this.toMultiMatrix2D(false, channelOrder);
    }

    public MultiMatrix2D toMultiMatrix2D(boolean autoConvertUnsupportedDepth) {
        return this.toMultiMatrix2D(autoConvertUnsupportedDepth, ChannelOrder.STANDARD);
    }

    public MultiMatrix2D toMultiMatrix2D(boolean autoConvertUnsupportedDepth, ChannelOrder channelOrder) {
        MultiMatrix result = this.toMultiMatrix(autoConvertUnsupportedDepth, channelOrder);
        return result == null ? null : result.asMultiMatrix2D();
    }

    public MultiMatrix toMultiMatrix() {
        return this.toMultiMatrix(false);
    }

    public MultiMatrix toMultiMatrix(ChannelOrder channelOrder) {
        return this.toMultiMatrix(false, channelOrder);
    }

    public MultiMatrix toMultiMatrix(boolean autoConvertUnsupportedDepth) {
        return this.toMultiMatrix(autoConvertUnsupportedDepth, ChannelOrder.STANDARD);
    }

    public MultiMatrix toMultiMatrix(boolean autoConvertUnsupportedDepth, ChannelOrder channelOrder) {
        Objects.requireNonNull(channelOrder, "Null channelOrder");
        if (!this.isInitialized()) {
            return null;
        }
        return this.pointer.getCachedMultiMatrix(this, autoConvertUnsupportedDepth, channelOrder);
    }

    public Matrix<? extends PArray> toInterleavedBGR(boolean autoConvertUnsupportedDepth) {
        return this.toInterleavedBGR(autoConvertUnsupportedDepth, false);
    }

    public Matrix<? extends PArray> toInterleavedBGR2D(boolean autoConvertUnsupportedDepth) {
        return this.toInterleavedBGR(autoConvertUnsupportedDepth, true);
    }

    public SMat autoContrast() {
        if (this.depth == Depth.BIT || this.numberOfChannels == 2 || this.numberOfChannels > 4) {
            return this;
        }
        MultiMatrix matrix = this.toMultiMatrix(true);
        return matrix == null ? this : SMat.of(matrix.contrast());
    }

    public boolean dimEquals(SMat m) {
        Objects.requireNonNull(m, "Null matrix");
        return Arrays.equals(this.dimensions, m.dimensions);
    }

    @Override
    public DataType type() {
        return DataType.MAT;
    }

    @Override
    public String toString() {
        if (!this.isInitialized()) {
            return super.toString();
        }
        return super.toString() + " " + this.numberOfChannels + " channels, " + (String)(this.dimensions.length == 1 ? this.dimensions[0] + "(x1)" : JArrays.toString((long[])this.dimensions, (String)"x", (int)1000)) + ", " + String.valueOf((Object)this.depth) + "; data: " + String.valueOf(this.pointer);
    }

    public static SMat of(long dimX, long dimY, Depth depth, int numberOfChannels, ByteBuffer byteBuffer) {
        return SMat.of(new long[]{dimX, dimY}, depth, numberOfChannels, byteBuffer);
    }

    public static SMat of(long[] dimensions, Depth depth, int numberOfChannels, ByteBuffer byteBuffer) {
        return new SMat().setAll(dimensions, depth, numberOfChannels, byteBuffer, true);
    }

    public static SMat of(long[] dimensions, Depth depth, int numberOfChannels, byte[] byteArray) {
        return new SMat().setAll(dimensions, depth, numberOfChannels, byteArray);
    }

    public static SMat of(BufferedImage bufferedImage) {
        return new SMat().setTo(bufferedImage);
    }

    public static SMat of(MultiMatrix multiMatrix) {
        return new SMat().setTo(multiMatrix);
    }

    public static SMat of(MultiMatrix multiMatrix, ChannelOrder channelOrder) {
        return new SMat().setTo(multiMatrix, channelOrder);
    }

    public static SMat ofInterleavedBGR(Matrix<? extends PArray> interleavedChannels) {
        return new SMat().setToInterleavedBGR(interleavedChannels);
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer byteBuffer) {
        return SMat.cloneByteBuffer(byteBuffer, true);
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer byteBuffer, boolean directByteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer = byteBuffer.duplicate();
        ByteBuffer result = directByteBuffer ? ByteBuffer.allocateDirect(byteBuffer.capacity()) : ByteBuffer.allocate(byteBuffer.capacity());
        result.order(byteOrder);
        byteBuffer.rewind();
        result.put(byteBuffer);
        result.rewind();
        return result;
    }

    @Override
    protected void freeResources() {
        if (this.pointer != null) {
            this.pointer.dispose();
            this.pointer = null;
        }
        this.dimensions = new long[2];
        this.depth = null;
        this.numberOfChannels = 0;
    }

    @UsedForExternalCommunication
    private void setDimensions(long ... dimensions) {
        this.dimensions = SMat.checkDimensions(dimensions, this.allowed63BitDimensions);
    }

    private void setDepth(Depth depth) {
        this.depth = Objects.requireNonNull(depth, "Null depth");
    }

    @UsedForExternalCommunication
    private void setDepthCode(int depth) {
        this.depth = Depth.of(depth);
    }

    @UsedForExternalCommunication
    private void setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = SMat.checkNumberOfChannels(numberOfChannels);
    }

    @UsedForExternalCommunication
    private void setByteBuffer(ByteBuffer byteBuffer) {
        this.setPointer(new ConvertibleByteBufferMatrix(byteBuffer));
    }

    @UsedForExternalCommunication
    private void setMatrix(long[] dimensions, int numberOfChannels, int depthCode, ByteBuffer byteBuffer) {
        this.setDimensions(dimensions);
        this.setNumberOfChannels(numberOfChannels);
        this.setDepthCode(depthCode);
        this.setByteBuffer(byteBuffer);
    }

    @UsedForExternalCommunication
    private void setMatrix(long dimX, long dimY, int numberOfChannels, int depthCode, ByteBuffer byteBuffer) {
        this.setDimensions(dimX, dimY);
        this.setNumberOfChannels(numberOfChannels);
        this.setDepthCode(depthCode);
        this.setByteBuffer(byteBuffer);
    }

    private void setPointer(Convertible pointer) {
        Objects.requireNonNull(pointer, "Null pointer");
        this.pointer = pointer;
    }

    private static long[] checkDimensions(long[] dimensions, boolean allowed63BitDimensions) {
        Objects.requireNonNull(dimensions, "Null dimensions array");
        if (dimensions.length == 0) {
            throw new IllegalArgumentException("Empty dimensions Java array");
        }
        dimensions = (long[])dimensions.clone();
        for (int k = 0; k < dimensions.length; ++k) {
            SMat.checkDimension(k, dimensions[k], allowed63BitDimensions);
        }
        long product = net.algart.arrays.Arrays.longMul((long[])dimensions);
        if (product == Long.MIN_VALUE) {
            throw new IllegalArgumentException("Too large matrix [" + JArrays.toString((long[])dimensions, (String)"x", (int)1000) + "]: the number of elements >2^63-1 (9223372036854775807)");
        }
        if (!allowed63BitDimensions && product > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large matrix [" + JArrays.toString((long[])dimensions, (String)"x", (int)1000) + "]: the number of elements >2^31-1 (2147483647), this is not allowed");
        }
        return dimensions;
    }

    private static long checkDimension(int k, long dimension, boolean allowed63BitDimensions) {
        if (k < 0) {
            throw new IllegalArgumentException("Negative dimension index " + k);
        }
        if (dimension <= 0L) {
            throw new IllegalArgumentException("Zero or negative matrix dimension #" + k + " = " + dimension);
        }
        if (!allowed63BitDimensions && dimension > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large matrix dimension #" + k + " = " + dimension + " >= 2^31: this is not allowed");
        }
        return dimension;
    }

    static long[] addFirstElement(long newFirstElement, long[] values) {
        long[] result = new long[values.length + 1];
        System.arraycopy(values, 0, result, 1, values.length);
        result[0] = newFirstElement;
        return result;
    }

    static long[] removeFirstElement(long[] values) {
        return Arrays.copyOfRange(values, 1, values.length);
    }

    private static int checkNumberOfChannels(int numberOfChannels) {
        if (numberOfChannels <= 0 || numberOfChannels > 512) {
            throw new IllegalArgumentException("Number of channels " + numberOfChannels + " not in 1..512 range");
        }
        return numberOfChannels;
    }

    private Matrix<? extends PArray> toInterleavedBGR(boolean autoConvertUnsupportedDepth, boolean require2D) {
        if (!this.isInitialized()) {
            return null;
        }
        if (require2D && this.dimensions.length != 2) {
            throw new IllegalStateException("Cannot convert " + this.dimensions.length + "D matrix (" + String.valueOf(this) + "): only 2-dimensional matrices are allowed");
        }
        long[] newDimensions = SMat.addFirstElement(this.numberOfChannels, this.getDimensions());
        long size = net.algart.arrays.Arrays.longMul((long[])newDimensions);
        if (size == Long.MIN_VALUE) {
            throw new TooLargeArrayException("Too large dimensions: dim[0] * dim[1] * ... > Long.MAX_VALUE");
        }
        if (this.depth == Depth.BIT) {
            ByteBuffer byteBuffer = this.getByteBuffer();
            return BitArray.as((long[])PackedBitArraysPer8.toLongArray((ByteBuffer)byteBuffer), (long)size).matrix(newDimensions);
        }
        ByteBuffer bb = this.getByteBuffer();
        Class<Object> elementType = this.depth.elementType(!autoConvertUnsupportedDepth);
        if (autoConvertUnsupportedDepth && !this.depth.isAlgARTCompatible()) {
            bb = SMat.toByteBufferF32(bb, this.depth);
            elementType = Float.TYPE;
        }
        UpdatablePArray array = (UpdatablePArray)BufferMemoryModel.asUpdatableArray((ByteBuffer)bb, elementType);
        return array.matrix(newDimensions);
    }

    private static ByteBuffer toByteBufferF32(ByteBuffer source, Depth sourceDepth) {
        assert (sourceDepth == Depth.S8 || sourceDepth == Depth.S16);
        source = source.duplicate().order(source.order());
        source.rewind();
        int limit = source.limit();
        int length = sourceDepth == Depth.S8 ? limit : limit / 2;
        long newLimit = 4L * (long)length;
        if (newLimit > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot convert " + length + " byte/short to int values: the result will be greater than 2^31-1 bytes");
        }
        ByteBuffer result = ByteBuffer.allocateDirect((int)newLimit);
        FloatBuffer resultBuffer = result.asFloatBuffer();
        switch (sourceDepth.ordinal()) {
            case 1: {
                for (int k = 0; k < length; ++k) {
                    float v = source.get();
                    resultBuffer.put(v);
                }
                break;
            }
            case 3: {
                ShortBuffer sourceBuffer = source.asShortBuffer();
                for (int k = 0; k < length; ++k) {
                    float v = sourceBuffer.get();
                    resultBuffer.put(v);
                }
                break;
            }
        }
        return result;
    }

    public static enum Depth {
        U8(0, Byte.TYPE, 8, false, bb -> bb),
        S8(1, Byte.TYPE, 8, false, bb -> bb),
        U16(2, Short.TYPE, 16, false, ByteBuffer::asShortBuffer),
        S16(3, Short.TYPE, 16, false, ByteBuffer::asShortBuffer),
        S32(4, Integer.TYPE, 32, false, ByteBuffer::asIntBuffer),
        F32(5, Float.TYPE, 32, true, ByteBuffer::asFloatBuffer),
        F64(6, Double.TYPE, 64, true, ByteBuffer::asDoubleBuffer),
        BIT(101, Boolean.TYPE, 1, false, bb -> bb);

        private final int code;
        private final Class<?> elementType;
        private final int bitsPerElement;
        private final boolean floatingPoint;
        private final Function<ByteBuffer, Buffer> converter;

        private Depth(int code, Class<?> elementType, int bitsPerElement, boolean floatingPoint, Function<ByteBuffer, Buffer> converter) {
            this.code = code;
            this.elementType = elementType;
            this.bitsPerElement = bitsPerElement;
            this.floatingPoint = floatingPoint;
            this.converter = converter;
            SMat.CODE_TO_DEPTH[code] = this;
        }

        public int code() {
            return this.code;
        }

        public Class<?> elementType() {
            return this.elementType;
        }

        public Class<?> elementType(boolean requireAlgARTCompatibility) {
            if (requireAlgARTCompatibility && !this.isAlgARTCompatible()) {
                throw new IllegalStateException("Signed types less than 32-bit are not supported in AlgART (" + String.valueOf((Object)this) + ")");
            }
            return this.elementType;
        }

        public boolean isAlgARTCompatible() {
            return this.bitsPerElement() > 16 || this.isUnsigned();
        }

        public boolean isOpenCVCompatible() {
            return this != BIT;
        }

        public int bitsPerElement() {
            return this.bitsPerElement;
        }

        public boolean isUnsigned() {
            return this == BIT || this == U8 || this == U16;
        }

        public boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public Buffer asBuffer(ByteBuffer byteBuffer) {
            Objects.requireNonNull(byteBuffer, "Null byteBuffer");
            return this.converter.apply(byteBuffer);
        }

        public String toString() {
            return "Depth " + this.name() + " [code " + this.code + "]: " + this.bitsPerElement + " bits" + (this.isUnsigned() ? " (unsigned)" : "") + (this.floatingPoint ? " (float)" : "");
        }

        public static Depth of(int code) {
            Depth result;
            if (code < 0 || code >= CODE_TO_DEPTH.length || (result = CODE_TO_DEPTH[code]) == null) {
                throw new IllegalArgumentException("Unsupported depth code: " + code);
            }
            return result;
        }

        public static Depth of(Class<?> elementType) {
            return Depth.of(elementType, elementType == Byte.TYPE || elementType == Short.TYPE);
        }

        public static Depth of(Class<?> elementType, boolean unsigned) {
            Objects.requireNonNull(elementType, "Null elementType");
            if (elementType == Boolean.TYPE) {
                return BIT;
            }
            if (elementType == Byte.TYPE) {
                return unsigned ? U8 : S8;
            }
            if (elementType == Short.TYPE) {
                return unsigned ? U16 : S16;
            }
            if (unsigned) {
                throw new IllegalArgumentException("Only 8-bit and 16-bit unsigned integers supported");
            }
            if (elementType == Integer.TYPE) {
                return S32;
            }
            if (elementType == Float.TYPE) {
                return F32;
            }
            if (elementType == Double.TYPE) {
                return F64;
            }
            throw new IllegalArgumentException("Unsupported element type " + String.valueOf(elementType));
        }
    }

    public static abstract class Convertible {
        private volatile ByteBuffer cachedByteBuffer = null;
        private volatile MultiMatrix cachedMultiMatrix = null;

        public abstract Convertible copy();

        public abstract Convertible copyToMemoryAndDisposePrevious();

        public abstract ByteBuffer toByteBuffer(SMat var1);

        public byte[] toByteArray(SMat thisMatrix) {
            ByteBuffer byteBuffer = this.toByteBuffer(thisMatrix);
            byte[] result = new byte[byteBuffer.limit()];
            byteBuffer.rewind();
            byteBuffer.get(result);
            return result;
        }

        public abstract void dispose();

        ByteBuffer getCachedByteBuffer(SMat thisMatrix) {
            assert (thisMatrix != null);
            ByteBuffer result = this.cachedByteBuffer;
            if (result != null) {
                return result;
            }
            this.cachedByteBuffer = this.toByteBuffer(thisMatrix);
            return this.cachedByteBuffer;
        }

        MultiMatrix getCachedMultiMatrix(SMat thisMat, boolean autoConvertUnsupportedDepth, ChannelOrder channelOrder) {
            boolean doCache;
            assert (thisMat != null);
            assert (thisMat.isInitialized()) : "getCachedMultiMatrix must not be called for non-initialized " + String.valueOf(thisMat);
            MultiMatrix result = this.cachedMultiMatrix;
            boolean bl = doCache = channelOrder == ChannelOrder.STANDARD && thisMat.depth.isAlgARTCompatible();
            if (doCache && result != null) {
                return result;
            }
            Matrix<? extends PArray> m = thisMat.toInterleavedBGR(autoConvertUnsupportedDepth);
            assert (m != null) : "toInterleavedMatrix cannot be null for initialized SMat";
            if (m.dim(0) == 1L) {
                Matrix matrix = ((PArray)m.array()).matrix(SMat.removeFirstElement(m.dimensions()));
                if (!SimpleMemoryModel.isSimpleArray((Array)matrix.array())) {
                    matrix = matrix.clone();
                }
                result = MultiMatrix.ofMono((Matrix<? extends PArray>)matrix);
            } else {
                List channels = Matrices.separate(null, m, (int)512);
                MultiMatrix multiMatrix = result = channelOrder == ChannelOrder.ORDER_IN_PACKED_BYTE_BUFFER ? MultiMatrix.of(channels) : MultiMatrix.ofBGRA(channels);
            }
            if (doCache) {
                this.cachedMultiMatrix = result;
            }
            return result;
        }
    }

    public static enum ChannelOrder {
        ORDER_IN_PACKED_BYTE_BUFFER,
        STANDARD;

    }
}

