/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains.core;

import jakarta.json.JsonObject;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.chains.Chain;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.settings.SettingsBuilder;
import net.algart.executors.modules.core.common.FunctionTiming;
import net.algart.executors.modules.core.common.TimingStatistics;
import net.algart.json.Jsons;

public class InterpretChain
extends ChainExecutor
implements ReadOnlyExecutionInput {
    public static final String SETTINGS = "settings";
    private final FunctionTiming timing = FunctionTiming.newDisabledInstance();

    public InterpretChain() {
        this.disableOnChangeParametersAutomatic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        long t7;
        long t6;
        long t5;
        long t4;
        long t3;
        long t1 = System.nanoTime();
        boolean doAction = this.parameters().getBoolean("_sch___doAction", true);
        if (!doAction) {
            InterpretChain.copyInputToOutput(this);
            return;
        }
        Chain chain = this.chain();
        long t2 = System.nanoTime();
        this.status().setExecutorSimpleClassName(chain.name() == null ? "chain" : chain.name());
        JsonObject inputSettings = !this.hasInputPort(SETTINGS) ? Jsons.newEmptyJson() : Jsons.toJson(this.getInputScalar(SETTINGS, true).getValue(), true);
        chain.reinitializeAll();
        chain.setCaller(this);
        System.Logger.Level timingLogLevel = InterpretChain.ofLogLevel(this.parameters().getString("_sch___timingLogLevel", UseChain.TIMING_LOG_LEVEL_DEFAULT));
        int timingNumberOfCalls = LOG.isLoggable(timingLogLevel) ? this.parameters().getInteger("_sch___timingNumberOfCalls", 10) : 0;
        int timingNumberOfPercentiles = this.parameters().getInteger("_sch___timingNumberOfPercentiles", 5);
        TimingStatistics.Settings timingConfiguration = new TimingStatistics.Settings();
        timingConfiguration.setUniformPercentileLevels(timingNumberOfPercentiles);
        chain.setTimingSettings(timingNumberOfCalls, timingConfiguration);
        this.timing.setSettings(timingNumberOfCalls, timingConfiguration);
        try {
            chain.setParameters(this.parameters());
            t3 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            chain.readInputPortsFromExecutor(this);
            t4 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            this.setChainSettings(chain, inputSettings);
            t5 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            chain.executeNecessary(this);
            t6 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
            chain.writeOutputPortsToExecutor(this);
            t7 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
        }
        finally {
            chain.freeData();
        }
        long t8 = timingNumberOfCalls > 0 ? System.nanoTime() : 0L;
        this.timing.updatePassingData(t4 - t3 + t7 - t6);
        this.timing.updateExecution(t6 - t5);
        this.timing.updateSummary(t8 - t1);
        if (timingNumberOfCalls > 0 && this.parameters().getBoolean("_sch___logTiming", true)) {
            String name = chain.name() == null ? "" : " \"" + chain.name() + "\"";
            this.timing.analyse();
            Path file = chain.chainSpecificationPath();
            LOG.log(timingLogLevel, () -> String.format(Locale.US, "Chain%s executed%s%s in %.3f ms:%n  %.3f mcs getting chain, %.3f mcs setting parameters, %.3f mcs loading inputs, %.3f mcs set chain settings, %.3f mcs process, %.3f mcs returning outputs, %.3f mcs freeing%n  Chain ID: %s (identity %X)%n  Chain specification file: %s%n%s  All%s, %s", name, chain.isMultithreading() ? " (multithreading mode)" : " (single-thread mode)", chain.isExecuteAll() ? " (ALL blocks)" : "", (double)(t8 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001, (double)(t3 - t2) * 0.001, (double)(t4 - t3) * 0.001, (double)(t5 - t4) * 0.001, (double)(t6 - t5) * 0.001, (double)(t7 - t6) * 0.001, (double)(t8 - t7) * 0.001, chain.contextId(), System.identityHashCode(chain), file == null ? "n/a" : "\"" + String.valueOf(file) + "\"", chain.timingInfo(), name, this.timing));
        }
    }

    @Override
    public String visibleOutputPortName() {
        Collection<Port> outputPorts;
        String result = this.parameters().getString("_sch___visibleResult", null);
        if (result == null && !(outputPorts = this.outputPorts()).isEmpty()) {
            result = outputPorts.iterator().next().getName();
        }
        return result;
    }

    @Override
    protected boolean skipStandardAutomaticParameters() {
        return true;
    }

    private void setChainSettings(Chain chain, JsonObject parentSettings) {
        System.Logger.Level level;
        SettingsBuilder settingsBuilder = chain.getSettingsBuilder();
        if (settingsBuilder == null) {
            return;
        }
        boolean absolutePaths = this.parameters().getBoolean("_cs___absolutePaths", true);
        boolean extractSubSettings = this.parameters().getBoolean("_cs___extractSubSettings", true);
        boolean ignoreInputParameters = this.parameters().getBoolean("_cs___ignoreInputParameter", false);
        boolean logSettings = this.parameters().getBoolean("_cs___logSettings", false);
        settingsBuilder.setAbsolutePaths(absolutePaths);
        settingsBuilder.setExtractSubSettings(extractSubSettings);
        JsonObject executorSettings = ignoreInputParameters ? Jsons.newEmptyJson() : settingsBuilder.build(this);
        JsonObject overriddenSettings = settingsBuilder.overrideSettings(executorSettings, parentSettings);
        String settingsString = chain.setSettings(overriddenSettings);
        if (this.hasOutputPort(SETTINGS)) {
            this.getScalar(SETTINGS).setTo(settingsString);
        }
        if (this.hasOutputPort("_ss___settings_id")) {
            this.getScalar("_ss___settings_id").setTo(settingsBuilder.id());
        }
        System.Logger.Level level2 = level = logSettings ? System.Logger.Level.INFO : System.Logger.Level.DEBUG;
        if (!parentSettings.isEmpty()) {
            LOG.log(level, () -> String.format(Locale.US, "Customizing chain \"%s\" with help of %s \"%s\" (called from %s):\n%s%s", chain.name(), extractSubSettings ? "extracted sub-settings" : "json-settings", settingsBuilder.name(), InterpretChain.quoteContextName(this), settingsString, LOGGABLE_TRACE ? "\nOriginal settings (from parameters):\n" + Jsons.toPrettyString(executorSettings) + "\nInput settings (that override parameters):\n" + Jsons.toPrettyString(parentSettings) : ""));
        } else {
            LOG.log(level, () -> String.format(Locale.US, "Customizing chain \"%s\" directly from parameters (settings \"%s\", called from %s):\n%s", chain.name(), settingsBuilder.name(), InterpretChain.quoteContextName(this), settingsString));
        }
    }

    private static String quoteContextName(Executor e) {
        String contextName = e.getContextName();
        return contextName == null ? "unnamed context #" + String.valueOf(e.getContextId()) : "\"" + contextName + "\"";
    }
}

