/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.chains;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.ChainPortType;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.system.ExecutionStage;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.json.AbstractConvertibleToJson;
import net.algart.json.Jsons;

public final class ChainSpecification
extends AbstractConvertibleToJson {
    public static final String CHAIN_TECHNOLOGY = "chain";
    public static final String CHAIN_LANGUAGE = "chain";
    public static final String CHAIN_FILE_PATTERN = ".*\\.(json|chain)$";
    public static final String CHAIN_SECTION = "chain";
    public static final String CHAIN_APP_NAME = "chain";
    public static final String CURRENT_VERSION = "1.1";
    public static final String DEFAULT_CHAIN_CATEGORY = "chains";
    public static final String DEFAULT_CHAIN_CATEGORY_PREFIX = "chains.";
    public static final String DEFAULT_CHAIN_NAME = "chain";
    private static final String CHAIN_SECTION_LEGACY_ALIAS = "stare_chain";
    private static final String CHAIN_APP_NAME_LEGACY_ALIAS = "stare-chain";
    private static final Pattern COMPILED_CHAIN_FILE_PATTERN = Pattern.compile(".*\\.(json|chain)$");
    private Path specificationFile = null;
    private String version = "1.1";
    private Executor executor;
    private List<Block> blocks = new ArrayList<Block>();
    private List<Link> links = new ArrayList<Link>();
    private Set<String> tags = new LinkedHashSet<String>();
    private String platformId = null;
    private String platformCategory = null;

    public ChainSpecification() {
    }

    private ChainSpecification(JsonObject json, Path file) {
        if (!ChainSpecification.isChainSpecification(json)) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + (json == null ? " does not contain \"" : " contains illegal \"") + "chain\" section with chain configuration" + (json == null ? "" : ": it does not contain \"app\":\"chain\" element"));
        }
        this.specificationFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        this.executor = new Executor(Jsons.reqJsonObject(json, "executor", file), file);
        for (JsonObject jsonObject : ChainSpecification.reqJsonObjectsWithAlias(json, "blocks", "data_processes", null, file)) {
            this.blocks.add(new Block(jsonObject, file));
        }
        for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "links", file)) {
            Link link = new Link(jsonObject, file);
            if (!link.isValid()) continue;
            this.links.add(link);
        }
    }

    public static ChainSpecification of(JsonObject chainSpecification) {
        return new ChainSpecification(chainSpecification, null);
    }

    public static ChainSpecification of(String chainSpecificationString) {
        return ChainSpecification.of(chainSpecificationString, true);
    }

    public static ChainSpecification ofIfValid(String chainSpecificationString) {
        return ChainSpecification.of(chainSpecificationString, false);
    }

    public static ChainSpecification read(Path containingJsonFile) throws IOException {
        return ChainSpecification.read(containingJsonFile, true);
    }

    public static ChainSpecification readIfValid(Path containingJsonFile) {
        try {
            return ChainSpecification.read(containingJsonFile, false);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static List<ChainSpecification> readAllIfValid(Path containingJsonPath, boolean recursive) throws IOException {
        return ChainSpecification.readAllIfValid(null, containingJsonPath, recursive);
    }

    public static List<ChainSpecification> readAllIfValid(List<ChainSpecification> result, Path containingJsonPath, boolean recursive) throws IOException {
        return ExecutorSpecification.readAllIfValid(result, containingJsonPath, recursive, ChainSpecification::readIfValid, ChainSpecification::isChainSpecificationFile);
    }

    public void rewriteChainSection(Path containingJsonFile, OpenOption ... options) throws IOException {
        LinkedHashMap<String, JsonObject> clone;
        Objects.requireNonNull(containingJsonFile, "Null containingJsonFile");
        if (Files.exists(containingJsonFile, new LinkOption[0])) {
            JsonObject existingJson = Jsons.readJson(containingJsonFile);
            Jsons.reqJsonObjectWithAlias(existingJson, "chain", CHAIN_SECTION_LEGACY_ALIAS, containingJsonFile);
            clone = new LinkedHashMap(existingJson);
        } else {
            clone = new LinkedHashMap<String, JsonObject>();
        }
        clone.remove(CHAIN_SECTION_LEGACY_ALIAS);
        clone.put("chain", this.toJson());
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry entry : clone.entrySet()) {
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        JsonObject json = builder.build();
        Files.writeString(containingJsonFile, (CharSequence)Jsons.toPrettyString(json), options);
    }

    public static boolean isChainSpecificationFile(Path specificationFile) {
        Objects.requireNonNull(specificationFile, "Null specificationFile");
        return COMPILED_CHAIN_FILE_PATTERN.matcher(specificationFile.getFileName().toString().toLowerCase()).matches();
    }

    public static boolean isChainSpecification(JsonObject specificationJson) {
        if (specificationJson == null) {
            return false;
        }
        String appName = specificationJson.getString("app", null);
        return "chain".equals(appName) || CHAIN_APP_NAME_LEGACY_ALIAS.equals(appName);
    }

    public static JsonObject getChainSpecification(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        if (json.containsKey((Object)"chain")) {
            return Jsons.getJsonObject(json, "chain", null);
        }
        if (json.containsKey((Object)CHAIN_SECTION_LEGACY_ALIAS)) {
            return Jsons.getJsonObject(json, CHAIN_SECTION_LEGACY_ALIAS, null);
        }
        return null;
    }

    public static JsonObject getChainSpecification(JsonObject json, JsonObject defaultValue) {
        JsonObject chainSpecification = ChainSpecification.getChainSpecification(json);
        return chainSpecification != null ? chainSpecification : defaultValue;
    }

    public static boolean isChainSpecificationContainer(JsonObject json) {
        return ChainSpecification.isChainSpecification(ChainSpecification.getChainSpecification(json, json));
    }

    public static void checkIdDifference(Collection<ChainSpecification> chains) {
        Objects.requireNonNull(chains, "Null chain JSONs collection");
        HashSet<String> ids = new HashSet<String>();
        for (ChainSpecification chain : chains) {
            if (ids.add(chain.chainId())) continue;
            throw new IllegalArgumentException("Two chain variants have identical ID " + chain.chainId() + (String)(chain.specificationFile == null ? "" : ", the 2nd chain is loaded from the file " + String.valueOf(chain.specificationFile)));
        }
    }

    public boolean hasSpecificationFile() {
        return this.specificationFile != null;
    }

    public Path getSpecificationFile() {
        return this.specificationFile;
    }

    public String getVersion() {
        return this.version;
    }

    public ChainSpecification setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ChainSpecification setExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "Null executor");
        return this;
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public ChainSpecification setBlocks(List<Block> blocks) {
        this.blocks = ExecutorSpecification.checkNonNullObjects(blocks);
        return this;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public ChainSpecification setLinks(List<Link> links) {
        this.links = links;
        return this;
    }

    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public ChainSpecification setTags(Set<String> tags) {
        Objects.requireNonNull(tags, "Null tags");
        this.tags = new LinkedHashSet<String>(tags);
        return this;
    }

    public void addTags(Collection<String> tags) {
        Objects.requireNonNull(tags, "Null tags");
        this.tags.addAll(tags);
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public ChainSpecification setPlatformId(String platformId) {
        this.platformId = platformId;
        return this;
    }

    public String getPlatformCategory() {
        return this.platformCategory;
    }

    public ChainSpecification setPlatformCategory(String platformCategory) {
        this.platformCategory = platformCategory;
        return this;
    }

    public String chainCategory() {
        return this.executor.category;
    }

    public String chainName() {
        assert (this.executor.name != null);
        return this.executor.name;
    }

    public String chainId() {
        assert (this.executor.id != null);
        return this.executor.id;
    }

    public String canonicalName() {
        return ExecutorSpecification.className(this.chainCategory(), this.chainName());
    }

    @Override
    public void checkCompleteness() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ChainSpecification{\n  version=" + this.version + ",\n  executor=" + String.valueOf(this.executor) + ",\n  blocks=[\n");
        for (Block block : this.blocks) {
            sb.append("    ").append(block).append('\n');
        }
        sb.append("  ],\n  links=[\n");
        for (Link link : this.links) {
            sb.append("    ").append(link).append('\n');
        }
        sb.append("  ]\n}\n");
        return sb.toString();
    }

    @Override
    public void buildJson(JsonObjectBuilder builder) {
        builder.add("app", "chain");
        if (!this.version.equals(CURRENT_VERSION)) {
            builder.add("version", this.version);
        }
        builder.add("executor", (JsonValue)this.executor.toJson());
        JsonArrayBuilder blocksBuilder = Json.createArrayBuilder();
        for (Block block : this.blocks) {
            blocksBuilder.add((JsonValue)block.toJson());
        }
        builder.add("blocks", (JsonValue)blocksBuilder.build());
        JsonArrayBuilder linksBuilder = Json.createArrayBuilder();
        for (Link link : this.links) {
            linksBuilder.add((JsonValue)link.toJson());
        }
        builder.add("links", (JsonValue)linksBuilder.build());
    }

    private static ChainSpecification of(String chainSpecificationString, boolean requireValid) {
        Objects.requireNonNull(chainSpecificationString, "Null chainSpecificationString");
        JsonObject json = Jsons.toJson(chainSpecificationString);
        json = ChainSpecification.getChainSpecification(json, json);
        if (!ChainSpecification.isChainSpecification(json) && !requireValid) {
            return null;
        }
        return new ChainSpecification(json, null);
    }

    private static ChainSpecification read(Path containingJsonFile, boolean requireValid) throws IOException {
        Objects.requireNonNull(containingJsonFile, "Null containingJsonFile");
        JsonObject json = Jsons.readJson(containingJsonFile);
        JsonObject chainSpecification = Jsons.getJsonObject(json, "chain", containingJsonFile);
        if (chainSpecification == null) {
            chainSpecification = Jsons.getJsonObject(json, CHAIN_SECTION_LEGACY_ALIAS, containingJsonFile);
        }
        if (!ChainSpecification.isChainSpecification(chainSpecification) && !requireValid) {
            return null;
        }
        return new ChainSpecification(chainSpecification, containingJsonFile);
    }

    private static String removeExtension(String fileName) {
        int p = fileName.lastIndexOf(46);
        return p == -1 ? fileName : fileName.substring(0, p);
    }

    private static List<JsonObject> reqJsonObjectsWithAlias(JsonObject json, String name, String aliasName1, String aliasName2, Path file) {
        JsonArray jsonArray;
        Objects.requireNonNull(json, "Null json");
        Objects.requireNonNull(name, "Null name");
        try {
            jsonArray = json.getJsonArray(name);
            if (jsonArray == null && aliasName1 != null) {
                jsonArray = json.getJsonArray(aliasName1);
            }
            if (jsonArray == null && aliasName2 != null) {
                jsonArray = json.getJsonArray(aliasName2);
            }
        }
        catch (ClassCastException e) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" value is not a JSON array" + (String)(file == null ? " <<<" + String.valueOf(json) + ">>>" : ""));
        }
        if (jsonArray == null) {
            throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"" + name + "\" array required");
        }
        return Jsons.toJsonObjects(jsonArray, name, file);
    }

    public static final class Executor
    extends AbstractConvertibleToJson {
        private boolean autogeneratedCategory = false;
        private String category;
        private boolean autogeneratedName = false;
        private String name;
        private String description = null;
        private String id;
        private Options options = new Options();

        public Executor() {
        }

        private Executor(JsonObject json, Path file) {
            String fileName = file == null ? null : ChainSpecification.removeExtension(file.getFileName().toString());
            String recommendedName = ExecutionBlock.recommendedName(fileName);
            String recommendedCategory = ExecutionBlock.recommendedCategory(fileName);
            this.category = json.getString("category", null);
            if (this.category == null) {
                this.category = recommendedCategory == null ? ChainSpecification.DEFAULT_CHAIN_CATEGORY : ChainSpecification.DEFAULT_CHAIN_CATEGORY_PREFIX + recommendedCategory;
                this.autogeneratedCategory = true;
            }
            this.name = json.getString("name", null);
            if (this.name == null) {
                this.name = recommendedName == null ? "chain" : recommendedName;
                this.autogeneratedName = true;
            }
            this.description = json.getString("description", null);
            this.id = Jsons.reqStringWithAlias(json, "id", "uuid", file);
            JsonObject optionsJson = json.getJsonObject("options");
            if (optionsJson != null) {
                this.options = new Options(optionsJson, file);
            }
        }

        public boolean isAutogeneratedCategory() {
            return this.autogeneratedCategory;
        }

        public String getCategory() {
            return this.category;
        }

        public Executor setCategory(String category, boolean autogeneratedCategory) {
            this.category = Objects.requireNonNull(category, "Null category");
            this.autogeneratedCategory = autogeneratedCategory;
            return this;
        }

        public boolean isAutogeneratedName() {
            return this.autogeneratedName;
        }

        public String getName() {
            return this.name;
        }

        public Executor setName(String name, boolean autogeneratedName) {
            this.name = Objects.requireNonNull(name, "Null name");
            this.autogeneratedName = autogeneratedName;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Executor setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Executor setId(String id) {
            this.id = Objects.requireNonNull(id, "Null ID");
            return this;
        }

        public Options getOptions() {
            return this.options;
        }

        public Executor setOptions(Options options) {
            this.options = Objects.requireNonNull(options, "Null options");
            return this;
        }

        @Override
        public void checkCompleteness() {
            this.checkNull(this.category, "category");
            this.checkNull(this.name, "name");
            this.checkNull(this.id, "id");
        }

        public String toString() {
            return "Executor{\n    category='" + this.category + "',\n    name='" + this.name + "',\n    description=" + (this.description == null ? null : "'" + this.description + "'") + ",\n    id=" + this.id + ",\n    options=" + String.valueOf(this.options) + "\n  }";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            if (!this.autogeneratedCategory) {
                builder.add("category", this.category);
            }
            if (!this.autogeneratedCategory) {
                builder.add("name", this.name);
            }
            if (this.description != null) {
                builder.add("description", this.description);
            }
            builder.add("id", this.id);
            builder.add("options", (JsonValue)this.options.toJson());
        }

        public static final class Options
        extends AbstractConvertibleToJson {
            private Execution execution = new Execution();

            public Options() {
            }

            private Options(JsonObject json, Path file) {
                JsonObject executionJson = json.getJsonObject("execution");
                if (executionJson != null) {
                    this.execution = new Execution(executionJson, file);
                }
            }

            public Execution getExecution() {
                return this.execution;
            }

            public Options setExecution(Execution execution) {
                this.execution = Objects.requireNonNull(execution, "Null execution");
                return this;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "Options{execution=" + String.valueOf(this.execution) + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("execution", (JsonValue)this.execution.toJson());
            }

            public static final class Execution
            extends AbstractConvertibleToJson {
                private boolean all = false;
                private boolean multithreading = true;
                private boolean ignoreExceptions = false;

                public Execution() {
                }

                private Execution(JsonObject json, Path file) {
                    this.all = json.getBoolean("all", false);
                    this.multithreading = json.getBoolean("multithreading", true);
                    this.ignoreExceptions = json.getBoolean("ignore_exceptions", false);
                }

                public boolean isAll() {
                    return this.all;
                }

                public Execution setAll(boolean all) {
                    this.all = all;
                    return this;
                }

                public boolean isMultithreading() {
                    return this.multithreading;
                }

                public Execution setMultithreading(boolean multithreading) {
                    this.multithreading = multithreading;
                    return this;
                }

                public boolean isIgnoreExceptions() {
                    return this.ignoreExceptions;
                }

                public Execution setIgnoreExceptions(boolean ignoreExceptions) {
                    this.ignoreExceptions = ignoreExceptions;
                    return this;
                }

                @Override
                public void checkCompleteness() {
                }

                public String toString() {
                    return "Execution{all=" + this.all + ", multithreading=" + this.multithreading + ", ignoreExceptions=" + this.ignoreExceptions + "}";
                }

                @Override
                public void buildJson(JsonObjectBuilder builder) {
                    builder.add("all", this.all);
                    builder.add("multithreading", this.multithreading);
                    builder.add("ignore_exceptions", this.ignoreExceptions);
                }
            }
        }
    }

    public static final class Block
    extends AbstractConvertibleToJson {
        private static final String[] OLD_PORT_ARRAYS = new String[]{"in_ports", "out_ports", "in_control_ports", "out_control_ports"};
        private String uuid;
        private String executorId;
        private String executorName = null;
        private String executorCategory = null;
        private ExecutionStage executionStage = ExecutionStage.RUN_TIME;
        private Map<String, Port> uuidToPortMap = new LinkedHashMap<String, Port>();
        private Map<String, Parameter> nameToParameterMap = new LinkedHashMap<String, Parameter>();
        private System system = new System();

        public Block() {
        }

        private Block(JsonObject json, Path file) {
            this.uuid = Jsons.reqString(json, "uuid", file);
            this.executorId = Jsons.reqStringWithAlias(json, "model_uuid", "executor_id", file);
            this.executorName = json.getString("executor_name", null);
            this.executorCategory = json.getString("executor_category", null);
            String executionStage = json.getString("execution_stage", ExecutionStage.RUN_TIME.stageName());
            this.executionStage = ExecutionStage.ofOrNull(executionStage);
            Jsons.requireNonNull(this.executionStage, json, "execution_stage", "unknown (\"" + executionStage + "\")", file);
            boolean oldFormat = false;
            if (!json.containsKey((Object)"ports")) {
                for (String string : OLD_PORT_ARRAYS) {
                    oldFormat |= json.containsKey((Object)string);
                }
            }
            if (oldFormat) {
                for (String string : OLD_PORT_ARRAYS) {
                    if (!json.containsKey((Object)string)) continue;
                    for (JsonObject jsonObject : Jsons.reqJsonObjects(json, string, file)) {
                        Port port = new Port(jsonObject, file);
                        this.uuidToPortMap.put(port.uuid, port);
                    }
                }
            } else {
                for (JsonObject jsonObject : Jsons.reqJsonObjects(json, "ports", file)) {
                    Port port = new Port(jsonObject, file);
                    this.uuidToPortMap.put(port.uuid, port);
                }
            }
            List<JsonObject> jsonParameters = ChainSpecification.reqJsonObjectsWithAlias(json, "parameters", "properties", "primitives", file);
            for (JsonObject jsonObject : jsonParameters) {
                Parameter parameter = new Parameter(jsonObject, file);
                this.nameToParameterMap.put(parameter.name, parameter);
            }
            JsonObject systemJson = json.getJsonObject("system");
            if (systemJson != null) {
                this.system = new System(systemJson, file);
            }
        }

        public String getUuid() {
            return this.uuid;
        }

        public Block setUuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, "Null UUID");
            return this;
        }

        public String getExecutorId() {
            return this.executorId;
        }

        public Block setExecutorId(String executorId) {
            this.executorId = Objects.requireNonNull(executorId, "Null executor UUID");
            return this;
        }

        public String getExecutorName() {
            return this.executorName;
        }

        public Block setExecutorName(String executorName) {
            this.executorName = executorName;
            return this;
        }

        public String getExecutorCategory() {
            return this.executorCategory;
        }

        public Block setExecutorCategory(String executorCategory) {
            this.executorCategory = executorCategory;
            return this;
        }

        public ExecutionStage getExecutionStage() {
            return this.executionStage;
        }

        public Block setExecutionStage(ExecutionStage executionStage) {
            this.executionStage = Objects.requireNonNull(executionStage, "Null execution stage");
            return this;
        }

        public Map<String, Port> getUuidToPortMap() {
            return Collections.unmodifiableMap(this.uuidToPortMap);
        }

        public Block setUuidToPortMap(Map<String, Port> uuidToPortMap) {
            this.uuidToPortMap = Block.checkPorts(uuidToPortMap);
            return this;
        }

        public Map<String, Parameter> getNameToParameterMap() {
            return Collections.unmodifiableMap(this.nameToParameterMap);
        }

        public Block setNameToParameterMap(Map<String, Parameter> nameToParameterMap) {
            this.nameToParameterMap = Block.checkParameters(nameToParameterMap);
            return this;
        }

        public System getSystem() {
            assert (this.system != null);
            return this.system;
        }

        public Block setSystem(System system) {
            this.system = Objects.requireNonNull(system, "Null system");
            return this;
        }

        @Override
        public void checkCompleteness() {
            this.checkNull(this.uuid, "uuid");
            this.checkNull(this.executorId, "executorUuid");
        }

        public String toString() {
            return "Block{uuid='" + this.uuid + "', executorId='" + this.executorId + "', executorName='" + this.executorName + "', executorCategory='" + this.executorCategory + "', executionStage=" + String.valueOf((Object)this.executionStage) + ", uuidToPortMap=" + String.valueOf(this.uuidToPortMap) + ", nameToParameterMap=" + String.valueOf(this.nameToParameterMap) + ", system=" + String.valueOf(this.system) + "}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("uuid", this.uuid);
            builder.add("executor_id", this.executorId);
            if (this.executorName != null) {
                builder.add("executor_name", this.executorName);
            }
            if (this.executorCategory != null) {
                builder.add("executor_category", this.executorCategory);
            }
            if (this.executionStage != ExecutionStage.RUN_TIME) {
                builder.add("execution_stage", this.executionStage.stageName());
            }
            JsonArrayBuilder portsBuilder = Json.createArrayBuilder();
            for (Port port : this.uuidToPortMap.values()) {
                portsBuilder.add((JsonValue)port.toJson());
            }
            builder.add("ports", (JsonValue)portsBuilder.build());
            JsonArrayBuilder parametersBuilder = Json.createArrayBuilder();
            for (Parameter parameter : this.nameToParameterMap.values()) {
                parametersBuilder.add((JsonValue)parameter.toJson());
            }
            builder.add("parameters", (JsonValue)parametersBuilder.build());
            builder.add("system", (JsonValue)this.system.toJson());
        }

        private static Map<String, Port> checkPorts(Map<String, Port> ports) {
            Objects.requireNonNull(ports, "Null ports");
            ports = new LinkedHashMap<String, Port>(ports);
            for (Map.Entry<String, Port> port : ports.entrySet()) {
                if (port.getKey() == null) {
                    throw new IllegalArgumentException("Illegal port: null key");
                }
                if (port.getValue() == null) {
                    throw new IllegalArgumentException("Illegal port[" + ExecutorSpecification.quote(port.getKey()) + "]: null");
                }
                if (port.getKey().equals(port.getValue().uuid)) continue;
                throw new IllegalArgumentException("Illegal port[" + ExecutorSpecification.quote(port.getKey()) + "]: its uuid is " + ExecutorSpecification.quote(port.getValue().uuid) + " (must be equal to key " + ExecutorSpecification.quote(port.getKey()) + ")");
            }
            return ports;
        }

        private static Map<String, Parameter> checkParameters(Map<String, Parameter> parameters) {
            Objects.requireNonNull(parameters, "Null parameters");
            parameters = new LinkedHashMap<String, Parameter>(parameters);
            for (Map.Entry<String, Parameter> parameter : parameters.entrySet()) {
                if (parameter.getKey() == null) {
                    throw new IllegalArgumentException("Illegal parameter: null key");
                }
                if (parameter.getValue() == null) {
                    throw new IllegalArgumentException("Illegal parameter[" + ExecutorSpecification.quote(parameter.getKey()) + "]: null");
                }
                if (parameter.getKey().equals(parameter.getValue().name)) continue;
                throw new IllegalArgumentException("Illegal parameter[" + ExecutorSpecification.quote(parameter.getKey()) + "]: its name is " + ExecutorSpecification.quote(parameter.getValue().name) + " (must be equal to key " + ExecutorSpecification.quote(parameter.getKey()) + ")");
            }
            return parameters;
        }

        public static final class System
        extends AbstractConvertibleToJson {
            private String name = null;
            private String caption = null;
            private String description = null;
            private boolean enabled = true;

            public System() {
            }

            private System(JsonObject json, Path file) {
                this.name = json.getString("name", null);
                this.caption = json.getString("caption", null);
                this.description = json.getString("description", null);
                this.enabled = json.getBoolean("enabled", true);
            }

            public String getName() {
                return this.name;
            }

            public System setName(String name) {
                this.name = name;
                return this;
            }

            public String getCaption() {
                return this.caption;
            }

            public System setCaption(String caption) {
                this.caption = caption;
                return this;
            }

            public String getDescription() {
                return this.description;
            }

            public System setDescription(String description) {
                this.description = description;
                return this;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public System setEnabled(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public String name() {
                if (this.name == null) {
                    return null;
                }
                String name = this.name.trim();
                return name.isEmpty() ? null : name;
            }

            @Override
            public void checkCompleteness() {
            }

            public String toString() {
                return "System{name='" + this.name + "', caption='" + this.caption + "', description='" + this.description + "', enabled=" + this.enabled + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                if (this.name != null) {
                    builder.add("name", this.name);
                }
                if (this.caption != null) {
                    builder.add("caption", this.caption);
                }
                if (this.description != null) {
                    builder.add("description", this.description);
                }
                builder.add("enabled", this.enabled);
            }
        }

        public static final class Port
        extends AbstractConvertibleToJson {
            private String uuid;
            private String name;
            private ChainPortType portType;
            private DataType dataType;

            public Port() {
            }

            private Port(JsonObject json, Path file) {
                this.uuid = Jsons.reqString(json, "uuid", file);
                this.name = Jsons.reqStringWithAlias(json, "name", "port_name", file);
                this.portType = ChainPortType.ofOrNull(Jsons.reqIntWithAlias(json, "type", "port_type", file));
                Jsons.requireNonNull(this.portType, json, "type", file);
                this.dataType = DataType.ofUUIDOrNull(Jsons.reqString(json, "data_type_uuid", file));
                Jsons.requireNonNull(this.dataType, json, "data_type_uuid", file);
                assert (this.portType != null) : "was checked in requireNonNull";
                if (this.portType.isVirtual() && this.dataType != DataType.SCALAR) {
                    throw new JsonException("Invalid JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + ": \"port " + this.name + "\" is virtual (" + String.valueOf((Object)this.portType) + ") and must contain scalar data only, but data type is " + String.valueOf((Object)this.dataType) + " <<<" + String.valueOf(json) + ">>>");
                }
            }

            public String getUuid() {
                return this.uuid;
            }

            public Port setUuid(String uuid) {
                this.uuid = Objects.requireNonNull(uuid, "Null uuid");
                return this;
            }

            public String getName() {
                return this.name;
            }

            public Port setName(String name) {
                this.name = Objects.requireNonNull(name, "Null name");
                return this;
            }

            public ChainPortType getPortType() {
                return this.portType;
            }

            public Port setPortType(ChainPortType portType) {
                this.portType = Objects.requireNonNull(portType, "Null portType");
                return this;
            }

            public DataType getDataType() {
                return this.dataType;
            }

            public Port setDataType(DataType dataType) {
                this.dataType = Objects.requireNonNull(dataType, "Null dataType");
                return this;
            }

            @Override
            public void checkCompleteness() {
                this.checkNull(this.uuid, "uuid");
                this.checkNull(this.name, "name");
                this.checkNull((Object)this.portType, "portType");
                this.checkNull((Object)this.dataType, "dataType");
            }

            public String toString() {
                return "Port{uuid='" + this.uuid + "', name='" + this.name + "', portType=" + String.valueOf((Object)this.portType) + ", dataType=" + String.valueOf((Object)this.dataType) + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("uuid", this.uuid);
                builder.add("name", this.name);
                builder.add("type", this.portType.code());
                builder.add("data_type_uuid", this.dataType.uuid().toString());
            }
        }

        public static final class Parameter
        extends AbstractConvertibleToJson {
            private String name;
            private JsonValue value = null;

            public Parameter() {
            }

            private Parameter(JsonObject json, Path file) {
                this.name = Jsons.reqString(json, "name", file);
                this.value = (JsonValue)json.get((Object)"value");
            }

            public String getName() {
                return this.name;
            }

            public Parameter setName(String name) {
                this.name = Objects.requireNonNull(name, "Null name");
                return this;
            }

            public JsonValue getValue() {
                return this.value;
            }

            public Parameter setValue(JsonValue value) {
                this.value = value;
                return this;
            }

            @Override
            public void checkCompleteness() {
                this.checkNull(this.name, "name");
            }

            public String toString() {
                return "Parameter{name='" + this.name + "', value=" + String.valueOf(this.value) + "}";
            }

            @Override
            public void buildJson(JsonObjectBuilder builder) {
                builder.add("name", this.name);
                if (this.value != null) {
                    builder.add("value", this.value);
                }
            }
        }
    }

    public static final class Link
    extends AbstractConvertibleToJson {
        private String uuid;
        private String srcPortUuid;
        private String destPortUuid;

        public Link() {
        }

        private Link(JsonObject json, Path file) {
            this.uuid = json.getString("uuid", null);
            this.srcPortUuid = json.getString("src_port_uuid", null);
            this.destPortUuid = json.getString("dest_port_uuid", null);
        }

        private boolean isValid() {
            return this.uuid != null && this.srcPortUuid != null && this.destPortUuid != null;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Link setUuid(String uuid) {
            this.uuid = Objects.requireNonNull(uuid, "Null uuid");
            return this;
        }

        public String getSrcPortUuid() {
            return this.srcPortUuid;
        }

        public Link setSrcPortUuid(String srcPortUuid) {
            this.srcPortUuid = Objects.requireNonNull(srcPortUuid, "Null srcPortUuid");
            return this;
        }

        public String getDestPortUuid() {
            return this.destPortUuid;
        }

        public Link setDestPortUuid(String destPortUuid) {
            this.destPortUuid = Objects.requireNonNull(destPortUuid, "Null destPortUuid");
            return this;
        }

        @Override
        public void checkCompleteness() {
            this.checkNull(this.uuid, "uuid");
            this.checkNull(this.srcPortUuid, "srcPortUuid");
            this.checkNull(this.destPortUuid, "destPortUuid");
        }

        public String toString() {
            return "Link{uuid='" + this.uuid + "', srcPortUuid='" + this.srcPortUuid + "', destPortUuid='" + this.destPortUuid + "'}";
        }

        @Override
        public void buildJson(JsonObjectBuilder builder) {
            builder.add("uuid", this.uuid);
            builder.add("src_port_uuid", this.srcPortUuid);
            builder.add("dest_port_uuid", this.destPortUuid);
        }
    }
}

