/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.Executor;
import net.algart.executors.api.parameters.NoValidParameterException;
import net.algart.executors.api.parameters.ParameterValueType;
import net.algart.executors.api.parameters.Parameters;

abstract class ParameterSetter {
    final Method method;
    private final int priority;
    final String parameterName;
    final Class<?> parameterType;

    ParameterSetter(Method method, Class<?> parameterType, int priority) {
        assert (method != null);
        assert (parameterType != null);
        this.method = method;
        this.priority = priority;
        this.parameterType = parameterType;
        String parameterName = method.getName().substring("set".length());
        assert (!parameterName.isEmpty());
        this.parameterName = parameterName.substring(0, 1).toLowerCase() + parameterName.substring(1);
    }

    abstract Object getValue(Parameters var1);

    abstract ParameterValueType getControlValueType();

    void set(Executor executor) {
        try {
            Object value = this.getValue(executor.parameters());
            Executor.LOG.log(System.Logger.Level.TRACE, () -> "    Setting property " + this.parameterName + " to " + String.valueOf(value) + " by " + this.getClass().getSimpleName());
            this.method.invoke((Object)executor, value);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Cannot call method \"" + String.valueOf(this.method) + "\" for executor " + String.valueOf(executor)));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError("Setter method \"" + String.valueOf(this.method) + "\" throws unexpected checked exception", e);
        }
    }

    static Map<String, ParameterSetter> findSetters(Executor executor) {
        Objects.requireNonNull(executor, "Null executor");
        LinkedHashMap<String, ParameterSetter> result = new LinkedHashMap<String, ParameterSetter>();
        for (Method method : executor.getClass().getMethods()) {
            ParameterSetter previous;
            ParameterSetter setter;
            if (executor.skipStandardAutomaticParameters() && method.getDeclaringClass().equals(Executor.class) || (setter = ParameterSetter.getInstanceOrNull(method)) == null || (previous = (ParameterSetter)result.get(setter.parameterName)) != null && setter.priority < previous.priority) continue;
            result.put(setter.parameterName, setter);
        }
        return result;
    }

    private static ParameterSetter getInstanceOrNull(Method method) {
        Objects.requireNonNull(method);
        String name = method.getName();
        if (!name.startsWith("set") || name.length() < 4 || !Character.isUpperCase(name.charAt(3))) {
            return null;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if ((declaringClass == Executor.class || declaringClass == ExecutionBlock.class) && Executor.NON_SETTERS.contains(name)) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            return null;
        }
        if (parameterTypes[0].equals(Boolean.TYPE)) {
            return new BooleanSetter(method);
        }
        if (parameterTypes[0].equals(Integer.TYPE)) {
            return new IntSetter(method);
        }
        if (parameterTypes[0].equals(Long.TYPE)) {
            return new LongSetter(method);
        }
        if (parameterTypes[0].equals(Float.TYPE)) {
            return new FloatSetter(method);
        }
        if (parameterTypes[0].equals(Double.TYPE)) {
            return new DoubleSetter(method);
        }
        if (parameterTypes[0].equals(Integer.class)) {
            return new IntOrNullSetter(method);
        }
        if (parameterTypes[0].equals(Long.class)) {
            return new LongOrNullSetter(method);
        }
        if (parameterTypes[0].equals(Float.class)) {
            return new FloatOrNullSetter(method);
        }
        if (parameterTypes[0].equals(Double.class)) {
            return new DoubleOrNullSetter(method);
        }
        if (parameterTypes[0].equals(String.class)) {
            return new StringSetter(method);
        }
        if (parameterTypes[0].equals(Color.class)) {
            return new ColorSetter(method);
        }
        if (parameterTypes[0].isEnum()) {
            return new EnumSetter(method, parameterTypes[0]);
        }
        return null;
    }

    static class BooleanSetter
    extends ParameterSetter {
        BooleanSetter(Method method) {
            super(method, Boolean.TYPE, 1);
        }

        @Override
        Object getValue(Parameters properties) {
            return properties.getBoolean(this.parameterName);
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.BOOLEAN;
        }
    }

    static class IntSetter
    extends ParameterSetter {
        IntSetter(Method method) {
            super(method, Integer.TYPE, 2);
        }

        @Override
        Object getValue(Parameters properties) {
            return properties.getInteger(this.parameterName);
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.INT;
        }
    }

    static class LongSetter
    extends ParameterSetter {
        LongSetter(Method method) {
            super(method, Long.TYPE, 3);
        }

        @Override
        Object getValue(Parameters properties) {
            return properties.getLong(this.parameterName);
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.LONG;
        }
    }

    static class FloatSetter
    extends ParameterSetter {
        FloatSetter(Method method) {
            super(method, Float.TYPE, 4);
        }

        @Override
        Object getValue(Parameters properties) {
            return Float.valueOf((float)properties.getDouble(this.parameterName));
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.FLOAT;
        }
    }

    static class DoubleSetter
    extends ParameterSetter {
        DoubleSetter(Method method) {
            super(method, Double.TYPE, 5);
        }

        @Override
        Object getValue(Parameters properties) {
            return properties.getDouble(this.parameterName);
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.DOUBLE;
        }
    }

    static class IntOrNullSetter
    extends ParameterSetter {
        IntOrNullSetter(Method method) {
            super(method, Integer.class, 11);
        }

        @Override
        Object getValue(Parameters properties) {
            String value = properties.getString(this.parameterName);
            value = value == null ? "" : value.trim();
            try {
                return value.isEmpty() ? null : Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new NoValidParameterException("Property \"" + this.parameterName + "\" is not a valid integer value: \"" + value + "\"");
            }
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.STRING;
        }
    }

    static class LongOrNullSetter
    extends ParameterSetter {
        LongOrNullSetter(Method method) {
            super(method, Integer.class, 12);
        }

        @Override
        Object getValue(Parameters properties) {
            String value = properties.getString(this.parameterName);
            value = value == null ? "" : value.trim();
            try {
                return value.isEmpty() ? null : Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new NoValidParameterException("Property \"" + this.parameterName + "\" is not a valid long integer value: \"" + value + "\"");
            }
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.STRING;
        }
    }

    static class FloatOrNullSetter
    extends ParameterSetter {
        FloatOrNullSetter(Method method) {
            super(method, Integer.class, 13);
        }

        @Override
        Object getValue(Parameters properties) {
            String value = properties.getString(this.parameterName);
            value = value == null ? "" : value.trim();
            try {
                return value.isEmpty() ? null : Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new NoValidParameterException("Property \"" + this.parameterName + "\" is not a valid float value: \"" + value + "\"");
            }
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.STRING;
        }
    }

    static class DoubleOrNullSetter
    extends ParameterSetter {
        DoubleOrNullSetter(Method method) {
            super(method, Integer.class, 14);
        }

        @Override
        Object getValue(Parameters properties) {
            String value = properties.getString(this.parameterName);
            value = value == null ? "" : value.trim();
            try {
                return value.isEmpty() ? null : Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new NoValidParameterException("Property \"" + this.parameterName + "\" is not a valid double value: \"" + value + "\"");
            }
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.STRING;
        }
    }

    static class StringSetter
    extends ParameterSetter {
        StringSetter(Method method) {
            super(method, String.class, 100);
        }

        @Override
        Object getValue(Parameters properties) {
            return properties.getString(this.parameterName, null);
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.STRING;
        }
    }

    static class ColorSetter
    extends ParameterSetter {
        ColorSetter(Method method) {
            super(method, Color.class, 50);
        }

        @Override
        Object getValue(Parameters properties) {
            String color = properties.getString(this.parameterName, null);
            if (color == null) {
                return null;
            }
            try {
                return Color.decode(color);
            }
            catch (NumberFormatException e) {
                throw new NoValidParameterException("Property \"" + this.parameterName + "\" is not a valid color value while calling " + String.valueOf(this.method));
            }
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.STRING;
        }
    }

    static class EnumSetter
    extends ParameterSetter {
        private final Class<? extends Enum> enumClass;
        private final Method valueOfNameCustomMethod;

        EnumSetter(Method method, Class<?> enumClass) {
            super(method, enumClass, 10);
            assert (enumClass.isEnum());
            assert (Enum.class.isAssignableFrom(enumClass));
            this.enumClass = enumClass.asSubclass(Enum.class);
            EnumSetter.checkPublicAccessToEnumClass(this.enumClass);
            Method valueOfNameCustomMethod = null;
            try {
                valueOfNameCustomMethod = this.enumClass.getMethod("valueOfName", String.class);
                int methodModifiers = valueOfNameCustomMethod.getModifiers();
                if (!Modifier.isStatic(methodModifiers) || !Modifier.isPublic(methodModifiers)) {
                    throw new IllegalStateException("Method " + String.valueOf(valueOfNameCustomMethod) + " must be public static");
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.valueOfNameCustomMethod = valueOfNameCustomMethod;
        }

        @Override
        Object getValue(Parameters properties) {
            String enumName = properties.getString(this.parameterName);
            if (this.valueOfNameCustomMethod != null) {
                try {
                    return this.valueOfNameCustomMethod.invoke(null, enumName);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Cannot use " + String.valueOf(this.valueOfNameCustomMethod) + " in " + String.valueOf(this.method), e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof IllegalArgumentException) {
                        throw new NoValidParameterException("Cannot find enum " + enumName + " while calling " + String.valueOf(this.method), e.getCause());
                    }
                    throw new IllegalArgumentException("Cannot use " + String.valueOf(this.valueOfNameCustomMethod) + " in " + String.valueOf(this.method), e);
                }
            }
            try {
                return Enum.valueOf(this.enumClass, enumName);
            }
            catch (IllegalArgumentException e) {
                throw new NoValidParameterException("Cannot find enum " + enumName + " while calling " + String.valueOf(this.method), e);
            }
        }

        @Override
        ParameterValueType getControlValueType() {
            return ParameterValueType.ENUM_STRING;
        }

        private static void checkPublicAccessToEnumClass(Class<?> enumClass) {
            if (!Modifier.isPublic(enumClass.getModifiers())) {
                throw new IllegalStateException("Enum " + String.valueOf(enumClass) + " must be public");
            }
            Class<?> enclosingClass = enumClass.getEnclosingClass();
            if (enclosingClass != null && !Modifier.isPublic(enclosingClass.getModifiers())) {
                throw new IllegalStateException("Enum " + String.valueOf(enumClass) + " is an inner class of the " + String.valueOf(enclosingClass) + ", which must be public");
            }
        }
    }
}

