/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.node;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.node.NodeModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import com.siams.cv.monitor.model.property.PropertyModel;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UIBlockModel
extends NodeModel {
    private static Logger logger = Logger.getLogger(UIBlockModel.class);
    private static int DEFAULT_WIDTH = 300;
    private static int DEFAULT_HEIGHT = 200;
    private static int GRID_SIZE_FACTOR = 12;
    public static String id = "UIBlockModel";
    @JsonProperty(value="layout_x")
    private int layoutX;
    @JsonProperty(value="layout_y")
    private int layoutY;
    @JsonProperty(value="layout_width")
    private int layoutWidth = DEFAULT_WIDTH;
    @JsonProperty(value="layout_height")
    private int layoutHeight = DEFAULT_HEIGHT;
    @JsonProperty(value="caption")
    private String caption = "";
    @JsonProperty(value="comment")
    private String comment = "";
    @JsonProperty(value="worker_type")
    private UUID workerType;
    @JsonProperty(value="ports")
    private List<UIPortModel> portModels = new ArrayList<UIPortModel>();
    @JsonProperty(value="display_advanced")
    private Boolean displayAdvanced = false;
    @JsonProperty(value="properties")
    private List<PropertyModel> propertyModels = new ArrayList<PropertyModel>();

    @JsonCreator
    UIBlockModel() {
    }

    private UIBlockModel(UUID uuid, int layoutX, int layoutY) {
        this.uuid = uuid;
        this.layoutX = layoutX;
        this.layoutY = layoutY;
    }

    @JsonGetter(value="layout_x")
    public int getLayoutX() {
        return this.layoutX;
    }

    @JsonSetter(value="layout_x")
    public void setLayoutX(double layoutX) {
        this.layoutX = (int)layoutX;
    }

    @JsonGetter(value="layout_y")
    public int getLayoutY() {
        return this.layoutY;
    }

    @JsonSetter(value="layout_y")
    public void setLayoutY(double layoutY) {
        this.layoutY = (int)layoutY;
    }

    @JsonGetter(value="layout_width")
    public int getLayoutWidth() {
        return this.layoutWidth;
    }

    @JsonSetter(value="layout_width")
    public void setLayoutWidth(double layoutWidth) {
        this.layoutWidth = (int)layoutWidth;
    }

    @JsonGetter(value="layout_height")
    public int getLayoutHeight() {
        return this.layoutHeight;
    }

    @JsonSetter(value="layout_height")
    public void setLayoutHeight(double layoutHeight) {
        this.layoutHeight = (int)layoutHeight;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption != null ? this.caption : "";
    }

    @JsonSetter(value="caption")
    public void setCaption(String caption) {
        this.caption = caption != null ? caption : "";
    }

    @JsonSetter(value="custom_caption")
    @Deprecated
    private void setCustomCaption(String caption) {
        this.setCaption(caption);
    }

    @JsonGetter(value="comment")
    public String getComment() {
        return this.comment;
    }

    @JsonSetter(value="comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonSetter(value="custom_comment")
    @Deprecated
    private void setCustomComment(String comment) {
        this.setComment(comment);
    }

    @JsonGetter(value="worker_type")
    public UUID getWorkerType() {
        return this.workerType;
    }

    @JsonSetter(value="worker_type")
    public void setWorkerType(UUID workerType) {
        this.workerType = workerType;
    }

    @JsonGetter(value="ports")
    public List<UIPortModel> getPorts() {
        return this.portModels;
    }

    @JsonSetter(value="ports")
    public void setPorts(List<UIPortModel> portModels) {
        this.portModels = portModels;
    }

    @JsonGetter(value="display_advanced")
    public Boolean getDisplayAdvanced() {
        return this.displayAdvanced;
    }

    @JsonSetter(value="display_advanced")
    public void setDisplayAdvanced(Boolean displayAdvanced) {
        this.displayAdvanced = displayAdvanced;
    }

    public List<PropertyModel> getPropertyModels() {
        return this.propertyModels;
    }

    public void setPropertyModels(List<PropertyModel> propertyModels) {
        this.propertyModels = propertyModels;
    }

    @JsonIgnore
    public List<UIPortModel> getPorts(PortType portType) {
        return this.portModels.stream().filter(portModel -> portModel.getPortType().equals((Object)portType)).collect(Collectors.toList());
    }

    public void addPort(UIPortModel portModel) {
        this.portModels.add(portModel);
    }

    public Optional<UIPortModel> findPort(IIdentifiable iid) {
        return this.findPort(iid.getUuid());
    }

    public Optional<UIPortModel> findPort(UUID uuid) {
        return this.portModels.stream().filter(portModel -> portModel.getUuid().equals(uuid)).findFirst();
    }

    public Optional<UIPortModel> findPort(PortType portType, String name) {
        return this.portModels.stream().filter(portModel -> portModel.getPortType() == portType && portModel.getName().equals(name)).findFirst();
    }

    public boolean hasPort(IIdentifiable iid) {
        return this.hasPort(iid.getUuid());
    }

    public boolean hasPort(UUID uuid) {
        return this.portModels.stream().anyMatch(projectPort -> projectPort.getUuid().equals(uuid));
    }

    @JsonSetter(value="input_ports")
    private void setInputUIPortModels(List<UIPortModel> projectPorts) {
        this.portModels.addAll(projectPorts);
    }

    @JsonSetter(value="output_ports")
    private void setOutputUIPortModels(List<UIPortModel> projectPorts) {
        this.portModels.addAll(projectPorts);
    }

    @JsonSetter(value="input_control_ports")
    private void setInputControlUIPortModels(List<UIPortModel> projectPorts) {
        this.portModels.addAll(projectPorts);
    }

    @JsonSetter(value="output_control_ports")
    private void setOutputControlUIPortModels(List<UIPortModel> projectPorts) {
        this.portModels.addAll(projectPorts);
    }

    public void copyFrom(UIBlockModel from) {
        this.setCaption(from.getCaption());
        this.setComment(from.getComment());
        this.setLayoutX(from.getLayoutX());
        this.setLayoutY(from.getLayoutY());
        this.setLayoutWidth(from.getLayoutWidth());
        this.setLayoutHeight(from.getLayoutHeight());
        this.getPorts().forEach(portModel -> {
            if (portModel != null) {
                from.findPort(portModel.getPortType(), portModel.getName()).ifPresent(portModel::copyFrom);
            }
        });
    }

    @Override
    public void release() {
        this.portModels.forEach(UIPortModel::release);
        this.portModels.clear();
        this.propertyModels.clear();
    }

    public void filterPorts(Predicate<UIPortModel> predicate) {
        this.portModels = this.portModels.stream().filter(predicate).collect(Collectors.toList());
    }

    public String toString() {
        return "UIBlockModel{caption='" + this.caption + "', uuid=" + String.valueOf(this.uuid) + "}";
    }

    public void filterInvalidPorts() {
        this.portModels = this.portModels.stream().filter(uiPortModel -> {
            UUID portId = uiPortModel.getUuid();
            if (portId == null) {
                return false;
            }
            if (portId.getLeastSignificantBits() == 0L && portId.getMostSignificantBits() == 0L) {
                return false;
            }
            if (uiPortModel.getPortType() == null) {
                return false;
            }
            return !uiPortModel.getCaption().isEmpty() || !uiPortModel.getName().isEmpty();
        }).collect(Collectors.toList());
    }

    public static Optional<UIBlockModel> valueOf(String json) {
        Optional<UIBlockModel> opt = Optional.empty();
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject jWorker = reader.readObject();
            UUID workerId = UUID.fromString(jWorker.getString("id"));
            UUID executorId = UUID.fromString(jWorker.getString("executor_id"));
            String executorName = jWorker.getString("executor_name", "[unknown]");
            String systemName = jWorker.getString("system_name", "");
            UIBlockModel uiBlockModel = new Builder().setUuid(workerId).setModelType(executorId).setCaption(systemName.isEmpty() ? executorName : systemName).build();
            JsonArray jPorts = jWorker.getJsonArray("ports");
            for (int i = 0; i < jPorts.size(); ++i) {
                try {
                    JsonObject jPort = jPorts.getJsonObject(i);
                    UIPortModel uiPortModel = new UIPortModel.Builder().setUuid(UUID.fromString(jPort.getString("id"))).setPortType(jPort.getInt("type")).setDataTypeUuid(UUID.fromString(jPort.getString("data_type_id"))).setName(jPort.getString("name")).setCaption(jPort.getString("caption", "")).setOptional(jPort.getBoolean("is_optional", false)).build();
                    uiBlockModel.addPort(uiPortModel);
                    continue;
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("Failed parse worker port:\n%s", jPorts.toString()), t);
                }
            }
            opt = Optional.of(uiBlockModel);
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Failed parse worker:\n%s", json), t);
        }
        return opt;
    }

    @Override
    public String getRelUrl() {
        return String.format("/worker:%s", this.uuid);
    }

    public static int getPreferredWidth(int gridSize) {
        return gridSize * GRID_SIZE_FACTOR;
    }

    public static int getPreferredHeight(int gridSize) {
        return gridSize * GRID_SIZE_FACTOR;
    }

    public static class Builder {
        private UUID uuid;
        private UUID modelType;
        private String caption = "[unknown]";

        public Builder setUuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder setModelType(UUID modelType) {
            this.modelType = modelType;
            return this;
        }

        public Builder setCaption(String caption) {
            this.caption = caption;
            return this;
        }

        public UIBlockModel build() {
            UIBlockModel blockModel = new UIBlockModel();
            blockModel.setUuid(this.uuid);
            blockModel.setWorkerType(this.modelType);
            blockModel.setCaption(this.caption);
            return blockModel;
        }
    }
}

