/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.node.NodeModel;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.general.Deletable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@id")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NodeModel.class, name="NodeModel"), @JsonSubTypes.Type(value=ViewerModel.class, name="ViewerModel")})
public abstract class Model
implements IIdentifiable,
Deletable {
    @JsonProperty(value="uuid")
    protected UUID uuid = new UUID(0L, 0L);
    @JsonIgnore
    private List<ModelChangeListener> modelChangeListeners = new ArrayList<ModelChangeListener>();

    @Override
    @JsonGetter(value="uuid")
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
        this.invokeModelChangeListeners(this);
    }

    @JsonSetter(value="uuid")
    public void setUuid(String uuid) {
        this.setUuid(UUID.fromString(uuid));
    }

    protected void invokeModelChangeListeners(Model model) {
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listener.accept(model);
        }
    }

    public boolean addModelChangeListener(ModelChangeListener listener) {
        return this.modelChangeListeners.add(listener);
    }

    public boolean removeModelChangeListener(ModelChangeListener listener) {
        return this.modelChangeListeners.remove(listener);
    }

    public void release() {
        for (ModelChangeListener listener : this.modelChangeListeners) {
            Object var2_2 = null;
        }
        this.modelChangeListeners.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(UUID.class)) {
            return this.uuid.equals(obj);
        }
        if (IIdentifiable.class.isAssignableFrom(obj.getClass())) {
            IIdentifiable identifiable = (IIdentifiable)obj;
            return this.uuid.equals(identifiable.getUuid());
        }
        return false;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public static interface ModelChangeListener
    extends Consumer<Model> {
    }
}

