/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.common.recognition;

import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableByteArray;
import net.algart.math.IPoint;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.matrices.morphology.BasicRankMorphology;
import net.algart.matrices.morphology.ContinuedRankMorphology;
import net.algart.matrices.morphology.CustomRankPrecision;
import net.algart.matrices.morphology.RankMorphology;
import net.algart.matrices.morphology.RankPrecision;

public class BorderFinder {
    private int checkedLengthAlongBorderX = 100;
    private int checkedLengthAlongBorderY = 100;
    private int minLengthAlongBorder = 25;
    private int checkedSizeAtBackgroundX = 30;
    private int checkedSizeAtBackgroundY = 30;
    private double maxBrightnessVariationAlongBorder = 0.1568627450980392;
    private double minBrightnessDifferenceFromBackground = 0.1568627450980392;
    private double brightnessVariationAlongBorderCorrection = 0.0392156862745098;
    private double brightnessDifferenceFromBackgroundCorrection = 0.0392156862745098;
    private int sizeForSearchX = Integer.MAX_VALUE;
    private int sizeForSearchY = Integer.MAX_VALUE;
    private long leftTopEstimationX = 0L;
    private long leftTopEstimationY = 0L;
    private final Matrix<UpdatableByteArray> slide;
    private final long dimX;
    private final long dimY;
    private final byte[] slideBytes;
    private final int slideOfs;
    private Matrix<UpdatableByteArray> averaged = null;
    private long resultLeftTopX = -1L;
    private long resultLeftTopY = -1L;
    private double resultLeftTopQuality = Double.NaN;

    public BorderFinder(Matrix<? extends PArray> packedMacroImage) {
        Matrix packedSlide;
        if (packedMacroImage == null) {
            throw new NullPointerException("Null packed macro image");
        }
        this.slide = Arrays.SMM.newByteMatrix(new long[]{packedMacroImage.dim(1), packedMacroImage.dim(2)});
        this.dimX = this.slide.dimX();
        this.dimY = this.slide.dimY();
        if (packedMacroImage.elementType() != Byte.TYPE) {
            Range srcRange = Range.valueOf((double)0.0, (double)((PArray)packedMacroImage.array()).maxPossibleValue(1.0));
            Range destRange = Range.valueOf((double)0.0, (double)Arrays.maxPossibleValue(ByteArray.class, (double)1.0));
            packedMacroImage = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((Range)destRange, (Range)srcRange), ByteArray.class, packedMacroImage);
        }
        if (packedMacroImage.dimEquals(packedSlide = ((UpdatableByteArray)this.slide.array()).matrix(new long[]{1L, this.slide.dimX(), this.slide.dimY()}))) {
            Matrices.copy(null, (Matrix)packedSlide, (Matrix)packedMacroImage);
        } else {
            Matrices.resize(null, (Matrices.ResizingMethod)Matrices.ResizingMethod.AVERAGING, (Matrix)packedSlide, (Matrix)packedMacroImage);
        }
        DirectAccessible da = (DirectAccessible)this.slide.array();
        assert (da.hasJavaArray());
        assert (this.dimX == (long)((int)this.dimX));
        assert (this.dimY == (long)((int)this.dimY));
        this.slideBytes = (byte[])da.javaArray();
        this.slideOfs = da.javaArrayOffset();
    }

    public int getCheckedLengthAlongBorderX() {
        return this.checkedLengthAlongBorderX;
    }

    public void setCheckedLengthAlongBorderX(int checkedLengthAlongBorderX) {
        if (checkedLengthAlongBorderX <= 0) {
            throw new IllegalArgumentException("Negative or zero checkedLengthAtBorderX = " + checkedLengthAlongBorderX);
        }
        this.checkedLengthAlongBorderX = checkedLengthAlongBorderX;
    }

    public int getCheckedLengthAlongBorderY() {
        return this.checkedLengthAlongBorderY;
    }

    public void setCheckedLengthAlongBorderY(int checkedLengthAlongBorderY) {
        if (checkedLengthAlongBorderY <= 0) {
            throw new IllegalArgumentException("Negative or zero checkedLengthAtBorderY = " + checkedLengthAlongBorderY);
        }
        this.checkedLengthAlongBorderY = checkedLengthAlongBorderY;
    }

    public int getMinLengthAlongBorder() {
        return this.minLengthAlongBorder;
    }

    public void setMinLengthAlongBorder(int minLengthAlongBorder) {
        if (minLengthAlongBorder <= 0) {
            throw new IllegalArgumentException("Negative or zero minLengthAlongBorder = " + minLengthAlongBorder);
        }
        this.minLengthAlongBorder = minLengthAlongBorder;
    }

    public int getCheckedSizeAtBackgroundX() {
        return this.checkedSizeAtBackgroundX;
    }

    public void setCheckedSizeAtBackgroundX(int checkedSizeAtBackgroundX) {
        if (checkedSizeAtBackgroundX <= 0) {
            throw new IllegalArgumentException("Negative or zero checkedSizeAtBackgroundX = " + checkedSizeAtBackgroundX);
        }
        this.checkedSizeAtBackgroundX = checkedSizeAtBackgroundX;
    }

    public int getCheckedSizeAtBackgroundY() {
        return this.checkedSizeAtBackgroundY;
    }

    public void setCheckedSizeAtBackgroundY(int checkedSizeAtBackgroundY) {
        if (checkedSizeAtBackgroundY <= 0) {
            throw new IllegalArgumentException("Negative or zero checkedSizeAtBackgroundY = " + checkedSizeAtBackgroundY);
        }
        this.checkedSizeAtBackgroundY = checkedSizeAtBackgroundY;
    }

    public double getMaxBrightnessVariationAlongBorder() {
        return this.maxBrightnessVariationAlongBorder;
    }

    public void setMaxBrightnessVariationAlongBorder(double maxBrightnessVariationAlongBorder) {
        if (maxBrightnessVariationAlongBorder < 0.0) {
            throw new IllegalArgumentException("Negative maxBrightnessVariationAlongBorder = " + maxBrightnessVariationAlongBorder);
        }
        this.maxBrightnessVariationAlongBorder = maxBrightnessVariationAlongBorder;
    }

    public double getMinBrightnessDifferenceFromBackground() {
        return this.minBrightnessDifferenceFromBackground;
    }

    public void setMinBrightnessDifferenceFromBackground(double minBrightnessDifferenceFromBackground) {
        if (minBrightnessDifferenceFromBackground < 0.0) {
            throw new IllegalArgumentException("Negative minBrightnessDifferenceFromBackground = " + minBrightnessDifferenceFromBackground);
        }
        this.minBrightnessDifferenceFromBackground = minBrightnessDifferenceFromBackground;
    }

    public double getBrightnessVariationAlongBorderCorrection() {
        return this.brightnessVariationAlongBorderCorrection;
    }

    public void setBrightnessVariationAlongBorderCorrection(double brightnessVariationAlongBorderCorrection) {
        this.brightnessVariationAlongBorderCorrection = brightnessVariationAlongBorderCorrection;
    }

    public double getBrightnessDifferenceFromBackgroundCorrection() {
        return this.brightnessDifferenceFromBackgroundCorrection;
    }

    public void setBrightnessDifferenceFromBackgroundCorrection(double brightnessDifferenceFromBackgroundCorrection) {
        this.brightnessDifferenceFromBackgroundCorrection = brightnessDifferenceFromBackgroundCorrection;
    }

    public int getSizeForSearchX() {
        return this.sizeForSearchX;
    }

    public void setSizeForSearchX(int sizeForSearchX) {
        if (this.sizeForSearchY < 0) {
            throw new IllegalArgumentException("Negative sizeForSearchY");
        }
        this.sizeForSearchX = sizeForSearchX;
    }

    public int getSizeForSearchY() {
        return this.sizeForSearchY;
    }

    public void setSizeForSearchY(int sizeForSearchY) {
        if (this.sizeForSearchX < 0) {
            throw new IllegalArgumentException("Negative sizeForSearchX");
        }
        this.sizeForSearchY = sizeForSearchY;
    }

    public void setAllConfigurationFromSystemProperties() {
        String s = System.getProperty(BorderFinder.class.getName() + ".checkedLengthAlongBorderX");
        if (s != null) {
            this.setCheckedLengthAlongBorderX(Integer.parseInt(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".checkedLengthAlongBorderY")) != null) {
            this.setCheckedLengthAlongBorderY(Integer.parseInt(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".minLengthAlongBorder")) != null) {
            this.setMinLengthAlongBorder(Integer.parseInt(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".checkedSizeAtBackgroundX")) != null) {
            this.setCheckedSizeAtBackgroundX(Integer.parseInt(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".checkedSizeAtBackgroundY")) != null) {
            this.setCheckedSizeAtBackgroundY(Integer.parseInt(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".maxBrightnessVariationAlongBorder")) != null) {
            this.setMaxBrightnessVariationAlongBorder(Double.parseDouble(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".minBrightnessDifferenceFromBackground")) != null) {
            this.setMinBrightnessDifferenceFromBackground(Double.parseDouble(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".brightnessVariationAlongBorderCorrection")) != null) {
            this.setBrightnessVariationAlongBorderCorrection(Double.parseDouble(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".brightnessDifferenceFromBackgroundCorrection")) != null) {
            this.setBrightnessDifferenceFromBackgroundCorrection(Double.parseDouble(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".sizeForSearchX")) != null) {
            this.setSizeForSearchX(Integer.parseInt(s));
        }
        if ((s = System.getProperty(BorderFinder.class.getName() + ".sizeForSearchY")) != null) {
            this.setSizeForSearchY(Integer.parseInt(s));
        }
    }

    public Matrix<UpdatableByteArray> getSlide() {
        return this.slide;
    }

    public Matrix<UpdatableByteArray> getAveraged() {
        return this.averaged;
    }

    public long getResultLeftTopX() {
        return this.resultLeftTopX;
    }

    public long getResultLeftTopY() {
        return this.resultLeftTopY;
    }

    public double getResultLeftTopQuality() {
        return this.resultLeftTopQuality;
    }

    public long getLeftTopEstimationX() {
        return this.leftTopEstimationX;
    }

    public long getLeftTopEstimationY() {
        return this.leftTopEstimationY;
    }

    public void setLeftTopEstimation(long x, long y) {
        this.leftTopEstimationX = x;
        this.leftTopEstimationY = y;
    }

    public long getDimX() {
        return this.dimX;
    }

    public long getDimY() {
        return this.dimY;
    }

    public void preprocess() {
        this.averaged = Arrays.SMM.newByteMatrix(new long[]{this.dimX, this.dimY});
        ContinuedRankMorphology morphology = ContinuedRankMorphology.getInstance((RankMorphology)BasicRankMorphology.getInstance(null, (double)0.5, (CustomRankPrecision)RankPrecision.BITS_8), (Matrix.ContinuationMode)Matrix.ContinuationMode.MIRROR_CYCLIC);
        IPoint min = IPoint.valueOf((long)((long)(-this.checkedSizeAtBackgroundX) / 2L), (long)((long)(-this.checkedSizeAtBackgroundY) / 2L));
        IPoint max = min.add(IPoint.valueOf((long)((long)this.checkedSizeAtBackgroundX - 1L), (long)((long)this.checkedSizeAtBackgroundY - 1L)));
        morphology.dilation(this.averaged, this.slide, (Pattern)Patterns.newRectangularIntegerPattern((IPoint)min, (IPoint)max));
    }

    public boolean findLeftTop() {
        if (!this.readyToProcess()) {
            throw new IllegalStateException("Preprocessing was not performed");
        }
        long minX = Math.max(0L, this.leftTopEstimationX - (long)(this.sizeForSearchX / 2));
        long minY = Math.max(0L, this.leftTopEstimationY - (long)(this.sizeForSearchY / 2));
        long maxX = Math.min(this.dimX - 1L - (long)this.checkedLengthAlongBorderX, this.leftTopEstimationX + (long)(this.sizeForSearchX / 2));
        long maxY = Math.min(this.dimY - 1L - (long)this.checkedLengthAlongBorderY, this.leftTopEstimationY + (long)(this.sizeForSearchY / 2));
        double bestQuality = Double.NaN;
        long bestX = -1L;
        long bestY = -1L;
        for (long y = minY; y <= maxY; ++y) {
            for (long x = minX; x <= maxX; ++x) {
                double q = this.leftTopQuality(x, y);
                if (Double.isNaN(q) || !Double.isNaN(bestQuality) && !(q > bestQuality)) continue;
                bestQuality = q;
                bestX = x;
                bestY = y;
            }
        }
        this.resultLeftTopQuality = bestQuality;
        this.resultLeftTopX = bestX;
        this.resultLeftTopY = bestY;
        if (!Double.isNaN(bestQuality)) {
            this.leftTopQuality(bestX, bestY);
        }
        return !Double.isNaN(bestQuality);
    }

    public Matrix<UpdatableByteArray> findAllLeftTopQualities(double multiplier) {
        if (!this.readyToProcess()) {
            throw new IllegalStateException("Preprocessing was not performed");
        }
        int minX = (int)Math.max(0L, this.leftTopEstimationX - (long)(this.sizeForSearchX / 2));
        int minY = (int)Math.max(0L, this.leftTopEstimationY - (long)(this.sizeForSearchY / 2));
        int maxX = (int)Math.min(this.dimX - 1L - (long)this.checkedLengthAlongBorderX, this.leftTopEstimationX + (long)(this.sizeForSearchX / 2));
        int maxY = (int)Math.min(this.dimY - 1L - (long)this.checkedLengthAlongBorderY, this.leftTopEstimationY + (long)(this.sizeForSearchY / 2));
        byte[] result = new byte[(int)(this.dimX * this.dimY)];
        JArrays.fill((byte[])result, (byte)-128);
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                int ofs = y * (int)this.dimX + x;
                double q = this.leftTopQuality(x, y);
                if (Double.isNaN(q)) {
                    result[ofs] = 0;
                    continue;
                }
                assert (q <= 0.0);
                result[ofs] = (byte)Math.max(0.0, 255.0 + q * multiplier);
            }
        }
        return SimpleMemoryModel.asUpdatableByteArray((byte[])result).matrix(new long[]{this.dimX, this.dimY});
    }

    public Matrix<UpdatableByteArray> drawResultLeftTopOnSlide(double color) {
        byte[] result = new byte[(int)(this.dimX * this.dimY)];
        ((UpdatableByteArray)this.slide.array()).getData(0L, (Object)result);
        if (!Double.isNaN(this.resultLeftTopQuality)) {
            int th = 20;
            long resultIndex = this.slide.index(this.resultLeftTopX, this.resultLeftTopY);
            int minOrtogonalX = (int)Math.max(0L, this.resultLeftTopX - 20L);
            int minOrtogonalY = (int)Math.max(0L, this.resultLeftTopY - 20L);
            int maxOrtogonalX = (int)Math.min(this.dimX - 1L, this.resultLeftTopX + 20L);
            int maxOrtogonalY = (int)Math.min(this.dimY - 1L, this.resultLeftTopY + 20L);
            int toX = (int)Math.min(this.resultLeftTopX + (long)this.checkedLengthAlongBorderX, this.dimX - 1L);
            int x = (int)this.resultLeftTopX;
            int ofs = (int)((long)this.slideOfs + resultIndex);
            while (x < toX) {
                for (int y = minOrtogonalY; y <= maxOrtogonalY; ++y) {
                    long dy = (long)y - this.resultLeftTopY;
                    result[ofs + (int)(dy * this.dimX)] = (byte)(color * 255.0 * (double)(20L - Math.abs(dy)) / 20.0);
                }
                ++x;
                ++ofs;
            }
            int toY = (int)Math.min(this.resultLeftTopY + (long)this.checkedLengthAlongBorderY, this.dimY - 1L);
            int ofs2 = (int)((long)this.slideOfs + resultIndex);
            for (int y = (int)this.resultLeftTopY; y < toY; ++y) {
                for (int x2 = minOrtogonalX; x2 <= maxOrtogonalX; ++x2) {
                    long dx = (long)x2 - this.resultLeftTopX;
                    result[ofs2 + (int)dx] = (byte)(color * 255.0 * (double)(20L - Math.abs(dx)) / 20.0);
                }
                ofs2 = (int)((long)ofs2 + this.dimX);
            }
        }
        return SimpleMemoryModel.asUpdatableByteArray((byte[])result).matrix(new long[]{this.dimX, this.dimY});
    }

    private boolean readyToProcess() {
        return this.averaged != null;
    }

    private double leftTopQuality(long checkedX, long checkedY) {
        int v;
        int y;
        int v2;
        assert (checkedX >= 0L && checkedX < this.dimX);
        assert (checkedY >= 0L && checkedY < this.dimY);
        assert (checkedX == (long)((int)checkedX));
        assert (checkedY == (long)((int)checkedY));
        long checkedIndex = this.slide.index(checkedX, checkedY);
        int cornerByte = ((UpdatableByteArray)this.slide.array()).getByte(checkedIndex);
        double corner = (double)cornerByte / 255.0;
        int averagedOutsideByte = ((UpdatableByteArray)this.averaged.array()).getByte(this.averaged.index(Math.max(0L, checkedX - (long)(this.checkedSizeAtBackgroundX / 2 + 2)), Math.max(0L, checkedY - (long)(this.checkedSizeAtBackgroundY / 2 + 2))));
        double averageOutside = (double)averagedOutsideByte / 255.0;
        int averagedInsideByte = ((UpdatableByteArray)this.averaged.array()).getByte(this.averaged.index(Math.min(this.dimX - 1L, checkedX + (long)(this.checkedSizeAtBackgroundX / 2 + 2)), Math.min(this.dimY - 1L, checkedY + (long)(this.checkedSizeAtBackgroundY / 2 + 2))));
        double averageInside = (double)averagedInsideByte / 255.0;
        double differenceFromBackground = Math.min(Math.abs(corner - averageOutside), Math.abs(corner - averageInside));
        if (differenceFromBackground < this.minBrightnessDifferenceFromBackground) {
            return Double.NaN;
        }
        int min = cornerByte;
        int max = cornerByte;
        int minToX = (int)Math.min(checkedX + (long)this.minLengthAlongBorder, this.dimX - 1L);
        int toX = (int)Math.min(checkedX + (long)this.checkedLengthAlongBorderX, this.dimX - 1L);
        int x = (int)checkedX;
        int ofs = (int)((long)this.slideOfs + checkedIndex);
        while (x < toX) {
            v2 = this.slideBytes[ofs] & 0xFF;
            if (Math.abs(v2 - averagedOutsideByte) < Math.abs(v2 - cornerByte)) {
                toX = Math.max((int)((checkedX + (long)x) / 2L), minToX);
                break;
            }
            ++x;
            ++ofs;
        }
        x = (int)checkedX;
        ofs = (int)((long)this.slideOfs + checkedIndex);
        while (x < toX) {
            v2 = this.slideBytes[ofs] & 0xFF;
            min = min <= v2 ? min : v2;
            max = max >= v2 ? max : v2;
            ++x;
            ++ofs;
        }
        int minToY = (int)Math.min(checkedY + (long)this.minLengthAlongBorder, this.dimY - 1L);
        int toY = (int)Math.min(checkedY + (long)this.checkedLengthAlongBorderY, this.dimY - 1L);
        int ofs2 = (int)((long)this.slideOfs + checkedIndex);
        for (y = (int)checkedY; y < toY; ++y) {
            v = this.slideBytes[ofs2] & 0xFF;
            if (Math.abs(v - averagedOutsideByte) < Math.abs(v - cornerByte)) {
                toY = Math.max((int)((checkedY + (long)y) / 2L), minToY);
                break;
            }
            ofs2 = (int)((long)ofs2 + this.dimX);
        }
        ofs2 = (int)((long)this.slideOfs + checkedIndex);
        for (y = (int)checkedY; y < toY; ++y) {
            v = this.slideBytes[ofs2] & 0xFF;
            min = min <= v ? min : v;
            max = max >= v ? max : v;
            ofs2 = (int)((long)ofs2 + this.dimX);
        }
        double variationAlongBorder = (double)(max - min) / 255.0;
        if (variationAlongBorder > this.maxBrightnessVariationAlongBorder) {
            return Double.NaN;
        }
        return -(variationAlongBorder + this.brightnessVariationAlongBorderCorrection) / (differenceFromBackground + this.brightnessDifferenceFromBackgroundCorrection);
    }
}

