/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.api.sources;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ByteArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatablePArray;
import net.algart.io.awt.MatrixToImage;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public class ScalablePlanePyramidSource
implements PlanePyramidSource {
    static final int TIME_ENFORCING_GC = Arrays.SystemSettings.getIntProperty((String)"net.algart.maps.pyramids.io.api.timeEnforcingGc", (int)0);
    private static final System.Logger LOG = System.getLogger(ScalablePlanePyramidSource.class.getName());
    private final PlanePyramidSource parent;
    private final int numberOfResolutions;
    private final List<long[]> dimensions;
    private final long dimX;
    private final long dimY;
    private final int compression;
    private final int bandCount;
    private Class<?> elementType = null;
    private final Object elementTypeLock = new Object();
    private volatile PlanePyramidSource.AveragingMode averagingMode = PlanePyramidSource.AveragingMode.DEFAULT;
    private volatile Color backgroundColor = new Color(255, 255, 255, 0);
    private final SpeedInfo pyramidSourceSpeedInfo = new SpeedInfo();
    private final SpeedInfo readImageSpeedInfo = new SpeedInfo();
    private final SpeedInfo readBufferedImageSpeedInfo = new SpeedInfo();

    private ScalablePlanePyramidSource(PlanePyramidSource parent) {
        Objects.requireNonNull(parent, "Null parent source");
        this.parent = parent;
        int n = parent.numberOfResolutions();
        for (int level = 0; level < n; ++level) {
            if (this.parent.isResolutionLevelAvailable(level)) continue;
            throw new IllegalArgumentException("Pyramid source must contain all resolution levels, but there is no level #" + level);
        }
        this.compression = parent.compression();
        this.numberOfResolutions = parent.numberOfResolutions();
        this.bandCount = parent.bandCount();
        this.dimensions = new ArrayList<long[]>();
        for (int k = 0; k < this.numberOfResolutions; ++k) {
            this.dimensions.add(parent.dimensions(k));
        }
        this.dimX = this.dimensions.get(0)[1];
        this.dimY = this.dimensions.get(0)[2];
    }

    public static ScalablePlanePyramidSource newInstance(PlanePyramidSource parent) {
        return new ScalablePlanePyramidSource(parent);
    }

    @Override
    public int numberOfResolutions() {
        return this.numberOfResolutions;
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public boolean isResolutionLevelAvailable(int resolutionLevel) {
        return true;
    }

    @Override
    public boolean[] getResolutionLevelsAvailability() {
        boolean[] result = new boolean[this.numberOfResolutions()];
        JArrays.fill((boolean[])result, (boolean)true);
        return result;
    }

    @Override
    public long[] dimensions(int resolutionLevel) {
        return (long[])this.dimensions.get(resolutionLevel).clone();
    }

    @Override
    public long dim(int resolutionLevel, int index) {
        return this.dimensions.get(resolutionLevel)[index];
    }

    @Override
    public boolean isElementTypeSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> elementType() {
        Object object = this.elementTypeLock;
        synchronized (object) {
            Class elementType = this.elementType;
            if (elementType == null) {
                if (this.parent.isElementTypeSupported()) {
                    elementType = this.parent.elementType();
                    this.elementType = elementType;
                } else {
                    this.elementType = elementType = this.parent.readSubMatrix(0, 0L, 0L, 1L, 1L).elementType();
                }
            }
            return elementType;
        }
    }

    @Override
    public OptionalDouble pixelSizeInMicrons() {
        return this.parent.pixelSizeInMicrons();
    }

    @Override
    public OptionalDouble magnification() {
        return this.parent.magnification();
    }

    @Override
    public List<IRectangularArea> zeroLevelActualRectangles() {
        return this.parent.zeroLevelActualRectangles();
    }

    @Override
    public List<List<List<IPoint>>> zeroLevelActualAreaBoundaries() {
        return this.parent.zeroLevelActualAreaBoundaries();
    }

    @Override
    public Matrix<? extends PArray> readSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) {
        return (ScalablePlanePyramidSource)this.new SubMatrixExtracting((int)resolutionLevel, (long)fromX, (long)fromY, (long)toX, (long)toY).extractSubMatrix().fullData;
    }

    @Override
    public boolean isFullMatrixSupported() {
        return this.parent.isFullMatrixSupported();
    }

    @Override
    public Matrix<? extends PArray> readFullMatrix(int resolutionLevel) {
        if (!this.isFullMatrixSupported()) {
            throw new UnsupportedOperationException("readFullMatrix method is not supported");
        }
        return this.parent.readFullMatrix(resolutionLevel);
    }

    @Override
    public boolean isSpecialMatrixSupported(PlanePyramidSource.SpecialImageKind kind) {
        return this.parent.isSpecialMatrixSupported(kind);
    }

    @Override
    public Optional<Matrix<? extends PArray>> readSpecialMatrix(PlanePyramidSource.SpecialImageKind kind) {
        return this.parent.readSpecialMatrix(kind);
    }

    @Override
    public boolean isDataReady() {
        return this.parent.isDataReady();
    }

    @Override
    public int compression() {
        return this.compression;
    }

    public PlanePyramidSource parent() {
        return this.parent;
    }

    public long dimX() {
        return this.dimX;
    }

    public long dimY() {
        return this.dimY;
    }

    public PlanePyramidSource.AveragingMode getAveragingMode() {
        return this.averagingMode;
    }

    public ScalablePlanePyramidSource setAveragingMode(PlanePyramidSource.AveragingMode averagingMode) {
        if (averagingMode == null) {
            throw new NullPointerException("Null averaging mode");
        }
        this.averagingMode = averagingMode;
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public ScalablePlanePyramidSource setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new NullPointerException("Null background color");
        }
        this.backgroundColor = backgroundColor;
        return this;
    }

    public void forceAveragingBits() {
        if (this.averagingMode == PlanePyramidSource.AveragingMode.DEFAULT) {
            this.averagingMode = PlanePyramidSource.AveragingMode.AVERAGING;
        }
    }

    public double compression(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Negative level");
        }
        double c = 1.0;
        for (int k = 0; k < level; ++k) {
            c *= (double)this.compression;
        }
        return c;
    }

    public int maxLevel(double compression) {
        if (compression < 1.0) {
            throw new IllegalArgumentException("Compression must not be less than 1.0");
        }
        int level = 0;
        for (double c = (double)this.compression; c <= compression; c *= (double)this.compression) {
            ++level;
        }
        return level;
    }

    @Override
    public Optional<String> metadata() {
        return this.parent.metadata();
    }

    @Override
    public void loadResources() {
        this.parent.loadResources();
    }

    @Override
    public void freeResources(PlanePyramidSource.FlushMode flushMode) {
        this.parent.freeResources(flushMode);
    }

    public Matrix<? extends PArray> readImage(double compression, long zeroLevelFromX, long zeroLevelFromY, long zeroLevelToX, long zeroLevelToY) {
        ScalablePlanePyramidSource.checkFromAndTo(zeroLevelFromX, zeroLevelFromY, zeroLevelToX, zeroLevelToY);
        long t1 = System.nanoTime();
        int level = Math.min(this.maxLevel(compression), this.numberOfResolutions - 1);
        ImageScaling scaling = new ImageScaling(level, compression, zeroLevelFromX, zeroLevelFromY, zeroLevelToX, zeroLevelToY);
        long t2 = System.nanoTime();
        Matrix<? extends PArray> result = scaling.scaleImage();
        long t3 = System.nanoTime();
        String averageSpeed = this.readImageSpeedInfo.update(Matrices.sizeOf(result), t3 - t1, true);
        Runtime runtime = Runtime.getRuntime();
        LOG.log(System.Logger.Level.DEBUG, scaling::scaleImageTiming);
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "%s has read image (%d-bit, %d CPU for AlgART, used memory %.3f/%.3f MB, compression %.2f): %d..%d x %d..%d (%d x %d%s) in %.3f ms (%.3f init + %.3f scaled reading), %.3f MB/sec, average %s (source: %s)", ScalablePlanePyramidSource.class.getSimpleName(), Arrays.SystemSettings.isJava32() ? 32 : 64, Arrays.SystemSettings.cpuCount(), (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0, (double)runtime.maxMemory() / 1048576.0, compression, zeroLevelFromX, zeroLevelToX, zeroLevelFromY, zeroLevelToY, zeroLevelToX - zeroLevelFromX, zeroLevelToY - zeroLevelFromY, Arrays.isNCopies((Array)result.array()) ? ", CONSTANT" : "", (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)Matrices.sizeOf((Matrix)result) / 1048576.0 / ((double)(t3 - t1) * 1.0E-9), averageSpeed, this.parent.getClass().getSimpleName()));
        return result;
    }

    public BufferedImage readBufferedImage(double compression, long zeroLevelFromX, long zeroLevelFromY, long zeroLevelToX, long zeroLevelToY, MatrixToImage converter) {
        Objects.requireNonNull(converter, "Null converter");
        ScalablePlanePyramidSource.checkFromAndTo(zeroLevelFromX, zeroLevelFromY, zeroLevelToX, zeroLevelToY);
        long t1 = System.nanoTime();
        int level = Math.min(this.maxLevel(compression), this.numberOfResolutions - 1);
        ImageScaling scaling = new ImageScaling(level, compression, zeroLevelFromX, zeroLevelFromY, zeroLevelToX, zeroLevelToY);
        long t2 = System.nanoTime();
        Matrix m = scaling.scaleImage();
        long t3 = System.nanoTime();
        if (!converter.elementTypeSupported(m.elementType())) {
            double max = ((PArray)m.array()).maxPossibleValue(1.0);
            m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{255.0 / max}), ByteArray.class, m);
        }
        if (m.isEmpty()) {
            m = m.subMatr(0L, 0L, 0L, m.dim(0), Math.max(1L, m.dim(1)), Math.max(1L, m.dim(2)), Matrix.ContinuationMode.ZERO_CONSTANT);
        }
        int width = converter.dimX(m);
        int height = converter.dimY(m);
        Collection<IRectangularArea> backgroundAreas = this.getBackgroundAreasInRectangle(zeroLevelFromX, zeroLevelFromY, zeroLevelToX, zeroLevelToY);
        DataBuffer dataBuffer = converter.toDataBuffer(m);
        if (!backgroundAreas.isEmpty()) {
            IPoint shift = IPoint.valueOf((long)(-zeroLevelFromX), (long)(-zeroLevelFromY));
            for (int bankIndex = 0; bankIndex < dataBuffer.getNumBanks(); ++bankIndex) {
                Matrix bankMatrix = Matrices.matrix((Array)((UpdatablePArray)SimpleMemoryModel.asUpdatableArray((Object)MatrixToImage.dataArray((DataBuffer)dataBuffer, (int)bankIndex))), (long[])new long[]{width, height});
                long filler = converter.colorValue(m, this.backgroundColor, bankIndex);
                for (IRectangularArea a : backgroundAreas) {
                    this.fillBackgroundInMatrix2DWithCompression((Matrix<? extends UpdatablePArray>)bankMatrix, a, shift, compression, level == 0, scaling.needAdditionalCompression, filler);
                }
            }
        }
        BufferedImage bufferedImage = converter.toBufferedImage(m, dataBuffer);
        long t4 = System.nanoTime();
        long sizeOfMatrix = Matrices.sizeOf((Matrix)m);
        String averageSpeed = this.readBufferedImageSpeedInfo.update(sizeOfMatrix, t4 - t1, true);
        Runtime runtime = Runtime.getRuntime();
        LOG.log(System.Logger.Level.DEBUG, scaling::scaleImageTiming);
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "%s has read buffered image (%d-bit, %d CPU for AlgART, used memory %.3f/%.3f MB, compression %.2f): %d..%d x %d..%d (%d x %d) in %.3f ms (%.3f init + %.3f scaled reading + %.3f conversion), %.3f MB/sec, average %s (source: %s)", ScalablePlanePyramidSource.class.getSimpleName(), Arrays.SystemSettings.isJava32() ? 32 : 64, Arrays.SystemSettings.cpuCount(), (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0, (double)runtime.maxMemory() / 1048576.0, compression, zeroLevelFromX, zeroLevelToX, zeroLevelFromY, zeroLevelToY, zeroLevelToX - zeroLevelFromX, zeroLevelToY - zeroLevelFromY, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)sizeOfMatrix / 1048576.0 / ((double)(t4 - t1) * 1.0E-9), averageSpeed, this.parent.getClass().getSimpleName()));
        return bufferedImage;
    }

    public String toString() {
        return "ScalablePlanePyramid " + this.bandCount + "x" + this.dimX() + "x" + this.dimY() + ", " + this.numberOfResolutions + " levels, compression " + this.compression + ", based on " + String.valueOf(this.parent);
    }

    private Matrix<? extends PArray> callAndCheckParentReadSubMatrix(int resolutionLevel, long fromX, long fromY, long toX, long toY) {
        long t1 = System.nanoTime();
        Matrix<? extends PArray> m = this.parent.readSubMatrix(resolutionLevel, fromX, fromY, toX, toY);
        long t2 = System.nanoTime();
        if (m == null || m.dimCount() != 3 || m.dim(0) != (long)this.bandCount || m.dim(1) != toX - fromX || m.dim(2) != toY - fromY) {
            throw new AssertionError((Object)("Invalid implementation of " + String.valueOf(this.parent.getClass()) + ".readSubMatrix (fromX = " + fromX + ", fromY = " + fromY + ", toX = " + toX + ", toY = " + toY + "): incorrect dimensions of the returned matrix " + String.valueOf(m)));
        }
        String averageSpeed = this.pyramidSourceSpeedInfo.update(Matrices.sizeOf(m), t2 - t1);
        LOG.log(System.Logger.Level.DEBUG, () -> String.format(Locale.US, "%s.callAndCheckParentReadSubMatrix timing (level %d, %d..%d x %d..%d (%d x %d%s): %.3f ms, %.3f MB/sec, average %s (source: %s)", ScalablePlanePyramidSource.class.getSimpleName(), resolutionLevel, fromX, toX, fromY, toY, toX - fromX, toY - fromY, Arrays.isNCopies((Array)m.array()) ? ", CONSTANT" : "", (double)(t2 - t1) * 1.0E-6, (double)Matrices.sizeOf((Matrix)m) / 1048576.0 / ((double)(t2 - t1) * 1.0E-9), averageSpeed, this.parent.getClass().getSimpleName()));
        return m;
    }

    private Matrix<UpdatablePArray> newResultMatrix(Class<?> elementType, long dimX, long dimY) {
        Matrix result = Arrays.SMM.newMatrix(Arrays.SystemSettings.maxTempJavaMemory(), UpdatablePArray.class, elementType, new long[]{this.bandCount(), dimX, dimY});
        if (!SimpleMemoryModel.isSimpleArray((Array)result.array())) {
            result = result.tile(new long[]{result.dim(0), 1024L, 1024L});
        }
        return result;
    }

    private Collection<IRectangularArea> getBackgroundAreasInRectangle(long zeroLevelFromX, long zeroLevelFromY, long zeroLevelToX, long zeroLevelToY) {
        ArrayList<IRectangularArea> result = new ArrayList<IRectangularArea>();
        if (zeroLevelToX <= zeroLevelFromX || zeroLevelToY <= zeroLevelFromY) {
            return result;
        }
        IRectangularArea area = IRectangularArea.valueOf((IPoint)IPoint.valueOf((long)zeroLevelFromX, (long)zeroLevelFromY), (IPoint)IPoint.valueOf((long)(zeroLevelToX - 1L), (long)(zeroLevelToY - 1L)));
        IRectangularArea allArea = IRectangularArea.valueOf((IPoint)IPoint.valueOf((long)0L, (long)0L), (IPoint)IPoint.valueOf((long)(this.dimX - 1L), (long)(this.dimY - 1L)));
        area.difference(result, allArea);
        return result;
    }

    private void fillBackgroundInMatrix2DWithCompression(Matrix<? extends UpdatablePArray> filledMatrix, IRectangularArea filledArea, IPoint shift, double compression, boolean compressionFromZeroLevel, boolean dataWasScaled, long filler) {
        double deltaFrom;
        boolean powerOfTwo;
        if (filledMatrix == null) {
            throw new NullPointerException("Null filled matrix");
        }
        if (filledArea == null) {
            throw new NullPointerException("Null filled area");
        }
        if (shift == null) {
            throw new NullPointerException("Null shift");
        }
        if (filledMatrix.dimCount() != 2) {
            throw new IllegalArgumentException("The filled matrix must be 2-dimensional");
        }
        if (filledArea.coordCount() != 2) {
            throw new IllegalArgumentException("The filled area must be 2-dimensional");
        }
        filledArea = filledArea.shift(shift);
        long c = (long)compression;
        boolean integerCompression = (double)c == compression;
        boolean bl = powerOfTwo = integerCompression && (c & c - 1L) == 0L && (this.compression & this.compression - 1) == 0;
        double d = powerOfTwo ? 0.0 : (deltaFrom = compressionFromZeroLevel ? 1.0E-6 : 1.000001);
        double deltaTo = powerOfTwo ? 0.0 : (compressionFromZeroLevel ? 1.0E-6 : 2.000001);
        double shiftDeltaX = integerCompression ? 0.0 : 1.0;
        double shiftDeltaY = integerCompression ? 0.0 : 1.0;
        long fromX = (long)Math.floor((double)filledArea.min(0) / compression - deltaFrom - shiftDeltaX);
        long fromY = (long)Math.floor((double)filledArea.min(1) / compression - deltaFrom - shiftDeltaY);
        long toX = (long)Math.ceil((double)(filledArea.max(0) + 1L) / compression + deltaTo + shiftDeltaX);
        long toY = (long)Math.ceil((double)(filledArea.max(1) + 1L) / compression + deltaTo + shiftDeltaY);
        ((UpdatablePArray)filledMatrix.subMatrix(fromX, fromY, toX, toY, Matrix.ContinuationMode.NULL_CONSTANT).array()).fill(filler);
    }

    private static void checkFromAndTo(long fromX, long fromY, long toX, long toY) {
        if (fromX > toX || fromY > toY) {
            throw new IndexOutOfBoundsException("Illegal fromX..toX=" + fromX + ".." + toX + " or fromY..toY=" + fromY + ".." + toY + ": must be fromX<=toX, fromY<=toY");
        }
    }

    static class SpeedInfo {
        double totalMemory = 0.0;
        double elapsedTime = 0.0;
        long lastGcTime = System.currentTimeMillis();

        SpeedInfo() {
        }

        public String update(long memory, long time) {
            return this.update(memory, time, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String update(long memory, long time, boolean enforceGc) {
            String result;
            boolean doGc = false;
            SpeedInfo speedInfo = this;
            synchronized (speedInfo) {
                this.totalMemory += (double)memory;
                this.elapsedTime += (double)time;
                long t = System.currentTimeMillis();
                if (enforceGc) {
                    boolean bl = doGc = TIME_ENFORCING_GC > 0 && t - this.lastGcTime > (long)TIME_ENFORCING_GC;
                    if (doGc) {
                        this.lastGcTime = t;
                    }
                }
                result = String.format(Locale.US, "%.1f MB / %.3f sec = %.3f MB/sec%s", this.totalMemory / 1048576.0, this.elapsedTime * 1.0E-9, this.totalMemory / 1048576.0 / (this.elapsedTime * 1.0E-9), doGc ? " [GC enforced by " + String.valueOf(this) + "]" : "");
            }
            if (doGc) {
                System.gc();
            }
            return result;
        }
    }

    private class SubMatrixExtracting {
        final int level;
        final long levelDimX;
        final long levelDimY;
        final long levelFromX;
        final long levelFromY;
        final long levelToX;
        final long levelToY;
        final long actualFromX;
        final long actualFromY;
        final long actualToX;
        final long actualToY;
        final boolean allDataActual;
        Matrix<? extends PArray> fullData = null;
        Matrix<? extends PArray> actualData = null;

        SubMatrixExtracting(int level, long levelFromX, long levelFromY, long levelToX, long levelToY) {
            if (levelFromX > levelToX) {
                throw new IndexOutOfBoundsException("fromX = " + levelFromX + " > toX = " + levelToX);
            }
            if (levelFromY > levelToY) {
                throw new IndexOutOfBoundsException("fromY = " + levelFromY + " > toY = " + levelToY);
            }
            if (levelFromX < -2305843009213693951L || levelToX > 0x1FFFFFFFFFFFFFFFL - (long)ScalablePlanePyramidSource.this.compression) {
                throw new IllegalArgumentException("Too large absolute values of fromX=" + levelFromX + " or toX=" + levelToX);
            }
            if (levelFromY < -2305843009213693951L || levelToY > 0x1FFFFFFFFFFFFFFFL - (long)ScalablePlanePyramidSource.this.compression) {
                throw new IllegalArgumentException("Too large absolute values of fromX=" + levelFromY + " or toX=" + levelToY);
            }
            this.level = level;
            this.levelFromX = levelFromX;
            this.levelFromY = levelFromY;
            this.levelToX = levelToX;
            this.levelToY = levelToY;
            long[] dimensions = ScalablePlanePyramidSource.this.dimensions(level);
            this.levelDimX = dimensions[1];
            this.levelDimY = dimensions[2];
            long l = levelFromX < 0L ? 0L : (this.actualFromX = levelFromX > this.levelDimX ? this.levelDimX : levelFromX);
            long l2 = levelFromY < 0L ? 0L : (this.actualFromY = levelFromY > this.levelDimY ? this.levelDimY : levelFromY);
            long l3 = levelToX < 0L ? 0L : (this.actualToX = levelToX > this.levelDimX ? this.levelDimX : levelToX);
            this.actualToY = levelToY < 0L ? 0L : (levelToY > this.levelDimY ? this.levelDimY : levelToY);
            this.allDataActual = this.actualFromX == levelFromX && this.actualFromY == levelFromY && this.actualToX == levelToX && this.actualToY == levelToY;
        }

        SubMatrixExtracting extractSubMatrix() {
            this.actualData = ScalablePlanePyramidSource.this.callAndCheckParentReadSubMatrix(this.level, this.actualFromX, this.actualFromY, this.actualToX, this.actualToY);
            this.extendActual();
            return this;
        }

        private void extendActual() {
            assert (this.actualData != null);
            this.fullData = this.allDataActual ? this.actualData : this.actualData.subMatr(0L, this.levelFromX - this.actualFromX, this.levelFromY - this.actualFromY, (long)ScalablePlanePyramidSource.this.bandCount, this.levelToX - this.levelFromX, this.levelToY - this.levelFromY, Matrix.ContinuationMode.getConstantMode((Object)Arrays.maxPossibleValue((Class)this.actualData.type(), (double)1.0)));
        }
    }

    private class ImageScaling {
        final int level;
        final double totalCompression;
        final long roundedTotalCompression;
        final long levelCompression;
        final long zeroLevelFromX;
        final long zeroLevelFromY;
        final long zeroLevelToX;
        final long zeroLevelToY;
        final long levelFromX;
        final long levelFromY;
        long levelToX;
        long levelToY;
        long newDimX;
        long newDimY;
        final double additionalCompression;
        final boolean needAdditionalCompression;
        final boolean additionalCompressionIsInteger;
        private long scaleImageExtractingTime = 0L;
        private long scaleImageCompressionTime = 0L;

        ImageScaling(int level, double compression, long zeroLevelFromX, long zeroLevelFromY, long zeroLevelToX, long zeroLevelToY) {
            assert (zeroLevelFromX <= zeroLevelToX);
            assert (zeroLevelFromY <= zeroLevelToY);
            this.zeroLevelFromX = zeroLevelFromX;
            this.zeroLevelFromY = zeroLevelFromY;
            this.zeroLevelToX = zeroLevelToX;
            this.zeroLevelToY = zeroLevelToY;
            assert (level >= 0);
            assert (compression > 0.0);
            this.level = level;
            double levelCompression = ScalablePlanePyramidSource.this.compression(level);
            assert (levelCompression > 0.0 && levelCompression <= compression);
            this.totalCompression = compression;
            this.roundedTotalCompression = StrictMath.round(compression);
            this.levelFromX = this.safeFloor((double)zeroLevelFromX / levelCompression);
            this.levelFromY = this.safeFloor((double)zeroLevelFromY / levelCompression);
            this.levelToX = this.safeFloor((double)zeroLevelToX / levelCompression);
            this.levelToY = this.safeFloor((double)zeroLevelToY / levelCompression);
            this.additionalCompression = compression / levelCompression;
            this.levelCompression = Math.round(levelCompression);
            this.needAdditionalCompression = Math.abs(this.additionalCompression - 1.0) > 1.0E-4;
            this.newDimX = this.levelToX - this.levelFromX;
            this.newDimY = this.levelToY - this.levelFromY;
            if (this.needAdditionalCompression) {
                this.newDimX = Math.min(this.newDimX, this.safeFloor((double)this.newDimX / this.additionalCompression));
                this.newDimY = Math.min(this.newDimY, this.safeFloor((double)this.newDimY / this.additionalCompression));
            }
            if (this.needAdditionalCompression) {
                assert (this.additionalCompression > 1.0);
                long intAdditionalCompression = Math.round(this.additionalCompression);
                boolean bl = this.additionalCompressionIsInteger = Math.abs(this.additionalCompression - (double)intAdditionalCompression) < 1.0E-7;
                if (this.additionalCompressionIsInteger) {
                    this.levelToX = Math.min(this.levelToX, this.levelFromX + intAdditionalCompression * this.newDimX);
                    this.levelToY = Math.min(this.levelToY, this.levelFromY + intAdditionalCompression * this.newDimY);
                }
            } else {
                this.additionalCompressionIsInteger = false;
            }
            LOG.log(System.Logger.Level.TRACE, () -> String.format(Locale.US, "Resizing %d..%d x %d..%d (level %d) into %dx%d, additional compression %.3f (%.3f/X, %.3f/Y, %snecessary%s)", this.levelFromX, this.levelToX - 1L, this.levelFromY, this.levelToY - 1L, level, this.newDimX, this.newDimY, this.additionalCompression, (double)(this.levelToX - this.levelFromX) / (double)this.newDimX, (double)(this.levelToY - this.levelFromY) / (double)this.newDimY, this.needAdditionalCompression ? "" : "NOT ", this.additionalCompressionIsInteger ? " and is integer" : ""));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Matrix<? extends PArray> scaleImage() {
            long t1 = System.nanoTime();
            Matrix sourceData = ScalablePlanePyramidSource.this.readSubMatrix(this.level, this.levelFromX, this.levelFromY, this.levelToX, this.levelToY);
            long t2 = System.nanoTime();
            this.scaleImageExtractingTime = t2 - t1;
            if (this.needAdditionalCompression) {
                boolean convertBitToByte;
                Object object = ScalablePlanePyramidSource.this.elementTypeLock;
                synchronized (object) {
                    convertBitToByte = this.needAdditionalCompression && ScalablePlanePyramidSource.this.averagingMode == PlanePyramidSource.AveragingMode.AVERAGING && ScalablePlanePyramidSource.this.elementType == Boolean.TYPE;
                }
                if (convertBitToByte) {
                    Range srcRange = Range.valueOf((double)0.0, (double)((PArray)sourceData.array()).maxPossibleValue(1.0));
                    Range destRange = Range.valueOf((double)0.0, (double)Arrays.maxPossibleIntegerValue(ByteArray.class));
                    sourceData = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((Range)destRange, (Range)srcRange), ByteArray.class, sourceData);
                }
                Matrix<UpdatablePArray> resized = ScalablePlanePyramidSource.this.newResultMatrix(sourceData.elementType(), this.newDimX, this.newDimY);
                this.doResize(resized, sourceData);
                long t3 = System.nanoTime();
                this.scaleImageCompressionTime = t3 - t2;
                return resized;
            }
            assert (sourceData.dim(1) == this.newDimX);
            assert (sourceData.dim(2) == this.newDimY);
            return sourceData;
        }

        String scaleImageTiming() {
            return String.format(Locale.US, "%s.scaleImage timing: %.3f ms = %.3f extracting data + %.3f compression", this.getClass().getSimpleName(), (double)(this.scaleImageExtractingTime + this.scaleImageCompressionTime) * 1.0E-6, (double)this.scaleImageExtractingTime * 1.0E-6, (double)this.scaleImageCompressionTime * 1.0E-6) + (this.needAdditionalCompression ? String.format(Locale.US, " (additional compressing %dx%d to %dx%d in %.3f times)", this.levelToX - this.levelFromX, this.levelToY - this.levelFromY, this.newDimX, this.newDimY, this.additionalCompression) : " (additional compression skipped)");
        }

        private void doResize(Matrix<? extends UpdatablePArray> resized, Matrix<? extends PArray> source) {
            Matrices.ResizingMethod resizingMethod = ScalablePlanePyramidSource.this.averagingMode.averagingMethod(source);
            if (this.additionalCompressionIsInteger) {
                Matrices.resize(null, (Matrices.ResizingMethod)resizingMethod, resized, source);
            } else {
                double scale = 1.0 / this.additionalCompression;
                Matrices.copy(null, resized, (Matrix)Matrices.asResized((Matrices.ResizingMethod)resizingMethod, source, (long[])resized.dimensions(), (double[])new double[]{1.0, scale, scale}), (int)0, (boolean)false);
            }
        }

        private long safeFloor(double value) {
            double result = Math.floor(value);
            if (Math.abs(value - (result + 1.0)) < 1.0E-7) {
                return (long)(result + 1.0);
            }
            return (long)result;
        }
    }
}

