/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.tiff;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.maps.LongTimeOpeningMode;
import net.algart.executors.modules.maps.tiff.AbstractTiffOperation;
import net.algart.matrices.tiff.TiffIFD;
import net.algart.matrices.tiff.TiffWriter;
import net.algart.matrices.tiff.tags.TagCompression;
import net.algart.matrices.tiff.tags.TagPredictor;
import net.algart.matrices.tiff.tiles.TiffWriteMap;
import net.algart.multimatrix.MultiMatrix2D;

public final class WriteTiff
extends AbstractTiffOperation
implements ReadOnlyExecutionInput {
    private LongTimeOpeningMode openingMode = LongTimeOpeningMode.OPEN_AND_CLOSE;
    private boolean appendIFDToExistingTiff = false;
    private boolean deleteFileOnError = true;
    private boolean bigTiff = false;
    private ByteOrder byteOrder = ByteOrder.NATIVE;
    private TagCompression compression = TagCompression.NONE;
    private Double quality = null;
    private Double losslessCompressionLevel = null;
    private boolean prediction = false;
    private boolean signedIntegers = false;
    private String imageDescription = "";
    private boolean resizable = true;
    private int imageDimX = 0;
    private int imageDimY = 0;
    private int x = 0;
    private int y = 0;
    private boolean tiled = true;
    private int tileSizeX = 256;
    private int tileSizeY = 256;
    private Integer stripSizeY = null;
    private boolean flushASAP = true;
    private volatile TiffWriteMap writeMap = null;

    public WriteTiff() {
        this.defaultOutputPortName("absolute_path");
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputScalar("close_file");
        this.addOutputScalar("ifd_index");
        this.addOutputScalar("number_of_images");
        this.addOutputScalar("image_dim_x");
        this.addOutputScalar("image_dim_y");
        this.addOutputScalar("ifd");
        this.addOutputScalar("pretty_ifd");
        this.addOutputScalar("file_size");
        this.addOutputScalar("stored_tiles_count");
        this.addOutputScalar("stored_tiles_memory");
        this.addOutputScalar("closed");
    }

    public WriteTiff setFile(String file) {
        super.setFile(file);
        return this;
    }

    public LongTimeOpeningMode getOpeningMode() {
        return this.openingMode;
    }

    public WriteTiff setOpeningMode(LongTimeOpeningMode openingMode) {
        this.openingMode = (LongTimeOpeningMode)((Object)WriteTiff.nonNull((Object)((Object)openingMode)));
        return this;
    }

    public boolean isAppendIFDToExistingTiff() {
        return this.appendIFDToExistingTiff;
    }

    public WriteTiff setAppendIFDToExistingTiff(boolean appendIFDToExistingTiff) {
        this.appendIFDToExistingTiff = appendIFDToExistingTiff;
        return this;
    }

    public boolean isDeleteFileOnError() {
        return this.deleteFileOnError;
    }

    public WriteTiff setDeleteFileOnError(boolean deleteFileOnError) {
        this.deleteFileOnError = deleteFileOnError;
        return this;
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public WriteTiff setBigTiff(boolean bigTiff) {
        this.bigTiff = bigTiff;
        return this;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public WriteTiff setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public TagCompression getCompression() {
        return this.compression;
    }

    public WriteTiff setCompression(TagCompression compression) {
        this.compression = (TagCompression)WriteTiff.nonNull((Object)compression);
        return this;
    }

    public Double getQuality() {
        return this.quality;
    }

    public WriteTiff setQuality(Double quality) {
        this.quality = quality;
        return this;
    }

    public Double getLosslessCompressionLevel() {
        return this.losslessCompressionLevel;
    }

    public WriteTiff setLosslessCompressionLevel(Double losslessCompressionLevel) {
        this.losslessCompressionLevel = losslessCompressionLevel;
        return this;
    }

    public boolean isPrediction() {
        return this.prediction;
    }

    public WriteTiff setPrediction(boolean prediction) {
        this.prediction = prediction;
        return this;
    }

    public boolean isSignedIntegers() {
        return this.signedIntegers;
    }

    public WriteTiff setSignedIntegers(boolean signedIntegers) {
        this.signedIntegers = signedIntegers;
        return this;
    }

    public String getImageDescription() {
        return this.imageDescription;
    }

    public WriteTiff setImageDescription(String imageDescription) {
        this.imageDescription = (String)WriteTiff.nonNull((Object)imageDescription);
        return this;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public WriteTiff setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public int getImageDimX() {
        return this.imageDimX;
    }

    public WriteTiff setImageDimX(int imageDimX) {
        this.imageDimX = WriteTiff.nonNegative((int)imageDimX);
        return this;
    }

    public WriteTiff setImageDimX(String imageDimX) {
        return this.setImageDimX(WriteTiff.intOrDefault((String)imageDimX, (int)0));
    }

    public int getImageDimY() {
        return this.imageDimY;
    }

    public WriteTiff setImageDimY(int imageDimY) {
        this.imageDimY = WriteTiff.nonNegative((int)imageDimY);
        return this;
    }

    public WriteTiff setImageDimY(String imageDimY) {
        return this.setImageDimY(WriteTiff.intOrDefault((String)imageDimY, (int)0));
    }

    public int getX() {
        return this.x;
    }

    public WriteTiff setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public WriteTiff setY(int y) {
        this.y = y;
        return this;
    }

    public boolean isTiled() {
        return this.tiled;
    }

    public WriteTiff setTiled(boolean tiled) {
        this.tiled = tiled;
        return this;
    }

    public int getTileSizeX() {
        return this.tileSizeX;
    }

    public WriteTiff setTileSizeX(int tileSizeX) {
        this.tileSizeX = WriteTiff.positive((int)tileSizeX);
        return this;
    }

    public int getTileSizeY() {
        return this.tileSizeY;
    }

    public WriteTiff setTileSizeY(int tileSizeY) {
        this.tileSizeY = WriteTiff.positive((int)tileSizeY);
        return this;
    }

    public Integer getStripSizeY() {
        return this.stripSizeY;
    }

    public WriteTiff setStripSizeY(Integer stripSizeY) {
        this.stripSizeY = stripSizeY == null ? null : Integer.valueOf(WriteTiff.nonNegative((int)stripSizeY));
        return this;
    }

    public boolean isFlushASAP() {
        return this.flushASAP;
    }

    public WriteTiff setFlushASAP(boolean flushASAP) {
        this.flushASAP = flushASAP;
        return this;
    }

    public void initialize() {
        if (this.openingMode.isClosePreviousOnReset()) {
            try {
                this.closeWriter(false);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public void process() {
        SMat input = this.getInputMat(true);
        this.writeTiff(this.completeFilePath(), input.toMultiMatrix2D());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTiff(Path path, MultiMatrix2D multiMatrix) {
        Objects.requireNonNull(path, "Null path");
        Matrix m = multiMatrix == null ? null : multiMatrix.mergeChannels();
        try {
            boolean needToClose = WriteTiff.needToClose((Executor)this, this.openingMode);
            this.openFile(path, (Matrix<? extends PArray>)m, needToClose);
            this.getScalar("ifd_index").setTo(this.writeMap.owner().numberOfIFDs());
            this.writeMatrix((Matrix<? extends PArray>)m, needToClose);
            if (needToClose) {
                this.closeWriter(true);
            } else {
                WriteTiff.fillWritingOutputInformation((Executor)this, this.writeMap);
            }
        }
        catch (IOException e) {
            try {
                this.closeFileOnError();
                if (!this.deleteFileOnError) throw new IOError(e);
                try {
                    Files.deleteIfExists(path);
                    throw new IOError(e);
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw new IOError(e);
                catch (RuntimeException e2) {
                    this.closeFileOnError();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.getScalar("closed").setTo(this.writeMap == null);
                throw throwable;
            }
        }
        this.getScalar("closed").setTo(this.writeMap == null);
    }

    public void close() {
        super.close();
        this.closeFileOnError();
    }

    public void openFile(Path path, Matrix<? extends PArray> firstMatrix, boolean needToClose) throws IOException {
        Objects.requireNonNull(path, "Null path");
        WriteTiff.logDebug(() -> "Writing " + String.valueOf(path));
        if (this.writeMap == null) {
            TiffWriteMap writeMap;
            if (firstMatrix == null) {
                throw new IllegalArgumentException("The input matrix is not specified, but this matrix is required when the TIFF file is initially opened (although it can be omitted on subsequent calls when the file is already opened)");
            }
            TiffWriter writer = null;
            try {
                writer = new TiffWriter(path);
                writer.setBigTiff(this.bigTiff);
                writer.setLittleEndian(this.byteOrder.isLittleEndian());
                writer.create(this.appendIFDToExistingTiff);
                boolean dimensionsRequired = !needToClose || this.x != 0 || this.y != 0;
                TiffIFD ifd = this.configure(writer, firstMatrix, dimensionsRequired);
                writeMap = writer.newMap(ifd, this.resizable && dimensionsRequired);
                writer.writeForward(writeMap);
            }
            catch (IOException | RuntimeException e) {
                if (writer != null) {
                    writer.close();
                }
                throw e;
            }
            this.writeMap = writeMap;
            this.correctSettingsForNewData();
        }
        this.fillOutputFileInformation(path);
        AbstractTiffOperation.fillWritingOutputInformation((Executor)this, this.writeMap);
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        return this.defaultVisibleResultsInformation(Port.Type.INPUT, DEFAULT_INPUT_PORT);
    }

    private void correctSettingsForNewData() {
        TiffWriter owner = this.writeMap.owner();
        owner.setCompressionQuality(this.quality);
        owner.setLosslessCompressionLevel(this.losslessCompressionLevel);
    }

    private TiffIFD configure(TiffWriter writer, Matrix<? extends PArray> firstMatrix, boolean dimensionsRequired) {
        String description;
        TiffIFD ifd = writer.newIFD(this.tiled);
        if (this.tiled) {
            ifd.putTileSizes(this.tileSizeX, this.tileSizeY);
        } else if (this.stripSizeY != null) {
            ifd.putOrRemoveStripSize(this.stripSizeY == 0 ? null : this.stripSizeY);
        }
        ifd.putCompression(this.compression);
        ifd.putMatrixInformation(firstMatrix, this.signedIntegers);
        ifd.putPredictor(this.prediction && firstMatrix.elementType() != Boolean.TYPE ? TagPredictor.HORIZONTAL : TagPredictor.NONE);
        if (!this.resizable) {
            if (this.imageDimX != 0 && this.imageDimY != 0) {
                ifd.putImageDimensions(this.imageDimX, this.imageDimY);
            } else if (dimensionsRequired) {
                throw new IllegalArgumentException("You must specify full image sizes (you may omit this only in resizable mode or while single writing at (0,0) position)");
            }
        }
        if (!(description = this.imageDescription.trim()).isEmpty()) {
            ifd.putDescription(description);
        }
        return ifd;
    }

    private void writeMatrix(Matrix<? extends PArray> matrix, boolean needToClose) throws IOException {
        this.correctSettingsForNewData();
        if (matrix != null) {
            List updated = this.writeMap.updateMatrix(matrix, this.x, this.y);
            if (this.flushASAP && !needToClose) {
                int count = this.writeMap.writeCompletedTiles((Collection)updated);
                WriteTiff.logDebug(() -> "Flushing " + count + " from " + updated.size() + " changed tiles");
            }
        }
    }

    private void closeWriter(boolean fillOutput) throws IOException {
        if (this.writeMap != null) {
            int count = this.writeMap.completeWriting();
            WriteTiff.logDebug(() -> "Completing writing " + count + " tiles");
            TiffWriter writer = this.writeMap.owner();
            if (fillOutput) {
                WriteTiff.fillWritingOutputInformation((Executor)this, this.writeMap);
            }
            WriteTiff.logDebug(() -> "Closing " + String.valueOf(writer));
            writer.close();
            this.writeMap = null;
        }
    }

    private void closeFileOnError() {
        if (this.writeMap != null) {
            TiffWriter writer = this.writeMap.owner();
            WriteTiff.logDebug(() -> "Closing " + String.valueOf(writer) + " (ERROR)");
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                this.writeMap = null;
            }
        }
    }

    public static enum ByteOrder {
        BIG_ENDIAN(java.nio.ByteOrder.BIG_ENDIAN),
        LITTLE_ENDIAN(java.nio.ByteOrder.LITTLE_ENDIAN),
        NATIVE(java.nio.ByteOrder.nativeOrder());

        private final java.nio.ByteOrder order;

        private ByteOrder(java.nio.ByteOrder order) {
            this.order = order;
        }

        public java.nio.ByteOrder order() {
            return this.order;
        }

        public boolean isLittleEndian() {
            return this.order == java.nio.ByteOrder.LITTLE_ENDIAN;
        }
    }
}

