/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.tiff;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.arrays.Matrix;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.maps.LongTimeOpeningMode;
import net.algart.executors.modules.maps.tiff.AbstractTiffOperation;
import net.algart.math.IRectangularArea;
import net.algart.matrices.tiff.TiffOpenMode;
import net.algart.matrices.tiff.TiffReader;
import net.algart.matrices.tiff.tiles.TiffIOMap;
import net.algart.matrices.tiff.tiles.TiffReadMap;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ReadTiff
extends AbstractTiffOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    public static final String OUTPUT_RECTANGLE = "rectangle";
    private LongTimeOpeningMode openingMode = LongTimeOpeningMode.OPEN_AND_CLOSE;
    private boolean requireFileExistence = true;
    private boolean requireTiff = true;
    private int ifdIndex = 0;
    private boolean wholeImage = true;
    private int x = 0;
    private int y = 0;
    private int sizeX = 1;
    private int sizeY = 1;
    private boolean cropToImage = true;
    private boolean caching = false;
    private boolean autoUnpackBitsToBytes = false;
    private boolean autoScaleWhenIncreasingBitDepth = true;
    private boolean autoCorrectInvertedBrightness = false;
    private boolean cropTilesToImageBoundaries = true;
    private int numberOfChannels = 0;
    private volatile TiffReader reader = null;

    public ReadTiff() {
        this.useVisibleResultParameter();
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputScalar("close_file");
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
        this.addOutputScalar("valid");
        this.addOutputScalar("ifd_index");
        this.addOutputScalar("number_of_images");
        this.addOutputScalar("image_dim_x");
        this.addOutputScalar("image_dim_y");
        this.addOutputNumbers(OUTPUT_RECTANGLE);
        this.addOutputScalar("ifd");
        this.addOutputScalar("pretty_ifd");
        this.addOutputScalar("file_size");
        this.addOutputScalar("closed");
    }

    public static ReadTiff getInstance() {
        return new ReadTiff();
    }

    public static ReadTiff getSecureInstance() {
        ReadTiff result = new ReadTiff();
        result.setSecure(true);
        return result;
    }

    public ReadTiff setFile(String file) {
        super.setFile(file);
        return this;
    }

    public LongTimeOpeningMode getOpeningMode() {
        return this.openingMode;
    }

    public ReadTiff setOpeningMode(LongTimeOpeningMode openingMode) {
        this.openingMode = (LongTimeOpeningMode)((Object)ReadTiff.nonNull((Object)((Object)openingMode)));
        return this;
    }

    public boolean isRequireFileExistence() {
        return this.requireFileExistence;
    }

    public ReadTiff setRequireFileExistence(boolean requireFileExistence) {
        this.requireFileExistence = requireFileExistence;
        return this;
    }

    public boolean isRequireTiff() {
        return this.requireTiff;
    }

    public ReadTiff setRequireTiff(boolean requireTiff) {
        this.requireTiff = requireTiff;
        return this;
    }

    public int getIfdIndex() {
        return this.ifdIndex;
    }

    public ReadTiff setIfdIndex(int ifdIndex) {
        this.ifdIndex = ReadTiff.nonNegative((int)ifdIndex);
        return this;
    }

    public boolean isWholeImage() {
        return this.wholeImage;
    }

    public ReadTiff setWholeImage(boolean wholeImage) {
        this.wholeImage = wholeImage;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public ReadTiff setX(int x) {
        this.x = x;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public ReadTiff setY(int y) {
        this.y = y;
        return this;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public ReadTiff setSizeX(int sizeX) {
        this.sizeX = ReadTiff.nonNegative((int)sizeX);
        return this;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public ReadTiff setSizeY(int sizeY) {
        this.sizeY = ReadTiff.nonNegative((int)sizeY);
        return this;
    }

    public boolean isCropToImage() {
        return this.cropToImage;
    }

    public ReadTiff setCropToImage(boolean cropToImage) {
        this.cropToImage = cropToImage;
        return this;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public ReadTiff setCaching(boolean caching) {
        this.caching = caching;
        return this;
    }

    public boolean isAutoUnpackBitsToBytes() {
        return this.autoUnpackBitsToBytes;
    }

    public ReadTiff setAutoUnpackBitsToBytes(boolean autoUnpackBitsToBytes) {
        this.autoUnpackBitsToBytes = autoUnpackBitsToBytes;
        return this;
    }

    public boolean isAutoScaleWhenIncreasingBitDepth() {
        return this.autoScaleWhenIncreasingBitDepth;
    }

    public ReadTiff setAutoScaleWhenIncreasingBitDepth(boolean autoScaleWhenIncreasingBitDepth) {
        this.autoScaleWhenIncreasingBitDepth = autoScaleWhenIncreasingBitDepth;
        return this;
    }

    public boolean isAutoCorrectInvertedBrightness() {
        return this.autoCorrectInvertedBrightness;
    }

    public ReadTiff setAutoCorrectInvertedBrightness(boolean autoCorrectInvertedBrightness) {
        this.autoCorrectInvertedBrightness = autoCorrectInvertedBrightness;
        return this;
    }

    public boolean isCropTilesToImageBoundaries() {
        return this.cropTilesToImageBoundaries;
    }

    public ReadTiff setCropTilesToImageBoundaries(boolean cropTilesToImageBoundaries) {
        this.cropTilesToImageBoundaries = cropTilesToImageBoundaries;
        return this;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public ReadTiff setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = ReadTiff.nonNegative((int)numberOfChannels);
        return this;
    }

    public void initialize() {
        if (this.openingMode.isClosePreviousOnReset()) {
            this.closeReader();
        }
    }

    public void process() {
        SMat input = this.getInputMat(this.defaultInputPortName(), true);
        if (input.isInitialized()) {
            ReadTiff.logDebug(() -> "Copying " + String.valueOf(input));
            this.getMat().setTo(input);
        } else {
            MultiMatrix multiMatrix = this.readTiff(this.completeFilePath(), this.isOutputNecessary(DEFAULT_OUTPUT_PORT));
            if (multiMatrix != null) {
                this.getMat().setTo(multiMatrix);
            } else {
                this.getMat().remove();
            }
        }
    }

    public MultiMatrix readTiff(Path path) {
        return this.readTiff(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiMatrix readTiff(Path path, boolean doActualReading) {
        MultiMatrix2D multiMatrix2D;
        TiffReader reader;
        block10: {
            block9: {
                Objects.requireNonNull(path, "Null path");
                this.getScalar("valid").setTo(false);
                this.getScalar(OUTPUT_DIM_X).remove();
                this.getScalar(OUTPUT_DIM_Y).remove();
                this.getNumbers(OUTPUT_RECTANGLE).remove();
                if (Files.isRegularFile(path, new LinkOption[0])) break block9;
                if (this.requireFileExistence) {
                    throw new FileNotFoundException("File not found: " + String.valueOf(path));
                }
                MultiMatrix multiMatrix = null;
                this.getScalar("closed").setTo(this.reader == null);
                return multiMatrix;
            }
            reader = this.openFile(path);
            ReadTiff.fillReadingOutputInformation((Executor)this, reader, this.ifdIndex);
            if (reader.isValidTiff()) break block10;
            this.closeReader();
            MultiMatrix multiMatrix = null;
            this.getScalar("closed").setTo(this.reader == null);
            return multiMatrix;
        }
        try {
            MultiMatrix2D multiMatrix = doActualReading ? this.readMultiMatrix(reader) : null;
            boolean close = ReadTiff.needToClose((Executor)this, this.openingMode);
            if (close) {
                this.closeReader();
            }
            multiMatrix2D = multiMatrix;
        }
        catch (IOException e) {
            MultiMatrix multiMatrix;
            try {
                this.getScalar("valid").setTo(false);
                this.closeReader();
                if (this.requireTiff) {
                    throw new IOError(e);
                }
                LOG.log(System.Logger.Level.INFO, "IGNORING EXCEPTION while reading TIFF " + String.valueOf(path) + ", IFD #" + this.ifdIndex + ":\n      " + String.valueOf(e));
                this.getScalar("pretty_ifd").setTo(e.toString());
                multiMatrix = null;
            }
            catch (Throwable throwable) {
                this.getScalar("closed").setTo(this.reader == null);
                throw throwable;
            }
            this.getScalar("closed").setTo(this.reader == null);
            return multiMatrix;
        }
        this.getScalar("closed").setTo(this.reader == null);
        return multiMatrix2D;
    }

    public void close() {
        super.close();
        this.closeReader();
    }

    public TiffReader openFile(Path path) throws IOException {
        Objects.requireNonNull(path, "Null path");
        ReadTiff.logDebug(() -> "Reading " + String.valueOf(path));
        TiffReader reader = this.reader;
        if (reader == null) {
            reader = new TiffReader(path, TiffOpenMode.ofRequireTiff((boolean)this.requireTiff)).setCaching(this.caching);
            reader.setAutoUnpackBits(TiffReader.UnpackBits.of((boolean)this.autoUnpackBitsToBytes));
            reader.setAutoScaleWhenIncreasingBitDepth(this.autoScaleWhenIncreasingBitDepth);
            reader.setAutoCorrectInvertedBrightness(this.autoCorrectInvertedBrightness);
            reader.setCropTilesToImageBoundaries(this.cropTilesToImageBoundaries);
            this.reader = reader;
        }
        this.fillOutputFileInformation(path);
        return reader;
    }

    private MultiMatrix2D readMultiMatrix(TiffReader reader) throws IOException {
        TiffReadMap map = reader.newMap(this.ifdIndex);
        int fromX = this.x;
        int fromY = this.y;
        int toX = fromX + this.sizeX;
        int toY = fromY + this.sizeY;
        if (this.wholeImage) {
            fromX = 0;
            fromY = 0;
            toX = map.dimX();
            toY = map.dimY();
        } else if (this.cropToImage) {
            fromX = Math.max(fromX, 0);
            fromY = Math.max(fromY, 0);
            toX = Math.min(toX, map.dimX());
            toY = Math.min(toY, map.dimY());
            if (fromX >= toX || fromY >= toY) {
                return null;
            }
        }
        Matrix m = reader.readMatrix((TiffIOMap)map, fromX, fromY, toX, toY);
        MultiMatrix2D result = MultiMatrix.of2DMerged((Matrix)m);
        if (this.numberOfChannels != 0) {
            result = result.asOtherNumberOfChannels(this.numberOfChannels);
        }
        this.getScalar(OUTPUT_DIM_X).setTo(toX - fromX);
        this.getScalar(OUTPUT_DIM_Y).setTo(toY - fromY);
        this.getNumbers(OUTPUT_RECTANGLE).setTo(IRectangularArea.valueOf((long)fromX, (long)fromY, (long)(toX - 1), (long)(toY - 1)));
        return result;
    }

    private void closeReader() {
        TiffReader reader = this.reader;
        if (reader != null) {
            this.reader = null;
            ReadTiff.logDebug(() -> "Closing " + String.valueOf(reader));
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }
}

