/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import net.algart.executors.modules.maps.pyramids.io.DiagonalDirectionOnMap;
import net.algart.math.IPoint;

public enum ScanningMapSequence {
    ROWS_LEFT_TO_RIGHT{

        @Override
        public DiagonalDirectionOnMap recommendedFrameExpansion(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return DiagonalDirectionOnMap.LEFT_UP;
        }

        @Override
        public IPoint framePosition(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return IPoint.valueOf((long)(lowFrameIndex * frameSizeX), (long)(highFrameIndex * frameSizeY));
        }

        @Override
        public long xFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return lowFrameIndex;
        }

        @Override
        public long yFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return highFrameIndex;
        }

        @Override
        public long lowFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimX, frameSizeX);
        }

        @Override
        public long highFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimY, frameSizeY);
        }
    }
    ,
    ROWS_BY_SNAKE{

        @Override
        public DiagonalDirectionOnMap recommendedFrameExpansion(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return (highFrameIndex & 1L) == 0L ? DiagonalDirectionOnMap.LEFT_UP : DiagonalDirectionOnMap.RIGHT_UP;
        }

        @Override
        public IPoint framePosition(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            long lowFrameCount = this.lowFrameCount(frameSizeX, frameSizeY, totalDimX, totalDimY);
            return IPoint.valueOf((long)(((highFrameIndex & 1L) == 0L ? lowFrameIndex : lowFrameCount - 1L - lowFrameIndex) * frameSizeX), (long)(highFrameIndex * frameSizeY));
        }

        @Override
        public long xFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            long lowFrameCount = this.lowFrameCount(frameSizeX, frameSizeY, totalDimX, totalDimY);
            return (highFrameIndex & 1L) == 0L ? lowFrameIndex : lowFrameCount - 1L - lowFrameIndex;
        }

        @Override
        public long yFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return highFrameIndex;
        }

        @Override
        public long lowFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimX, frameSizeX);
        }

        @Override
        public long highFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimY, frameSizeY);
        }
    }
    ,
    COLUMNS_TOP_TO_BOTTOM{

        @Override
        public DiagonalDirectionOnMap recommendedFrameExpansion(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return DiagonalDirectionOnMap.LEFT_UP;
        }

        @Override
        public IPoint framePosition(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return IPoint.valueOf((long)(highFrameIndex * frameSizeX), (long)(lowFrameIndex * frameSizeY));
        }

        @Override
        public long xFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return highFrameIndex;
        }

        @Override
        public long yFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return lowFrameIndex;
        }

        @Override
        public long lowFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimY, frameSizeY);
        }

        @Override
        public long highFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimX, frameSizeX);
        }
    }
    ,
    COLUMNS_BY_SNAKE{

        @Override
        public DiagonalDirectionOnMap recommendedFrameExpansion(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return (highFrameIndex & 1L) == 0L ? DiagonalDirectionOnMap.LEFT_UP : DiagonalDirectionOnMap.LEFT_DOWN;
        }

        @Override
        public IPoint framePosition(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            long lowFrameCount = this.lowFrameCount(frameSizeX, frameSizeY, totalDimX, totalDimY);
            return IPoint.valueOf((long)(highFrameIndex * frameSizeX), (long)(((highFrameIndex & 1L) == 0L ? lowFrameIndex : lowFrameCount - 1L - lowFrameIndex) * frameSizeY));
        }

        @Override
        public long xFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return highFrameIndex;
        }

        @Override
        public long yFrameIndex(long lowFrameIndex, long highFrameIndex, long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            long lowFrameCount = this.lowFrameCount(frameSizeX, frameSizeY, totalDimX, totalDimY);
            return (highFrameIndex & 1L) == 0L ? lowFrameIndex : lowFrameCount - 1L - lowFrameIndex;
        }

        @Override
        public long lowFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimY, frameSizeY);
        }

        @Override
        public long highFrameCount(long frameSizeX, long frameSizeY, long totalDimX, long totalDimY) {
            return ScanningMapSequence.divideCeil(totalDimX, frameSizeX);
        }
    };


    public abstract DiagonalDirectionOnMap recommendedFrameExpansion(long var1, long var3, long var5, long var7, long var9, long var11);

    public abstract IPoint framePosition(long var1, long var3, long var5, long var7, long var9, long var11);

    public abstract long xFrameIndex(long var1, long var3, long var5, long var7, long var9, long var11);

    public abstract long yFrameIndex(long var1, long var3, long var5, long var7, long var9, long var11);

    public abstract long lowFrameCount(long var1, long var3, long var5, long var7);

    public abstract long highFrameCount(long var1, long var3, long var5, long var7);

    private static long divideCeil(long totalDim, long frameSize) {
        if (totalDim < 0L) {
            throw new IllegalArgumentException("Negative total dimension = " + totalDim);
        }
        if (frameSize <= 0L) {
            throw new IllegalArgumentException("Zero or negative frame size = " + frameSize);
        }
        long result = totalDim / frameSize;
        return result * frameSize == totalDim ? result : result + 1L;
    }
}

