/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.maps.pyramids.io.AbstractImagePyramidOperation;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidLevelRois;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidMetadataJson;
import net.algart.executors.modules.maps.pyramids.io.ScanningMapSequence;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;

public final class ImagePyramidInfo
extends AbstractImagePyramidOperation
implements ReadOnlyExecutionInput {
    private long sizeX = 1L;
    private long sizeY = 1L;

    public ImagePyramidInfo() {
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar("number_of_levels");
        this.addOutputScalar("level_dim_x");
        this.addOutputScalar("level_dim_y");
        this.addOutputScalar("number_of_frames");
        this.addOutputScalar("frames_per_series");
        this.addOutputScalar("recommended_number_of_frames_in_buffer");
        this.addOutputScalar("builtin_metadata");
        this.addOutputScalar("metadata");
        this.addOutputNumbers("metadata_roi_rectangles");
        this.addOutputNumbers("metadata_roi_contours");
    }

    public long getSizeX() {
        return this.sizeX;
    }

    public ImagePyramidInfo setSizeX(long sizeX) {
        this.sizeX = ImagePyramidInfo.positive((long)sizeX);
        return this;
    }

    public long getSizeY() {
        return this.sizeY;
    }

    public ImagePyramidInfo setSizeY(long sizeY) {
        this.sizeY = ImagePyramidInfo.positive((long)sizeY);
        return this;
    }

    public void process() {
        this.testPlanePyramid(this.completeFilePath());
    }

    public void testPlanePyramid(Path path) {
        Objects.requireNonNull(path, "Null path");
        this.getScalar().setTo("Information about the pyramid " + String.valueOf(path));
        PlanePyramidSource planePyramidSource = null;
        try {
            planePyramidSource = this.openPyramid(path);
            ImagePyramidMetadataJson metadataJson = this.readMetadataOrNull(path);
            ImagePyramidLevelRois levelRois = this.newLevelRois(planePyramidSource, metadataJson);
            this.fillOutputInformation(planePyramidSource, levelRois);
            this.getScalar("number_of_frames").setTo(levelRois.totalNumberOfFrames(this.sizeX, this.sizeY, false));
            ScanningMapSequence mapSequence = this.getScanningSequence().mapSequence(levelRois);
            long framesPerSeries = levelRois.framesPerSeries(mapSequence, this.sizeX, this.sizeY, false);
            if (mapSequence != null) {
                this.getScalar("frames_per_series").setTo(framesPerSeries);
            }
            this.fillOutputNumberOfStoredFrames(framesPerSeries, false);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            if (planePyramidSource != null) {
                planePyramidSource.freeResources(PlanePyramidSource.FlushMode.STANDARD);
            }
        }
    }

    private PlanePyramidSource openPyramid(Path path) throws IOException {
        Objects.requireNonNull(path, "Null path");
        ImagePyramidInfo.logDebug(() -> "Opening " + String.valueOf(path));
        PlanePyramidSource result = this.newPlanePyramidSource(path);
        if (this.resolutionLevel >= result.numberOfResolutions()) {
            throw new IllegalArgumentException("Too big index of resolution level: there are only " + result.numberOfResolutions() + " resolutions");
        }
        return result;
    }
}

