/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import java.util.Locale;
import java.util.Random;

public class GridEqualizer {
    private final long totalDimension;
    private long numberOfCells = -1L;
    private long originalCellSize = -1L;
    private long equalizedCellSize = -1L;

    public GridEqualizer(long totalDimension) {
        if (totalDimension < 0L) {
            throw new IllegalArgumentException("Negative total dimension = " + totalDimension);
        }
        this.totalDimension = totalDimension;
    }

    public GridEqualizer equalize(long cellSize) {
        this.originalCellSize = cellSize;
        if (this.totalDimension == 0L) {
            this.equalizedCellSize = cellSize;
            this.numberOfCells = 0L;
            return this;
        }
        if (cellSize <= 0L) {
            throw new IllegalArgumentException("Negative or zero cell size = " + cellSize);
        }
        this.numberOfCells = GridEqualizer.divideCeil(this.totalDimension, cellSize);
        long error = cellSize * this.numberOfCells - this.totalDimension;
        assert (error >= 0L && error < cellSize) : "illegal " + error + " for " + this.totalDimension + "/" + cellSize;
        if (error == 0L) {
            this.equalizedCellSize = cellSize;
            return this;
        }
        this.equalizedCellSize = GridEqualizer.divideCeil(this.totalDimension, this.numberOfCells);
        if (this.equalizedCellSize > cellSize) {
            throw new AssertionError((Object)("Illegal algorithm: new cell size " + this.equalizedCellSize + " > original " + cellSize + " (" + String.valueOf(this) + ")"));
        }
        long resultError = this.equalizedCellSize * this.numberOfCells - this.totalDimension;
        assert (resultError >= 0L && resultError < this.numberOfCells) : "illegal " + resultError + " for " + this.totalDimension + "/" + this.numberOfCells;
        if (resultError > error) {
            throw new AssertionError((Object)("Illegal algorithm: new error " + resultError + " > " + error + " (" + String.valueOf(this) + ")"));
        }
        if (resultError >= this.equalizedCellSize) {
            throw new AssertionError((Object)("Illegal algorithm: number of cells " + this.numberOfCells + " changed, because new error " + resultError + " is too large (" + String.valueOf(this) + ")"));
        }
        return this;
    }

    public long totalDimension() {
        return this.totalDimension;
    }

    public long numberOfCells() {
        if (this.numberOfCells < 0L) {
            throw new IllegalStateException("equalize() was not called yet");
        }
        return this.numberOfCells;
    }

    public long originalCellSize() {
        if (this.numberOfCells < 0L) {
            throw new IllegalStateException("equalize() was not called yet");
        }
        return this.originalCellSize;
    }

    public long equalizedCellSize() {
        if (this.numberOfCells < 0L) {
            throw new IllegalStateException("equalize() was not called yet");
        }
        return this.equalizedCellSize;
    }

    public static long equalizeGrid(long totalDimension, long cellSize) {
        if (totalDimension < 0L) {
            throw new IllegalArgumentException("Negative total dimension = " + totalDimension);
        }
        if (totalDimension == 0L) {
            return cellSize;
        }
        if (cellSize <= 0L) {
            throw new IllegalArgumentException("Negative or zero cell size = " + cellSize);
        }
        long numberOfCells = GridEqualizer.divideCeil(totalDimension, cellSize);
        long error = cellSize * numberOfCells - totalDimension;
        assert (error >= 0L && error < cellSize) : "illegal " + error + " for " + totalDimension + "/" + cellSize;
        if (error == 0L) {
            return cellSize;
        }
        long equalizedCellSize = GridEqualizer.divideCeil(totalDimension, numberOfCells);
        if (equalizedCellSize > cellSize) {
            throw new AssertionError((Object)("Illegal algorithm: new cell size " + equalizedCellSize + " > original " + cellSize));
        }
        long resultError = equalizedCellSize * numberOfCells - totalDimension;
        assert (resultError >= 0L && resultError < numberOfCells) : "illegal " + resultError + " for " + totalDimension + "/" + numberOfCells;
        if (resultError > error) {
            throw new AssertionError((Object)("Illegal algorithm: new error " + resultError + " > " + error));
        }
        if (resultError >= equalizedCellSize) {
            throw new AssertionError((Object)("Illegal algorithm: number of cells " + numberOfCells + " changed, because new error " + resultError + " is too large"));
        }
        return equalizedCellSize;
    }

    public String toString() {
        return "GridEqualizer{totalDimension=" + this.totalDimension + ", numberOfCells=" + this.numberOfCells + ", cellSize=" + this.originalCellSize + ", equalizedCellSize=" + this.equalizedCellSize + "}";
    }

    static long divideCeil(long a, long b) {
        assert (a >= 0L);
        assert (b > 0L);
        long result = a / b;
        return result * b == a ? result : result + 1L;
    }

    public static void main(String[] args) {
        int numberOfTests = 10000000;
        Random rnd = new Random();
        for (int k = 0; k < 10000000; ++k) {
            long totalDimension;
            if (k % 10000 == 0) {
                System.out.print("\r" + k + "...");
            }
            long l = totalDimension = rnd.nextBoolean() ? (long)rnd.nextInt(200) : rnd.nextLong() & 0xFFFFFFFFFFL;
            long cellSize = 1L + (rnd.nextBoolean() ? (long)rnd.nextInt((int)Math.min(1L + totalDimension, Integer.MAX_VALUE)) : (rnd.nextBoolean() ? (long)rnd.nextInt(200) : rnd.nextLong() & 0xFFFFFFFFFFL));
            GridEqualizer equalizer = new GridEqualizer(totalDimension);
            equalizer.equalize(cellSize);
            long newNumberOfCells = GridEqualizer.divideCeil(totalDimension, equalizer.equalizedCellSize());
            if (newNumberOfCells != equalizer.numberOfCells()) {
                throw new AssertionError((Object)("ERROR: new number of cells " + newNumberOfCells + " != original " + equalizer.numberOfCells() + " (" + String.valueOf(equalizer) + ")"));
            }
            if (GridEqualizer.equalizeGrid(totalDimension, cellSize) != equalizer.equalizedCellSize()) {
                throw new AssertionError((Object)"ERROR: static method produces another result!");
            }
        }
        System.out.println("\r                  ");
        for (int test = 0; test < 5; ++test) {
            int k;
            int totalDimension = rnd.nextInt(20000000);
            int cellSize = rnd.nextInt(totalDimension + 1);
            long dummy = 0L;
            long t1 = System.nanoTime();
            for (int k2 = 0; k2 < 10000000; ++k2) {
                dummy += new GridEqualizer(totalDimension).equalize(cellSize).equalizedCellSize();
            }
            long t2 = System.nanoTime();
            System.out.printf(Locale.US, "Creating + equalize(): %.3f ns/call%n", (double)(t2 - t1) / 1.0E7);
            t1 = System.nanoTime();
            GridEqualizer equalizer = new GridEqualizer(totalDimension);
            for (k = 0; k < 10000000; ++k) {
                dummy += equalizer.equalize(cellSize).equalizedCellSize();
            }
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "equalize() method:     %.3f ns/call (%s)%n", (double)(t2 - t1) / 1.0E7, dummy);
            t1 = System.nanoTime();
            for (k = 0; k < 10000000; ++k) {
                dummy += GridEqualizer.equalizeGrid(totalDimension, cellSize);
            }
            t2 = System.nanoTime();
            System.out.printf(Locale.US, "equalize() function:   %.3f ns/call (%s)%n%n", (double)(t2 - t1) / 1.0E7, dummy);
        }
    }
}

