/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.buffers;

import java.util.List;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.joints.DynamicDisjointSet;
import net.algart.executors.modules.maps.frames.joints.QuickLabelsSet;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

class ReindexerAndRetainer {
    final IRectangularArea largeArea;
    final List<MapBuffer.Frame> frames;
    final DynamicDisjointSet dynamicDisjointSet;
    final QuickLabelsSet reindexedCompleted;
    final QuickLabelsSet reindexedBoundaryWithOutside;
    final long largeAreaMinX;
    final long largeAreaMaxX;
    final long largeAreaMinY;
    final int smallMinX;
    final int smallMinY;
    final int smallMaxX;
    final int smallMaxY;
    final int dimX;
    final int dimY;
    final int[] labels;
    final UpdatableIntArray labelsArray;
    final int[] minNonZeroX;
    final int[] maxNonZeroX;
    final boolean jointingAutoCrop;

    private ReindexerAndRetainer(IRectangularArea largeArea, List<MapBuffer.Frame> frames, IRectangularArea smallFrameArea, DynamicDisjointSet dynamicDisjointSet, QuickLabelsSet reindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside, boolean jointingAutoCrop) {
        this.largeArea = largeArea;
        this.frames = frames;
        this.dynamicDisjointSet = dynamicDisjointSet;
        this.reindexedCompleted = reindexedCompleted;
        this.reindexedBoundaryWithOutside = reindexedBoundaryWithOutside;
        this.largeAreaMinX = largeArea.minX();
        this.largeAreaMaxX = largeArea.maxX();
        this.largeAreaMinY = largeArea.minY();
        this.dimX = (int)largeArea.sizeX();
        this.dimY = (int)largeArea.sizeY();
        this.smallMinX = (int)(smallFrameArea.minX() - this.largeAreaMinX);
        this.smallMinY = (int)(smallFrameArea.minY() - this.largeAreaMinY);
        this.smallMaxX = (int)(smallFrameArea.maxX() - this.largeAreaMinX);
        this.smallMaxY = (int)(smallFrameArea.maxY() - this.largeAreaMinY);
        assert (this.smallMinX >= 0);
        assert (this.smallMinY >= 0);
        assert (this.smallMaxX < this.dimX);
        assert (this.smallMaxY < this.dimY);
        long labelsLength = largeArea.sizeX() * largeArea.sizeY();
        assert (labelsLength == (long)((int)labelsLength)) : "sizes of result area were not checked before";
        this.labels = new int[(int)labelsLength];
        this.labelsArray = SimpleMemoryModel.asUpdatableIntArray((int[])this.labels);
        this.jointingAutoCrop = jointingAutoCrop;
        if (jointingAutoCrop) {
            this.minNonZeroX = new int[this.dimY];
            this.maxNonZeroX = new int[this.dimY];
        } else {
            this.minNonZeroX = null;
            this.maxNonZeroX = null;
        }
    }

    public static ReindexerAndRetainer newInstance(IRectangularArea largeArea, List<MapBuffer.Frame> frames, IRectangularArea smallFrameArea, DynamicDisjointSet dynamicDisjointSet, QuickLabelsSet reindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside, boolean jointingAutoCrop) {
        if (frames.isEmpty() || !frames.iterator().next().isIntMatrix()) {
            return new ReindexerAndRetainerNonInt(largeArea, frames, smallFrameArea, dynamicDisjointSet, reindexedCompleted, reindexedBoundaryWithOutside, jointingAutoCrop);
        }
        if (frames.stream().allMatch(frame -> frame.channel0Ints != null)) {
            return new ReindexerAndRetainerDirectAccessible(largeArea, frames, smallFrameArea, dynamicDisjointSet, reindexedCompleted, reindexedBoundaryWithOutside, jointingAutoCrop);
        }
        return new ReindexerAndRetainer(largeArea, frames, smallFrameArea, dynamicDisjointSet, reindexedCompleted, reindexedBoundaryWithOutside, jointingAutoCrop);
    }

    public MapBuffer.Frame reindexAndRetainCompleted() {
        IntStream.range(0, this.dimY).parallel().forEach(this::processSingleLine);
        MapBuffer.Frame resultFrame = new MapBuffer.Frame(this.largeArea.min(), (MultiMatrix)MultiMatrix.of2DMono((Matrix)Matrices.matrix((Array)SimpleMemoryModel.asUpdatableIntArray((int[])this.labels), (long[])this.largeArea.sizes())));
        return this.jointingAutoCrop ? ReindexerAndRetainer.crop(resultFrame, this.minNonZeroX, this.maxNonZeroX) : resultFrame;
    }

    void processSingleLine(int i) {
        boolean crop = this.jointingAutoCrop;
        boolean insideSmallFrameByY = i >= this.smallMinY && i <= this.smallMaxY;
        long y = this.largeAreaMinY + (long)i;
        int disp = i * this.dimX;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (MapBuffer.Frame frame : this.frames) {
            int label;
            int to;
            int p;
            long intersectionMaxX;
            long intersectionMinX;
            if (y < frame.minY || y > frame.maxY || (intersectionMinX = Math.max(this.largeAreaMinX, frame.minX)) > (intersectionMaxX = Math.min(this.largeAreaMaxX, frame.maxX))) continue;
            int length = (int)(intersectionMaxX - intersectionMinX + 1L);
            PArray frameArray = (PArray)frame.channel0.array();
            long frameDimX = frame.dimX;
            int x = (int)(intersectionMinX - this.largeAreaMinX);
            long frameX = intersectionMinX - frame.minX;
            long frameP = (this.largeAreaMinY + (long)i - frame.minY) * frameDimX + frameX;
            this.readFrameLine(frameArray, p, frameP, length);
            if (insideSmallFrameByY) {
                to = p + length;
                for (p = x + disp; p < to; ++p) {
                    boolean insideSmallOrCompleted;
                    label = this.dynamicDisjointSet.parentOrThis(this.labels[p]);
                    boolean insideSmallFrame = x >= this.smallMinX && x <= this.smallMaxX;
                    boolean bl = insideSmallOrCompleted = insideSmallFrame || this.reindexedCompleted.get(label);
                    if (!insideSmallOrCompleted || this.reindexedBoundaryWithOutside.get(label)) {
                        this.labels[p] = 0;
                    } else {
                        this.labels[p] = label;
                        if (crop && label != 0) {
                            if (minX == Integer.MAX_VALUE) {
                                minX = x;
                            }
                            maxX = x;
                        }
                    }
                    ++x;
                }
                continue;
            }
            to = p + length;
            while (p < to) {
                label = this.dynamicDisjointSet.parentOrThis(this.labels[p]);
                boolean completed = this.reindexedCompleted.get(label);
                if (!completed || this.reindexedBoundaryWithOutside.get(label)) {
                    this.labels[p] = 0;
                } else {
                    this.labels[p] = label;
                    if (crop && label != 0) {
                        if (minX == Integer.MAX_VALUE) {
                            minX = x;
                        }
                        maxX = x;
                    }
                }
                ++x;
                ++p;
            }
        }
        if (crop) {
            this.minNonZeroX[i] = minX;
            this.maxNonZeroX[i] = maxX;
        }
    }

    void readFrameLine(PArray frameArray, int p, long frameP, int length) {
        frameArray.getData(frameP, (Object)this.labels, p, length);
    }

    static MapBuffer.Frame crop(MapBuffer.Frame frame, int[] minNonZeroX, int[] maxNonZeroX) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int y = 0; y < minNonZeroX.length; ++y) {
            minX = Math.min(minX, minNonZeroX[y]);
            maxX = Math.max(maxX, maxNonZeroX[y]);
            if (maxNonZeroX[y] < 0) continue;
            if (minY == Integer.MAX_VALUE) {
                minY = y;
            }
            maxY = y;
        }
        Matrix m = frame.matrix().channel(0);
        if (minX == 0 && minY == 0 && (long)maxX == m.dimX() - 1L && (long)maxY == m.dimY() - 1L) {
            return frame;
        }
        if (maxY < 0) {
            minX = 0;
            minY = 0;
            maxX = (int)Math.min(1L, m.dimX()) - 1;
            maxY = (int)Math.min(1L, m.dimY()) - 1;
        }
        return new MapBuffer.Frame(frame.position().min().add(IPoint.valueOf((long)minX, (long)minY)), (MultiMatrix)MultiMatrix.of2DMono((Matrix)m.subMatrix((long)minX, (long)minY, (long)(maxX + 1), (long)(maxY + 1))));
    }

    private static class ReindexerAndRetainerNonInt
    extends ReindexerAndRetainer {
        private ReindexerAndRetainerNonInt(IRectangularArea largeArea, List<MapBuffer.Frame> frames, IRectangularArea smallFrameArea, DynamicDisjointSet dynamicDisjointSet, QuickLabelsSet reindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside, boolean jointingAutoCrop) {
            super(largeArea, frames, smallFrameArea, dynamicDisjointSet, reindexedCompleted, reindexedBoundaryWithOutside, jointingAutoCrop);
        }

        @Override
        void readFrameLine(PArray frameArray, int p, long frameP, int length) {
            Arrays.applyFunc(null, (Func)Func.IDENTITY, (UpdatablePArray)this.labelsArray.subArr((long)p, (long)length), (PArray[])new PArray[]{(PArray)frameArray.subArr(frameP, (long)length)});
        }
    }

    private static class ReindexerAndRetainerDirectAccessible
    extends ReindexerAndRetainer {
        private ReindexerAndRetainerDirectAccessible(IRectangularArea largeArea, List<MapBuffer.Frame> frames, IRectangularArea smallFrameArea, DynamicDisjointSet dynamicDisjointSet, QuickLabelsSet reindexedCompleted, QuickLabelsSet reindexedBoundaryWithOutside, boolean jointingAutoCrop) {
            super(largeArea, frames, smallFrameArea, dynamicDisjointSet, reindexedCompleted, reindexedBoundaryWithOutside, jointingAutoCrop);
        }

        @Override
        void processSingleLine(int i) {
            boolean crop = this.jointingAutoCrop;
            boolean insideSmallFrameByY = i >= this.smallMinY && i <= this.smallMaxY;
            long y = this.largeAreaMinY + (long)i;
            int disp = i * this.dimX;
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            for (MapBuffer.Frame frame : this.frames) {
                int frameP;
                long intersectionMaxX;
                long intersectionMinX;
                if (y < frame.minY || y > frame.maxY || (intersectionMinX = Math.max(this.largeAreaMinX, frame.minX)) > (intersectionMaxX = Math.min(this.largeAreaMaxX, frame.maxX))) continue;
                int length = (int)(intersectionMaxX - intersectionMinX + 1L);
                int[] frameArray = frame.channel0Ints;
                assert (frameArray != null);
                long frameDimX = frame.dimX;
                int x = (int)(intersectionMinX - this.largeAreaMinX);
                long frameX = intersectionMinX - frame.minX;
                int p = x + disp;
                int difference = p - frameP;
                if (insideSmallFrameByY) {
                    int to = frameP + length;
                    for (frameP = (int)((this.largeAreaMinY + (long)i - frame.minY) * frameDimX + frameX); frameP < to; ++frameP) {
                        boolean insideSmallOrCompleted;
                        int label = this.dynamicDisjointSet.parentOrThis(frameArray[frameP]);
                        boolean insideSmallFrame = x >= this.smallMinX && x <= this.smallMaxX;
                        boolean bl = insideSmallOrCompleted = insideSmallFrame || this.reindexedCompleted.get(label);
                        if (insideSmallOrCompleted && !this.reindexedBoundaryWithOutside.get(label)) {
                            this.labels[frameP + difference] = label;
                            if (crop && label != 0) {
                                if (minX == Integer.MAX_VALUE) {
                                    minX = x;
                                }
                                maxX = x;
                            }
                        }
                        ++x;
                    }
                    continue;
                }
                int differenceMinusDisp = difference - disp;
                assert (differenceMinusDisp == x - frameP);
                int to = frameP + length;
                while (frameP < to) {
                    int label = this.dynamicDisjointSet.parentOrThis(frameArray[frameP]);
                    boolean completed = this.reindexedCompleted.get(label);
                    if (completed && !this.reindexedBoundaryWithOutside.get(label)) {
                        this.labels[frameP + difference] = label;
                        if (crop && label != 0) {
                            maxX = frameP + differenceMinusDisp;
                            if (minX == Integer.MAX_VALUE) {
                                minX = maxX;
                            }
                        }
                    }
                    ++frameP;
                }
            }
            if (crop) {
                this.minNonZeroX[i] = minX;
                this.maxNonZeroX[i] = maxX;
            }
        }
    }
}

