/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import java.util.Locale;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.executors.modules.maps.frames.buffers.FrameObjectStitcher;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;

public final class ReadLastFrameFromMapBuffer
extends ScalarFilter {
    public static final String INPUT_CROPPING_CONTAINING_RECTANGLE = "cropping_containing_rectangle";
    public static final String OUTPUT_SEQUENTIAL_LABELS = "labels";
    public static final String OUTPUT_DIM_X = "dim_x";
    public static final String OUTPUT_DIM_Y = "dim_y";
    public static final String OUTPUT_RESTORING_TABLE = "restoring_table";
    private boolean jointCompletedObjects = false;
    private boolean jointExpansionInPercents = false;
    private Double jointExpansionX = null;
    private Double jointExpansionY = null;
    private boolean jointingAutoCrop = false;
    private int zeroPaddingX = 0;
    private Integer zeroPaddingY = null;
    private FrameObjectStitcher.JointingTooLargeObjects jointingTooLargeObjects = FrameObjectStitcher.JointingTooLargeObjects.SKIP;
    private boolean sequentiallyReindex = false;
    private boolean zeroBasedRestoringTable = false;

    public ReadLastFrameFromMapBuffer() {
        this.setDefaultInputScalar("map_buffer_id");
        this.addInputNumbers(INPUT_CROPPING_CONTAINING_RECTANGLE);
        this.setDefaultOutputScalar("map_buffer_id");
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputMat(OUTPUT_SEQUENTIAL_LABELS);
        this.addOutputScalar(OUTPUT_DIM_X);
        this.addOutputScalar(OUTPUT_DIM_Y);
        this.addOutputNumbers("rectangle");
        this.addOutputNumbers(OUTPUT_RESTORING_TABLE);
        this.addOutputNumbers("containing_rectangle");
    }

    public boolean isJointCompletedObjects() {
        return this.jointCompletedObjects;
    }

    public ReadLastFrameFromMapBuffer setJointCompletedObjects(boolean jointCompletedObjects) {
        this.jointCompletedObjects = jointCompletedObjects;
        return this;
    }

    public boolean isJointExpansionInPercents() {
        return this.jointExpansionInPercents;
    }

    public ReadLastFrameFromMapBuffer setJointExpansionInPercents(boolean jointExpansionInPercents) {
        this.jointExpansionInPercents = jointExpansionInPercents;
        return this;
    }

    public Double getJointExpansionX() {
        return this.jointExpansionX;
    }

    public ReadLastFrameFromMapBuffer setJointExpansionX(Double jointExpansionX) {
        this.jointExpansionX = jointExpansionX;
        return this;
    }

    public Double getJointExpansionY() {
        return this.jointExpansionY;
    }

    public ReadLastFrameFromMapBuffer setJointExpansionY(Double jointExpansionY) {
        this.jointExpansionY = jointExpansionY;
        return this;
    }

    public boolean isJointingAutoCrop() {
        return this.jointingAutoCrop;
    }

    public ReadLastFrameFromMapBuffer setJointingAutoCrop(boolean jointingAutoCrop) {
        this.jointingAutoCrop = jointingAutoCrop;
        return this;
    }

    public int getZeroPaddingX() {
        return this.zeroPaddingX;
    }

    public ReadLastFrameFromMapBuffer setZeroPaddingX(int zeroPaddingX) {
        this.zeroPaddingX = zeroPaddingX;
        return this;
    }

    public Integer getZeroPaddingY() {
        return this.zeroPaddingY;
    }

    public ReadLastFrameFromMapBuffer setZeroPaddingY(Integer zeroPaddingY) {
        this.zeroPaddingY = zeroPaddingY;
        return this;
    }

    public FrameObjectStitcher.JointingTooLargeObjects getJointingTooLargeObjects() {
        return this.jointingTooLargeObjects;
    }

    public ReadLastFrameFromMapBuffer setJointingTooLargeObjects(FrameObjectStitcher.JointingTooLargeObjects jointingTooLargeObjects) {
        this.jointingTooLargeObjects = (FrameObjectStitcher.JointingTooLargeObjects)((Object)ReadLastFrameFromMapBuffer.nonNull((Object)((Object)jointingTooLargeObjects)));
        return this;
    }

    public boolean isSequentiallyReindex() {
        return this.sequentiallyReindex;
    }

    public ReadLastFrameFromMapBuffer setSequentiallyReindex(boolean sequentiallyReindex) {
        this.sequentiallyReindex = sequentiallyReindex;
        return this;
    }

    public boolean isZeroBasedRestoringTable() {
        return this.zeroBasedRestoringTable;
    }

    public ReadLastFrameFromMapBuffer setZeroBasedRestoringTable(boolean zeroBasedRestoringTable) {
        this.zeroBasedRestoringTable = zeroBasedRestoringTable;
        return this;
    }

    public SScalar process(SScalar source) {
        long mapBufferId = source.toLong();
        MultiMatrix result = this.process(mapBufferId, this.getInputNumbers(INPUT_CROPPING_CONTAINING_RECTANGLE, true).toIRectangularArea());
        this.getMat(DEFAULT_OUTPUT_PORT).setTo(result);
        this.getScalar(OUTPUT_DIM_X).setTo(result.dim(0));
        this.getScalar(OUTPUT_DIM_Y).setTo(result.dim(1));
        return source;
    }

    public MultiMatrix process(long mapBufferId, IRectangularArea croppingRectangle) {
        long t4;
        IRectangularArea otherRectangle;
        MapBuffer.Frame result;
        FrameObjectStitcher stitcher;
        MapBufferKey mapBufferKey = MapBufferKey.getInstance(mapBufferId);
        MapBuffer mapBuffer = mapBufferKey.reqMapBuffer();
        boolean jointing = mapBuffer.isStitchingLabels() && this.jointCompletedObjects;
        long t1 = System.nanoTime();
        if (jointing) {
            IPoint expansion;
            stitcher = mapBuffer.getFrameObjectStitcher();
            stitcher.setJointingAutoCrop(this.jointingAutoCrop);
            stitcher.setJointingTooLargeObjects(this.jointingTooLargeObjects);
            IRectangularArea frameArea = mapBuffer.reqFirstFramePosition();
            if (this.jointExpansionX == null) {
                expansion = frameArea.size();
            } else {
                double jointExpansionY;
                double jointExpansionX = this.jointExpansionX;
                double d = jointExpansionY = this.jointExpansionY != null ? this.jointExpansionY : jointExpansionX;
                if (this.jointExpansionInPercents) {
                    jointExpansionX = jointExpansionX / 100.0 * (double)frameArea.sizeX();
                    jointExpansionY = jointExpansionY / 100.0 * (double)frameArea.sizeY();
                }
                expansion = IPoint.valueOf((long)Math.round(jointExpansionX), (long)Math.round(jointExpansionY));
            }
            result = stitcher.jointCompletedObjectsOfLastFrame(expansion);
            IPoint padding = IPoint.valueOf((long)this.zeroPaddingX, (long)(this.zeroPaddingY != null ? (long)this.zeroPaddingY.intValue() : (long)this.zeroPaddingX));
            otherRectangle = result.position().dilate(padding);
        } else {
            stitcher = null;
            result = mapBuffer.reqLastFrame();
            otherRectangle = result.position();
        }
        if (croppingRectangle != null && (otherRectangle = otherRectangle.intersection(croppingRectangle)) == null) {
            throw new IllegalArgumentException("The resulting frame rectangle " + String.valueOf(otherRectangle) + " does not intersect containing cropping rectangle " + String.valueOf(croppingRectangle));
        }
        long t2 = System.nanoTime();
        result = result.subFrameWithZeroContinuation(otherRectangle).actualizeLazyMatrix();
        long t3 = System.nanoTime();
        if (this.sequentiallyReindex) {
            MapBuffer.Frame.ReindexedFrame sequential = result.sequentiallyReindex(this.zeroBasedRestoringTable);
            t4 = System.nanoTime();
            this.getMat(OUTPUT_SEQUENTIAL_LABELS).setTo(sequential.reindexed().matrix());
            this.getNumbers(OUTPUT_RESTORING_TABLE).setTo(sequential.sequentialResrotingTable(), 1);
        } else {
            t4 = t3;
        }
        if (LOGGABLE_DEBUG) {
            ReadLastFrameFromMapBuffer.logDebug((String)String.format(Locale.US, "%s %s at %s from %s (%s): %.3f ms = %s + %.3f ms actualizing %s", jointing ? "Jointing" : "Reading", result.matrix(), result.position(), mapBufferKey, mapBuffer, (double)(t4 - t1) * 1.0E-6, stitcher == null ? String.format(Locale.US, "%.3f ms reading", (double)(t2 - t1) * 1.0E-6) : stitcher.jointTimeInfo(), (double)(t3 - t2) * 1.0E-6, this.sequentiallyReindex ? String.format(Locale.US, "+ %.3f ms sequential reindex", (double)(t4 - t3) * 1.0E-6) : "(no reindex)"));
        }
        this.getNumbers("rectangle").setTo(result.position());
        if (this.isOutputNecessary("containing_rectangle")) {
            this.getNumbers("containing_rectangle").setTo(mapBuffer.containingRectangle());
        }
        return result.matrix();
    }

    public String visibleOutputPortName() {
        return DEFAULT_OUTPUT_PORT;
    }
}

