/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import java.util.Arrays;
import java.util.BitSet;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;
import net.algart.executors.modules.maps.frames.joints.ObjectPairs;

public final class MapBufferCorrelationTable
extends ScalarFilter {
    public static final String STITCHING_MAP = "stitching_map";
    public static final String PARTIAL_SET = "partial_set";
    public static final String RAW_PARTIAL_SET = "raw_partial_set";
    public static final String OBJECT_PAIRS = "object_pairs";
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;

    public MapBufferCorrelationTable() {
        this.setDefaultInputScalar("map_buffer_id");
        this.setDefaultOutputScalar("map_buffer_id");
        this.addOutputNumbers(STITCHING_MAP);
        this.addOutputNumbers(PARTIAL_SET);
        this.addOutputNumbers(RAW_PARTIAL_SET);
        this.addOutputNumbers(OBJECT_PAIRS);
        this.addOutputScalar("number_of_objects");
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public MapBufferCorrelationTable setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)MapBufferCorrelationTable.nonNull((Object)indexingBase);
        return this;
    }

    public SScalar process(SScalar source) {
        MapBuffer mapBuffer = MapBufferKey.getInstance(source.toLong()).reqMapBuffer();
        ObjectPairs objectPairs = mapBuffer.objectPairs();
        int[] stitchingMap = this.stitchingMap(objectPairs.reindexTable());
        this.getNumbers(STITCHING_MAP).setTo(stitchingMap, 1);
        this.getNumbers(OBJECT_PAIRS).setTo(objectPairs.pairsArray(), 2);
        int numberOfObjects = mapBuffer.numberOfObjects();
        this.getScalar("number_of_objects").setTo(numberOfObjects);
        if (this.isOutputNecessary(PARTIAL_SET) || this.isOutputNecessary(RAW_PARTIAL_SET)) {
            this.getNumbers(RAW_PARTIAL_SET).setTo(MapBufferCorrelationTable.toBytes(mapBuffer.rawPartialObjects(), numberOfObjects), 1);
            this.getNumbers(PARTIAL_SET).setTo(MapBufferCorrelationTable.toBytes(mapBuffer.reindexPartialObjects(), numberOfObjects), 1);
        }
        return source;
    }

    public String visibleOutputPortName() {
        return STITCHING_MAP;
    }

    private static byte[] toBytes(BitSet bitSet, int length) {
        byte[] result = new byte[length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = bitSet.get(k) ? (byte)1 : 0;
        }
        return result;
    }

    private int[] stitchingMap(int[] reindexTable) {
        if (this.indexingBase.start >= reindexTable.length) {
            return new int[0];
        }
        return Arrays.copyOfRange(reindexTable, this.indexingBase.start, reindexTable.length);
    }
}

