/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import net.algart.executors.api.Executor;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;

public final class InitializeMapBuffer
extends Executor {
    public static final String MAP_BUFFER_ID = "map_buffer_id";
    public static final String NUMBER_OF_OBJECTS = "number_of_objects";
    private final MapBufferKey mapBufferKey;
    private boolean clearOnReset = false;
    private int numberOfStoredFrames = 1;
    private boolean stitchingLabels = false;
    private boolean autoReindexLabels = false;
    private boolean zerosLabelReservedForBackground = true;
    private boolean resetIndexing = true;

    public InitializeMapBuffer() {
        this.setDefaultOutputScalar(MAP_BUFFER_ID);
        this.addOutputScalar(NUMBER_OF_OBJECTS);
        this.mapBufferKey = MapBufferKey.getUniqueInstance();
    }

    public boolean isClearOnReset() {
        return this.clearOnReset;
    }

    public InitializeMapBuffer setClearOnReset(boolean clearOnReset) {
        this.clearOnReset = clearOnReset;
        return this;
    }

    public int getNumberOfStoredFrames() {
        return this.numberOfStoredFrames;
    }

    public InitializeMapBuffer setNumberOfStoredFrames(int numberOfStoredFrames) {
        this.numberOfStoredFrames = InitializeMapBuffer.positive((int)numberOfStoredFrames);
        return this;
    }

    public boolean isStitchingLabels() {
        return this.stitchingLabels;
    }

    public InitializeMapBuffer setStitchingLabels(boolean stitchingLabels) {
        this.stitchingLabels = stitchingLabels;
        return this;
    }

    public boolean isAutoReindexLabels() {
        return this.autoReindexLabels;
    }

    public InitializeMapBuffer setAutoReindexLabels(boolean autoReindexLabels) {
        this.autoReindexLabels = autoReindexLabels;
        return this;
    }

    public boolean isZerosLabelReservedForBackground() {
        return this.zerosLabelReservedForBackground;
    }

    public InitializeMapBuffer setZerosLabelReservedForBackground(boolean zerosLabelReservedForBackground) {
        this.zerosLabelReservedForBackground = zerosLabelReservedForBackground;
        return this;
    }

    public boolean isResetIndexing() {
        return this.resetIndexing;
    }

    public InitializeMapBuffer setResetIndexing(boolean resetIndexing) {
        this.resetIndexing = resetIndexing;
        return this;
    }

    public void initialize() {
        MapBuffer mapBuffer;
        if (this.clearOnReset && (mapBuffer = this.mapBufferKey.getOrCreateMapBuffer()) != null) {
            mapBuffer.clear(this.resetIndexing);
        }
    }

    public void process() {
        InitializeMapBuffer.logDebug(() -> "Newly created " + String.valueOf(this.mapBufferKey) + "; " + MapBufferKey.numberOfStoredMapBuffers() + " existing map buffers");
        MapBuffer mapBuffer = this.mapBufferKey.getOrCreateMapBuffer();
        mapBuffer.setMaximalNumberOfStoredFrames(this.numberOfStoredFrames);
        mapBuffer.setStitchingLabels(this.stitchingLabels);
        mapBuffer.setAutoReindexLabels(this.autoReindexLabels);
        mapBuffer.setZerosLabelReservedForBackground(this.zerosLabelReservedForBackground);
        this.getScalar(NUMBER_OF_OBJECTS).setTo(mapBuffer.numberOfObjects());
        this.getScalar().setTo(this.mapBufferKey.mapBufferId());
    }
}

