/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;

public final class ClearMapBuffer
extends ScalarFilter {
    private Stage stage = Stage.RESET;
    private boolean doAction = true;
    private boolean resetIndexing = true;

    public ClearMapBuffer() {
        this.setDefaultInputScalar("map_buffer_id");
        this.setDefaultOutputScalar("map_buffer_id");
        this.addOutputScalar("number_of_objects");
    }

    public Stage getStage() {
        return this.stage;
    }

    public ClearMapBuffer setStage(Stage stage) {
        this.stage = (Stage)((Object)ClearMapBuffer.nonNull((Object)((Object)stage)));
        return this;
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public ClearMapBuffer setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public boolean isResetIndexing() {
        return this.resetIndexing;
    }

    public ClearMapBuffer setResetIndexing(boolean resetIndexing) {
        this.resetIndexing = resetIndexing;
        return this;
    }

    public void initialize() {
        if (this.doAction && this.stage == Stage.RESET) {
            long mapBufferId = this.getInputScalar("map_buffer_id").toLong();
            MapBuffer mapBuffer = MapBufferKey.getInstance(mapBufferId).getMapBuffer();
            this.clear(mapBuffer);
        }
    }

    public SScalar process(SScalar source) {
        long mapBufferId = source.toLong();
        MapBuffer mapBuffer = MapBufferKey.getInstance(mapBufferId).getMapBuffer();
        if (this.doAction && this.stage == Stage.EXECUTE) {
            this.clear(mapBuffer);
        }
        this.getScalar("number_of_objects").setTo(mapBuffer.numberOfObjects());
        return source;
    }

    public void clear(MapBuffer mapBuffer) {
        if (mapBuffer != null) {
            mapBuffer.clear(this.resetIndexing);
        }
    }

    public static enum Stage {
        RESET,
        EXECUTE;

    }
}

