/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CalcASTFlagsVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.CalcASTPropsVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.QuantifiableTerm;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.SubexpressionCall;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.CopyVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.InitIDVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.MarkLookBehindEntriesVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.NodeCountVisitor;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PropagateDeadFlagVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import java.util.ArrayList;

public class RegexASTPostProcessor {
    private final RegexAST ast;
    private final RegexProperties properties;
    private final RegexFlags flags;
    private final CompilationBuffer compilationBuffer;

    public RegexASTPostProcessor(RegexAST ast, CompilationBuffer compilationBuffer) {
        this.ast = ast;
        this.properties = ast.getProperties();
        this.flags = ast.getFlags();
        this.compilationBuffer = compilationBuffer;
    }

    public void prepareForDFA() {
        CalcASTFlagsVisitor.run(this.ast);
        if (this.ast.getOptions().isBooleanMatch()) {
            DisableCaptureGroupsVisitor.disableCaptureGroups(this.ast);
        }
        OptimizeLookAroundsVisitor.optimizeLookArounds(this.ast, this.compilationBuffer);
        if (this.properties.hasQuantifiers()) {
            UnrollQuantifiersVisitor.unrollQuantifiers(this.ast);
        }
        CalcASTPropsVisitor.run(this.ast, this.compilationBuffer);
        PropagateDeadFlagVisitor.propagateDeadFlag(this.ast.getRoot());
        this.ast.createPrefix();
        InitIDVisitor.init(this.ast);
        if (this.ast.canTransformToDFA()) {
            new MarkLookBehindEntriesVisitor(this.ast).run();
        }
        this.checkInnerLiteral();
    }

    private void checkInnerLiteral() {
        if (this.ast.isLiteralString() || this.ast.getRoot().startsWithCaret() || this.ast.getRoot().endsWithDollar() || this.ast.getRoot().size() != 1 || this.flags.isSticky()) {
            return;
        }
        ArrayList<Term> terms = this.ast.getRoot().getFirstAlternative().getTerms();
        int literalStart = -1;
        int literalEnd = -1;
        for (int i = 0; i < terms.size(); ++i) {
            Term t = terms.get(i);
            if (this.isLiteralChar(t)) {
                assert (!t.hasLoops());
                if (literalStart < 0) {
                    literalStart = i;
                }
                literalEnd = i + 1;
                continue;
            }
            if (literalStart >= 0 || t.hasBackReferences()) break;
        }
        if (literalStart >= 0 && (literalStart > 0 || literalEnd - literalStart > 0)) {
            this.properties.setInnerLiteral(literalStart, literalEnd);
        }
    }

    private boolean isLiteralChar(Term t) {
        return !(!t.isCharacterClass() || !t.asCharacterClass().getCharSet().matchesSingleChar() && !t.asCharacterClass().getCharSet().matches2CharsWith1BitDifference() || !this.ast.getEncoding().isFixedCodePointWidth(t.asCharacterClass().getCharSet()) || this.ast.getEncoding() == Encodings.UTF_16 && t.asCharacterClass().getCharSet().intersects(Constants.SURROGATES));
    }

    private static final class DisableCaptureGroupsVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private final RegexAST ast;

        private DisableCaptureGroupsVisitor(RegexAST ast) {
            this.ast = ast;
        }

        public static void disableCaptureGroups(RegexAST ast) {
            new DisableCaptureGroupsVisitor(ast).run(ast.getRoot());
        }

        @Override
        protected void visit(Group group) {
            if (group.isCapturing() && !this.ast.isGroupReferenced(group.getGroupNumber()) && (group.getGroupNumber() != 0 || !this.ast.getProperties().hasMatchBoundaryAssertions() && !this.ast.getOptions().isMustAdvance())) {
                group.clearGroupNumber();
            }
        }
    }

    private static final class OptimizeLookAroundsVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private final RegexAST ast;
        private final CompilationBuffer compilationBuffer;
        private final NodeCountVisitor countVisitor = new NodeCountVisitor();

        private OptimizeLookAroundsVisitor(RegexAST ast, CompilationBuffer compilationBuffer) {
            this.ast = ast;
            this.compilationBuffer = compilationBuffer;
        }

        public static void optimizeLookArounds(RegexAST ast, CompilationBuffer compilationBuffer) {
            new OptimizeLookAroundsVisitor(ast, compilationBuffer).run(ast.getRoot());
        }

        @Override
        protected void leave(Sequence sequence) {
            block5: for (int i = 0; i < sequence.size(); ++i) {
                Term term = sequence.get(i);
                if (!term.isLookAroundAssertion()) continue;
                LookAroundOptimization opt = this.optimizeLookAround((LookAroundAssertion)term);
                switch (opt.action.ordinal()) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        sequence.removeTerm(i, this.compilationBuffer);
                        --i;
                        continue block5;
                    }
                    case 2: {
                        sequence.replace(i, opt.replacement);
                    }
                }
            }
        }

        private LookAroundOptimization optimizeLookAround(LookAroundAssertion lookaround) {
            Group group = lookaround.getGroup();
            boolean hasCaptureGroups = false;
            for (int i = 0; i < group.size(); ++i) {
                Sequence s = group.getAlternatives().get(i);
                hasCaptureGroups |= s.hasCaptureGroups() && !s.isEmpty();
                if (!s.isEmpty()) continue;
                if (lookaround.isNegated()) {
                    this.ast.getNodeCount().dec(this.countVisitor.count(lookaround));
                    return LookAroundOptimization.replace(this.ast.createCharacterClass(CodePointSet.getEmpty()));
                }
                if (hasCaptureGroups) {
                    if (group.size() <= i + 1) break;
                    group.getAlternatives().subList(i + 1, group.size()).clear();
                    break;
                }
                this.ast.getNodeCount().dec(this.countVisitor.count(lookaround));
                return LookAroundOptimization.NO_OP;
            }
            if (!lookaround.isNegated() && !lookaround.hasCaptureGroups()) {
                if (group.size() == 1 && group.getFirstAlternative().size() == 1 && group.getFirstAlternative().getFirstTerm().isPositionAssertion()) {
                    this.ast.getNodeCount().dec(this.countVisitor.count(lookaround));
                    PositionAssertion positionAssertion = (PositionAssertion)group.getFirstAlternative().getFirstTerm();
                    this.ast.register(positionAssertion);
                    return LookAroundOptimization.replace(positionAssertion);
                }
                int innerPositionAssertion = -1;
                for (int i = 0; i < group.size(); ++i) {
                    Sequence s = group.getAlternatives().get(i);
                    if (s.size() != 1 || !s.getFirstTerm().isPositionAssertion()) continue;
                    innerPositionAssertion = i;
                    break;
                }
                if (innerPositionAssertion >= 0) {
                    Sequence removed = group.getAlternatives().remove(innerPositionAssertion);
                    Group wrapGroup = this.ast.createGroup();
                    wrapGroup.setEnclosedCaptureGroupsLo(group.getCaptureGroupsLo());
                    wrapGroup.setEnclosedCaptureGroupsHi(group.getCaptureGroupsHi());
                    wrapGroup.add(removed);
                    Sequence wrapSeq = wrapGroup.addSequence(this.ast);
                    assert (!group.isEmpty());
                    wrapSeq.add(lookaround);
                    return LookAroundOptimization.replace(wrapGroup);
                }
            }
            if (lookaround.isNegated() && group.size() == 1 && group.getFirstAlternative().isSingleCharClass()) {
                CharacterClass cc = group.getFirstAlternative().getFirstTerm().asCharacterClass();
                assert (!this.ast.getFlags().isEitherUnicode() || !this.ast.getOptions().isUTF16ExplodeAstralSymbols() || cc.getCharSet().matchesNothing() || cc.getCharSet().getMax() <= 65535);
                if (cc.getCharSet().isEmpty()) {
                    return LookAroundOptimization.NO_OP;
                }
                Group wrapGroup = this.ast.createGroup();
                Sequence positionAssertionSeq = wrapGroup.addSequence(this.ast);
                positionAssertionSeq.add(this.ast.createPositionAssertion(lookaround.isLookAheadAssertion() ? PositionAssertion.Type.DOLLAR : PositionAssertion.Type.CARET));
                Sequence wrapSeq = wrapGroup.addSequence(this.ast);
                wrapSeq.add(lookaround);
                lookaround.setNegated(false);
                cc.setCharSet(cc.getCharSet().createInverse(this.ast.getEncoding()));
                return LookAroundOptimization.replace(wrapGroup);
            }
            return LookAroundOptimization.NONE;
        }

        private static final class LookAroundOptimization {
            private static final LookAroundOptimization NONE = new LookAroundOptimization(Action.NONE, null);
            private static final LookAroundOptimization NO_OP = new LookAroundOptimization(Action.NO_OP, null);
            private final Action action;
            private final Term replacement;

            private LookAroundOptimization(Action action, Term replacement) {
                this.action = action;
                this.replacement = replacement;
            }

            private static LookAroundOptimization replace(Term replacement) {
                return new LookAroundOptimization(Action.REPLACE, replacement);
            }

            private static enum Action {
                NONE,
                NO_OP,
                REPLACE;

            }
        }
    }

    private static final class UnrollQuantifiersVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private final RegexAST ast;
        private final ShouldUnrollQuantifierVisitor shouldUnrollVisitor = new ShouldUnrollQuantifierVisitor();
        private final QuantifierExpander quantifierExpander;

        private UnrollQuantifiersVisitor(RegexAST ast) {
            this.ast = ast;
            this.quantifierExpander = new QuantifierExpander(ast);
        }

        public static void unrollQuantifiers(RegexAST ast) {
            new UnrollQuantifiersVisitor(ast).run(ast.getRoot());
        }

        @Override
        protected void visit(BackReference backReference) {
            if (backReference.hasQuantifier()) {
                this.quantifierExpander.expandQuantifier(backReference, this.shouldUnroll(backReference));
            }
        }

        @Override
        protected void visit(CharacterClass characterClass) {
            if (characterClass.hasQuantifier()) {
                this.quantifierExpander.expandQuantifier(characterClass, this.shouldUnroll(characterClass));
            }
        }

        @Override
        protected void leave(Group group) {
            if (group.hasQuantifier()) {
                this.quantifierExpander.expandQuantifier(group, group.getQuantifier().isUnrollTrivial() || this.shouldUnroll(group) && this.shouldUnrollVisitor.shouldUnroll(group));
            }
        }

        @Override
        protected void visit(SubexpressionCall subexpressionCall) {
            throw CompilerDirectives.shouldNotReachHere((String)"subexpression calls should be expanded by the parser");
        }

        private boolean shouldUnroll(QuantifiableTerm term) {
            return term.getQuantifier().isUnrollTrivial() || this.ast.getNumberOfNodes() <= 4000 && term.isUnrollingCandidate();
        }

        private static final class ShouldUnrollQuantifierVisitor
        extends DepthFirstTraversalRegexASTVisitor {
            private Group root;
            private boolean result;

            private ShouldUnrollQuantifierVisitor() {
            }

            boolean shouldUnroll(Group group) {
                assert (group.hasQuantifier());
                this.result = true;
                this.root = group;
                this.run(group);
                return this.result;
            }

            @Override
            protected void visit(BackReference backReference) {
                this.result = false;
            }

            @Override
            protected void visit(Group group) {
                if (group != this.root && group.hasNotUnrolledQuantifier()) {
                    this.result = false;
                }
            }
        }

        private static final class QuantifierExpander {
            private final RegexAST ast;
            private final CopyVisitor copyVisitor;
            private final ClearRegisteredCaptureGroupsVisitor clearRegisteredCaptureGroupsVisitor;
            private Group curGroup;
            private Sequence curSequence;
            private Term curTerm;

            QuantifierExpander(RegexAST ast) {
                this.ast = ast;
                this.copyVisitor = new CopyVisitor(ast);
                this.clearRegisteredCaptureGroupsVisitor = new ClearRegisteredCaptureGroupsVisitor(ast);
            }

            private void pushGroup() {
                this.curGroup = this.ast.createGroup();
                this.curSequence.add(this.curGroup);
                this.nextSequence();
            }

            private void replaceCurTermWithNewGroup() {
                this.curGroup = this.ast.createGroup();
                this.curSequence.replace(this.curTerm.getSeqIndex(), this.curGroup);
                this.nextSequence();
            }

            private void popGroup() {
                this.curTerm = this.curGroup;
                this.curSequence = this.curGroup.getParent().asSequence();
                this.curGroup = this.curSequence.getParent();
            }

            private void nextSequence() {
                this.curSequence = this.curGroup.addSequence(this.ast);
                this.curTerm = null;
            }

            private void addTerm(Term term) {
                this.curSequence.add(term);
                this.curTerm = term;
            }

            private void addTermCopyAsGroup(Term term) {
                if (term.isGroup()) {
                    this.addTerm(this.copyVisitor.copy(term));
                } else {
                    this.pushGroup();
                    this.addTerm(this.copyVisitor.copy(term));
                    this.popGroup();
                    if (term.isGroup()) {
                        this.curTerm.asGroup().setEnclosedCaptureGroupsLo(term.asGroup().getCaptureGroupsLo());
                        this.curTerm.asGroup().setEnclosedCaptureGroupsHi(term.asGroup().getCaptureGroupsHi());
                    }
                }
            }

            private void createOptionalBranch(QuantifiableTerm term, Token.Quantifier quantifier, boolean unroll, boolean mandatory, boolean optional, int recurse) {
                if (term.isInLookBehindAssertion()) {
                    this.createOptional(term, quantifier, unroll, mandatory, optional, recurse - 1);
                }
                this.addTermCopyAsGroup(term);
                this.curTerm.asGroup().setQuantifier(quantifier);
                this.curTerm.setExpandedQuantifier(unroll);
                this.curTerm.setMandatoryQuantifier(mandatory);
                this.curTerm.setOptionalQuantifier(optional);
                this.curTerm.setEmptyGuard(true);
                if (!term.isInLookBehindAssertion()) {
                    this.createOptional(term, quantifier, unroll, mandatory, optional, recurse - 1);
                }
            }

            private void createOptional(QuantifiableTerm term, Token.Quantifier quantifier, boolean unroll, boolean mandatory, boolean optional, int recurse) {
                if (recurse < 0) {
                    return;
                }
                this.pushGroup();
                if (term.isGroup()) {
                    this.curGroup.setEnclosedCaptureGroupsLo(term.asGroup().getCaptureGroupsLo());
                    this.curGroup.setEnclosedCaptureGroupsHi(term.asGroup().getCaptureGroupsHi());
                }
                if (quantifier.isGreedy() || mandatory) {
                    this.createOptionalBranch(term, quantifier, unroll, mandatory, optional, recurse);
                    this.nextSequence();
                    this.curSequence.setQuantifierPassThroughSequence(true);
                } else {
                    this.curSequence.setQuantifierPassThroughSequence(true);
                    this.nextSequence();
                    this.createOptionalBranch(term, quantifier, unroll, false, optional, recurse);
                }
                if (!unroll && !mandatory && recurse == 0) {
                    this.curGroup.setLoop(true);
                }
                this.popGroup();
            }

            private void expandQuantifier(QuantifiableTerm toExpand, boolean unroll) {
                boolean mandatoryOptionalSplit;
                assert (toExpand.hasQuantifier());
                assert (!unroll || toExpand.isUnrollingCandidate());
                this.clearRegisteredCaptureGroupsVisitor.clear(toExpand);
                Token.Quantifier quantifier = toExpand.getQuantifier();
                toExpand.setQuantifier(null);
                this.curTerm = toExpand;
                this.curSequence = (Sequence)this.curTerm.getParent();
                this.curGroup = this.curSequence.getParent();
                this.replaceCurTermWithNewGroup();
                boolean bl = mandatoryOptionalSplit = !unroll && !this.ast.getFlavor().emptyChecksOnMandatoryLoopIterations() && quantifier.getMin() > 0 && toExpand.mayMatchEmptyString();
                if (toExpand.isInLookBehindAssertion()) {
                    this.unrollOptional(toExpand, quantifier, unroll, mandatoryOptionalSplit);
                    this.unrollMandatory(toExpand, quantifier, unroll, mandatoryOptionalSplit);
                } else {
                    this.unrollMandatory(toExpand, quantifier, unroll, mandatoryOptionalSplit);
                    this.unrollOptional(toExpand, quantifier, unroll, mandatoryOptionalSplit);
                }
            }

            private void unrollMandatory(QuantifiableTerm toExpand, Token.Quantifier quantifier, boolean unroll, boolean mandatoryOptionalSplit) {
                if (unroll) {
                    for (int i = 0; i < quantifier.getMin(); ++i) {
                        this.addTermCopyAsGroup(toExpand);
                        this.curTerm.asGroup().setQuantifier(quantifier);
                        this.curTerm.setExpandedQuantifier(true);
                        this.curTerm.setMandatoryQuantifier(true);
                    }
                } else if (mandatoryOptionalSplit) {
                    this.createOptional(toExpand, quantifier, false, true, false, 0);
                    ((Group)this.curTerm).setLoop(true);
                }
            }

            private void unrollOptional(QuantifiableTerm toExpand, Token.Quantifier quantifier, boolean unroll, boolean mandatoryOptionalSplit) {
                if (unroll) {
                    this.createOptional(toExpand, quantifier, true, false, false, quantifier.isInfiniteLoop() ? 0 : quantifier.getMax() - quantifier.getMin() - 1);
                    if (quantifier.isInfiniteLoop()) {
                        ((Group)this.curTerm).setLoop(true);
                    }
                } else if (quantifier.isInfiniteLoop() || quantifier.getMax() > quantifier.getMin() || !mandatoryOptionalSplit) {
                    this.createOptional(toExpand, quantifier, false, false, mandatoryOptionalSplit, 0);
                }
            }
        }
    }

    private static final class ClearRegisteredCaptureGroupsVisitor
    extends DepthFirstTraversalRegexASTVisitor {
        private final RegexAST ast;

        private ClearRegisteredCaptureGroupsVisitor(RegexAST ast) {
            this.ast = ast;
        }

        public void clear(RegexASTNode root) {
            this.run(root);
        }

        @Override
        protected void visit(Group group) {
            if (group.isCapturing()) {
                this.ast.clearRegisteredCaptureGroups(group.getGroupNumber());
            }
        }
    }
}

